/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ozark.ext.stringtemplate;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mvc.engine.ViewEngineContext;
import javax.mvc.engine.ViewEngineException;
import javax.servlet.ServletContext;
import org.glassfish.ozark.engine.ViewEngineBase;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.STWriter;

@ApplicationScoped
public class StringTemplateViewEngine
extends ViewEngineBase {
    @Inject
    private ServletContext servletContext;

    public boolean supports(String view) {
        return view.endsWith(".st");
    }

    public void processView(ViewEngineContext context) throws ViewEngineException {
        ST stringTemplate = this.getStringTemplate(this.resolveView(context));
        context.getModels().forEach((key, value) -> this.add((String)key, value, stringTemplate));
        try {
            PrintWriter writer = context.getResponse().getWriter();
            stringTemplate.write((STWriter)new AutoIndentWriter((Writer)writer));
            stringTemplate.render();
        }
        catch (Exception e) {
            throw new ViewEngineException((Throwable)e);
        }
    }

    private void add(String key, Object value, ST template) {
        if (template.getAttributes().containsKey(key)) {
            template.add(key, value);
        }
    }

    public ST getStringTemplate(String resolvedView) throws ViewEngineException {
        String viewName;
        String viewFolder;
        ST template;
        Matcher matcher = Pattern.compile("(.+)/(.+)\\.st").matcher(resolvedView);
        if (matcher.find() && (template = new STGroupDir(viewFolder = this.servletContext.getRealPath(matcher.group(1)), '$', '$').getInstanceOf(viewName = matcher.group(2))) != null) {
            return template;
        }
        throw new ViewEngineException("Couldn't find view " + resolvedView);
    }
}

