/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.internal.Util;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigInstaller
implements ArtifactInstaller {
    private final BundleContext context;
    private final ConfigurationAdmin configAdmin;

    ConfigInstaller(BundleContext context, ConfigurationAdmin configAdmin) {
        this.context = context;
        this.configAdmin = configAdmin;
    }

    public boolean canHandle(File artifact) {
        return artifact.getName().endsWith(".cfg");
    }

    public void install(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void update(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void uninstall(File artifact) throws Exception {
        this.deleteConfig(artifact);
    }

    ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setConfig(File f) throws Exception {
        Properties p = new Properties();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        try {
            ((InputStream)in).mark(1);
            boolean isXml = ((InputStream)in).read() == 60;
            ((InputStream)in).reset();
            if (isXml) {
                p.loadFromXML(in);
            } else {
                p.load(in);
            }
        }
        finally {
            ((InputStream)in).close();
        }
        Util.performSubstitution(p);
        String[] pid = this.parsePid(f.getName());
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        ht.putAll(p);
        ht.put("felix.fileinstall.filename", f.getName());
        Configuration config = this.getConfiguration(pid[0], pid[1]);
        if (config.getBundleLocation() != null) {
            config.setBundleLocation(null);
        }
        config.update(ht);
        return true;
    }

    boolean deleteConfig(File f) throws Exception {
        String[] pid = this.parsePid(f.getName());
        Configuration config = this.getConfiguration(pid[0], pid[1]);
        config.delete();
        return true;
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.length() - 4);
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String pid, String factoryPid) throws Exception {
        Configuration oldConfiguration = this.findExistingConfiguration(pid, factoryPid);
        if (oldConfiguration != null) {
            Util.log(this.context, Util.getGlobalLogLevel(this.context), 4, "Updating configuration from " + pid + (factoryPid == null ? "" : "-" + factoryPid) + ".cfg", null);
            return oldConfiguration;
        }
        Configuration newConfiguration = factoryPid != null ? this.getConfigurationAdmin().createFactoryConfiguration(pid, null) : this.getConfigurationAdmin().getConfiguration(pid, null);
        return newConfiguration;
    }

    Configuration findExistingConfiguration(String pid, String factoryPid) throws Exception {
        String suffix = factoryPid == null ? ".cfg" : "-" + factoryPid + ".cfg";
        String filter = "(felix.fileinstall.filename=" + pid + suffix + ")";
        Configuration[] configurations = this.getConfigurationAdmin().listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }
}

