/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.api.amx.AMXConfigInfo;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBeanJMXSupport {
    private static final Map<String, String> CONFIGURED_BUGS = Collections.unmodifiableMap(MapUtil.newMap((String)"", (Object)""));
    private final Class<? extends ConfigBeanProxy> mIntf;
    private final List<AttributeMethodInfo> mAttrInfos = new ArrayList<AttributeMethodInfo>();
    private final List<ElementMethodInfo> mElemenInfos = new ArrayList<ElementMethodInfo>();
    private final List<DuckTypedInfo> mDuckTypedInfos = new ArrayList<DuckTypedInfo>();
    private final NameHint mNameHint;
    private final MBeanInfo mMBeanInfo;
    private final String mKey;
    private static final Set<Class<?>> REMOTABLE = SetUtil.newSet((Object[])new Class[]{String.class, ObjectName.class});
    public static final String ANONYMOUS_SUB_ELEMENT = "*";
    private static final String DEFAULT_NAME_HINT = "name";

    private boolean hasConfiguredBug() {
        return this.configuredBugKey() != null;
    }

    private String configuredBugKey() {
        String key = CONFIGURED_BUGS.get(this.mIntf.getName());
        return key;
    }

    private static String nameFromKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.startsWith("@")) {
            return key.substring(1);
        }
        if (key.startsWith("<")) {
            return key.substring(1, key.length() - 1);
        }
        throw new IllegalArgumentException(key);
    }

    ConfigBeanJMXSupport(ConfigBean configBean) {
        this(configBean.getProxyType(), ConfigBeanJMXSupport.nameFromKey(configBean.model.key));
    }

    ConfigBeanJMXSupport(Class<? extends ConfigBeanProxy> intf, String key) {
        this.mIntf = intf;
        this.mKey = key;
        this.findStuff(intf, this.mAttrInfos, this.mElemenInfos, this.mDuckTypedInfos);
        this.mMBeanInfo = this._getMBeanInfo();
        this.sanityCheckMBeanInfo();
        this.mNameHint = this.findNameHint();
        if (this.hasConfiguredBug() && key == null) {
            ImplUtil.getLogger().warning("ConfigBeanJMXSupport (AMX): working around @Configured bug for " + this.mIntf.getName() + ", using \"" + this.configuredBugKey() + "\" as the key attribute");
        }
    }

    private static Class<?> findDuck(Class<?> intf) {
        Class<?>[] candidates = intf.getClasses();
        Class<?> duck = null;
        for (Class<?> c : candidates) {
            if (!c.getName().endsWith("$Duck")) continue;
            ConfigBeanJMXSupport.debug("ConfigBeanJMXSupport: found Duck class: " + c.getName());
            duck = c;
        }
        return duck;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String DELIM = ", ";
        String NL = StringUtil.NEWLINE();
        buf.append(this.mIntf.getName() + " = ");
        buf.append(NL + "Attributes: {" + NL);
        for (AttributeMethodInfo attributeMethodInfo : this.mAttrInfos) {
            buf.append(attributeMethodInfo.attrName() + "/" + attributeMethodInfo.xmlName() + ", ");
        }
        buf.append(NL + "}" + NL + "Elements: {" + NL);
        for (ElementMethodInfo elementMethodInfo : this.mElemenInfos) {
            buf.append(elementMethodInfo.attrName() + "/" + elementMethodInfo.xmlName() + ", ");
        }
        Set<String> childTypes = this.childTypes().keySet();
        buf.append(NL + "}" + NL + "Child types: {" + NL);
        for (String type : childTypes) {
            buf.append(type + ", ");
        }
        buf.append(NL + "}" + NL + "DuckTyped: {" + NL);
        for (DuckTypedInfo info : this.mDuckTypedInfos) {
            buf.append(info + NL);
        }
        buf.append(NL + "}" + NL);
        return buf.toString();
    }

    public DuckTypedInfo findDuckTyped(String name, String[] types) {
        DuckTypedInfo info = null;
        for (DuckTypedInfo candidate : this.mDuckTypedInfos) {
            if (!candidate.name().equals(name) || types.length != candidate.signature().length) continue;
            for (int i = 0; i < types.length; ++i) {
            }
            ConfigBeanJMXSupport.debug("Matched DuckTyped method: " + name);
            info = candidate;
            break;
        }
        return info;
    }

    public static String typeFromName(String s) {
        String simpleName = s;
        int idx = s.lastIndexOf(".");
        if (idx >= 0) {
            simpleName = s.substring(idx + 1);
        }
        return Dom.convertName((String)simpleName);
    }

    public String getTypeString() {
        return this.getTypeString(this.mIntf);
    }

    public String getTypeString(Class<? extends ConfigBeanProxy> intf) {
        Package pkg = intf.getPackage();
        String simple = intf.getName().substring(pkg.getName().length() + 1, intf.getName().length());
        return ConfigBeanJMXSupport.typeFromName(simple);
    }

    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    private MBeanInfo _getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attrsList = new ArrayList<MBeanAttributeInfo>();
        for (AttributeMethodInfo info : this.mAttrInfos) {
            attrsList.add(this.attributeToMBeanAttributeInfo(info));
        }
        for (ElementMethodInfo e : this.mElemenInfos) {
            MBeanAttributeInfo attrInfo = this.elementToMBeanAttributeInfo(e.method());
            if (attrInfo == null) continue;
            attrsList.add(attrInfo);
        }
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attrsList.size()];
        attrsList.toArray(attrs);
        String classname = this.mIntf.getName();
        String description = "ConfigBean " + this.mIntf.getName();
        MBeanConstructorInfo[] constructors = null;
        MBeanOperationInfo[] operations = this.toMBeanOperationInfos();
        MBeanNotificationInfo[] notifications = null;
        DescriptorSupport descriptor = this.descriptor();
        MBeanInfo info = new MBeanInfo(classname, description, attrs, constructors, operations, notifications, descriptor);
        return info;
    }

    private boolean hasNameAttribute() {
        for (MBeanAttributeInfo attrInfo : this.getMBeanInfo().getAttributes()) {
            if (!"Name".equals(attrInfo.getName())) continue;
            return true;
        }
        return false;
    }

    private void sanityCheckMBeanInfo() {
        if (this.isSingleton() && this.hasNameAttribute()) {
            ImplUtil.getLogger().warning("ConfigBeanJMXSupport (AMX): @Configured interface " + this.mIntf.getName() + " has getName() which is not a key value.  Remove getName() or use @Attribute(key=true)");
        }
    }

    public boolean isSingleton() {
        if (this.mKey != null) {
            return false;
        }
        if (this.hasConfiguredBug()) {
            return false;
        }
        for (AttributeMethodInfo attributeMethodInfo : this.mAttrInfos) {
            if (!attributeMethodInfo.key()) continue;
            return false;
        }
        for (ElementMethodInfo elementMethodInfo : this.mElemenInfos) {
            if (!elementMethodInfo.key()) continue;
            return false;
        }
        return true;
    }

    boolean isLeaf() {
        return this.mElemenInfos.size() == 0;
    }

    private static boolean isRemoteableType(Class<?> clazz) {
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || REMOTABLE.contains(clazz)) {
            return true;
        }
        return ConfigBeanProxy.class.isAssignableFrom(clazz);
    }

    private static boolean isRemoteableDuckTyped(Method m, DuckTyped duckTyped) {
        Class<?>[] sig;
        Class<?> returnType = m.getReturnType();
        if (!ConfigBeanJMXSupport.isRemoteableType(returnType)) {
            return false;
        }
        for (Class<?> c : sig = m.getParameterTypes()) {
            if (ConfigBeanJMXSupport.isRemoteableType(c)) continue;
            return false;
        }
        return true;
    }

    private static Class<?> remoteType(Class<?> clazz) {
        if (ConfigBeanProxy.class.isAssignableFrom(clazz)) {
            return ObjectName.class;
        }
        return clazz;
    }

    private void findStuff(Class<? extends ConfigBeanProxy> intf, List<AttributeMethodInfo> attrs, List<ElementMethodInfo> elements, List<DuckTypedInfo> duckTyped) {
        for (Method m : intf.getMethods()) {
            AttributeMethodInfo a = AttributeMethodInfo.get(m);
            if (a != null) {
                attrs.add(a);
                continue;
            }
            ElementMethodInfo e = ElementMethodInfo.get(m);
            if (e != null) {
                elements.add(e);
                continue;
            }
            DuckTyped dt = m.getAnnotation(DuckTyped.class);
            if (dt == null || !ConfigBeanJMXSupport.isRemoteableDuckTyped(m, dt)) continue;
            duckTyped.add(new DuckTypedInfo(m, dt));
        }
    }

    public static String xmlName(MBeanAttributeInfo info, String defaultValue) {
        String value = (String)info.getDescriptor().getFieldValue("amx.configbean.xmlName");
        return value == null ? defaultValue : value;
    }

    public static boolean isKey(MBeanAttributeInfo info) {
        return (Boolean)info.getDescriptor().getFieldValue("amx.configbean.key");
    }

    public static String defaultValue(MBeanAttributeInfo info) {
        return (String)info.getDescriptor().getFieldValue("amx.configbean.defaultValue");
    }

    public Map<String, String> getToXMLNameMapping() {
        HashMap<String, String> m = new HashMap<String, String>();
        MBeanInfo info = this.getMBeanInfo();
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            m.put(attrInfo.getName(), ConfigBeanJMXSupport.xmlName(attrInfo, attrInfo.getName()));
        }
        return m;
    }

    public Map<String, String> getFromXMLNameMapping() {
        HashMap<String, String> m = new HashMap<String, String>();
        MBeanInfo info = this.getMBeanInfo();
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            m.put(ConfigBeanJMXSupport.xmlName(attrInfo, attrInfo.getName()), attrInfo.getName());
        }
        return m;
    }

    public static boolean isAttribute(MBeanAttributeInfo info) {
        String value = (String)info.getDescriptor().getFieldValue("amx.configbean.kind");
        return value == null || Attribute.class.getName().equals(value);
    }

    public static boolean isElement(MBeanAttributeInfo info) {
        String value = (String)info.getDescriptor().getFieldValue("amx.configbean.kind");
        return Element.class.getName().equals(value);
    }

    public static DescriptorSupport descriptor(Attribute a) {
        DescriptorSupport d = new DescriptorSupport();
        d.setField("amx.configbean.kind", Attribute.class.getName());
        if (!a.defaultValue().equals("\u0000")) {
            d.setField("amx.configbean.defaultValue", a.defaultValue());
        }
        d.setField("amx.configbean.key", a.key());
        d.setField("amx.configbean.required", a.required());
        d.setField("amx.configbean.reference", a.reference());
        d.setField("amx.configbean.variableExpansion", a.variableExpansion());
        d.setField("amx.configbean.dataType", a.dataType().getName());
        return d;
    }

    public static DescriptorSupport descriptor(Element e) {
        DescriptorSupport d = new DescriptorSupport();
        d.setField("amx.configbean.kind", Element.class.getName());
        d.setField("amx.configbean.key", e.key());
        d.setField("amx.configbean.required", e.required());
        d.setField("amx.configbean.reference", e.reference());
        d.setField("amx.configbean.variableExpansion", e.variableExpansion());
        return d;
    }

    public static DescriptorSupport descriptor(DuckTyped dt) {
        DescriptorSupport d = new DescriptorSupport();
        d.setField("amx.configbean.kind", DuckTyped.class.getName());
        return d;
    }

    private DescriptorSupport descriptor() {
        DescriptorSupport d = new DescriptorSupport();
        String amxInterfaceName = AMXConfigProxy.class.getName();
        AMXConfigInfo configInfo = this.mIntf.getAnnotation(AMXConfigInfo.class);
        if (configInfo != null && configInfo.amxInterfaceName().length() > 0) {
            String classname = configInfo.amxInterfaceName();
            String PREFIX = "com.sun.appserv.management.config";
            if (classname.startsWith("com.sun.appserv.management.config")) {
                classname = "org.glassfish.admin.amx.intf.config" + classname.substring("com.sun.appserv.management.config".length());
            }
            amxInterfaceName = classname;
        }
        d.setField("interfaceName", amxInterfaceName);
        d.setField("amx.genericInterfaceName", AMXConfigProxy.class.getName());
        d.setField("immutableInfo", true);
        d.setField("amx.group", "config");
        d.setField("amx.supportsAdoption", false);
        d.setField("amx.isSingleton", this.isSingleton());
        String[] subTypes = (String[])CollectionUtil.toArray(this.childTypes().keySet(), String.class);
        d.setField("amx.subTypes", subTypes);
        return d;
    }

    public final Set<String> requiredAttributeNames() {
        HashSet<String> s = new HashSet<String>();
        for (AttributeMethodInfo attributeMethodInfo : this.mAttrInfos) {
            if (!attributeMethodInfo.required()) continue;
            s.add(attributeMethodInfo.attrName());
        }
        for (ElementMethodInfo elementMethodInfo : this.mElemenInfos) {
            if (!elementMethodInfo.required()) continue;
            s.add(elementMethodInfo.attrName());
        }
        return s;
    }

    public MBeanOperationInfo duckTypedToMBeanOperationInfo(DuckTypedInfo info) {
        DescriptorSupport descriptor = ConfigBeanJMXSupport.descriptor(info.duckTyped());
        String name = info.name();
        Class<?> type = ConfigBeanJMXSupport.remoteType(info.returnType());
        String description = "@DuckTyped " + name + " of " + this.mIntf.getName();
        boolean impact = false;
        ArrayList<MBeanParameterInfo> paramInfos = new ArrayList<MBeanParameterInfo>();
        int i = 0;
        for (Class<?> paramClass : info.signature()) {
            String paramName = "p" + i;
            String paramType = ConfigBeanJMXSupport.remoteType(paramClass).getName();
            String paramDescription = "parameter " + i;
            Descriptor paramDescriptor = null;
            MBeanParameterInfo paramInfo = new MBeanParameterInfo(paramName, paramType, paramDescription, paramDescriptor);
            paramInfos.add(paramInfo);
            ++i;
        }
        MBeanParameterInfo[] paramInfosArray = (MBeanParameterInfo[])CollectionUtil.toArray(paramInfos, MBeanParameterInfo.class);
        MBeanOperationInfo opInfo = new MBeanOperationInfo(name, description, paramInfosArray, type.getName(), 0, descriptor);
        return opInfo;
    }

    public MBeanOperationInfo[] toMBeanOperationInfos() {
        ArrayList<MBeanOperationInfo> opInfos = new ArrayList<MBeanOperationInfo>();
        for (DuckTypedInfo info : this.mDuckTypedInfos) {
            MBeanOperationInfo opInfo = this.duckTypedToMBeanOperationInfo(info);
            if (opInfo == null) continue;
            opInfos.add(opInfo);
        }
        return (MBeanOperationInfo[])CollectionUtil.toArray(opInfos, MBeanOperationInfo.class);
    }

    public MBeanAttributeInfo attributeToMBeanAttributeInfo(AttributeMethodInfo info) {
        DescriptorSupport descriptor = ConfigBeanJMXSupport.descriptor(info.attribute());
        String name = info.attrName();
        String xmlName = info.xmlName();
        descriptor.setField("amx.configbean.xmlName", xmlName);
        if (info.pattern() != null) {
            descriptor.setField("amx.configbean.pattern.regexp", info.pattern());
        }
        descriptor.setField("amx.configbean.notNull", "" + info.notNull());
        Class type = info.returnType();
        Attribute a = info.attribute();
        if (a == null || a.dataType() == String.class || type == String.class) {
            // empty if block
        }
        String description = "@Attribute " + name;
        boolean isReadable = true;
        boolean isWriteable = true;
        boolean isIs = false;
        MBeanAttributeInfo attrInfo = new MBeanAttributeInfo(name, type.getName(), description, true, true, false, descriptor);
        return attrInfo;
    }

    public Set<Class<? extends ConfigBeanProxy>> childInterfaces() {
        return this.childInterfaces(this.mElemenInfos);
    }

    public Map<String, Class<? extends ConfigBeanProxy>> childTypes() {
        HashMap<String, Class<? extends ConfigBeanProxy>> types = new HashMap<String, Class<? extends ConfigBeanProxy>>();
        for (Class<? extends ConfigBeanProxy> intf : this.childInterfaces()) {
            types.put(this.getTypeString(intf), intf);
        }
        return types;
    }

    public Class<? extends ConfigBeanProxy> getConfigBeanProxyClassFor(String type, boolean recursive) {
        return this.childTypes().get(type);
    }

    public Set<Class<? extends ConfigBeanProxy>> childInterfaces(List<ElementMethodInfo> infos) {
        HashSet<Class<? extends ConfigBeanProxy>> classes = new HashSet<Class<? extends ConfigBeanProxy>>();
        for (ElementMethodInfo info : infos) {
            Type argType;
            ParameterizedType pt;
            Type[] argTypes;
            Type genericReturnType;
            if (info.anonymous()) continue;
            Class methodReturnType = info.returnType();
            Class<ConfigBeanProxy> intf = null;
            if (info.intf() != null) {
                intf = info.intf();
            } else if (Collection.class.isAssignableFrom(methodReturnType) && (genericReturnType = info.method().getGenericReturnType()) instanceof ParameterizedType && (argTypes = (pt = (ParameterizedType)genericReturnType).getActualTypeArguments()).length == 1 && (!((argType = argTypes[0]) instanceof Class) || (Class)argType != String.class)) {
                intf = ((Class)argType).asSubclass(ConfigBeanProxy.class);
            }
            if (intf == null) continue;
            classes.add((Class<? extends ConfigBeanProxy>)intf);
        }
        return classes;
    }

    public MBeanAttributeInfo elementToMBeanAttributeInfo(Method m) {
        ParameterizedType pt;
        Type[] argTypes;
        Type genericReturnType;
        ElementMethodInfo info = ElementMethodInfo.get(m);
        if (info == null || info.anonymous()) {
            return null;
        }
        String name = info.attrName();
        String xmlName = info.xmlName();
        Class methodReturnType = info.returnType();
        Class returnType = null;
        if (info.intf() != null) {
            returnType = ObjectName.class;
        } else if (Collection.class.isAssignableFrom(methodReturnType) && (genericReturnType = m.getGenericReturnType()) instanceof ParameterizedType && (argTypes = (pt = (ParameterizedType)genericReturnType).getActualTypeArguments()).length == 1) {
            Type argType = argTypes[0];
            returnType = argType instanceof Class && (Class)argType == String.class ? String[].class : ObjectName[].class;
        }
        MBeanAttributeInfo attrInfo = null;
        if (returnType != null) {
            PropertiesDesc props;
            DescriptorSupport descriptor = ConfigBeanJMXSupport.descriptor(info.element());
            descriptor.setField("amx.configbean.elementClass", returnType.getName());
            descriptor.setField("amx.configbean.xmlName", xmlName);
            ToDo toDo = info.method().getAnnotation(ToDo.class);
            if (toDo != null) {
                descriptor.setField("amx.configbean.toDo", toDo.priority() + ", " + toDo.details());
            }
            if ((props = info.method().getAnnotation(PropertiesDesc.class)) != null) {
                String propType = props.systemProperties() ? "system-property" : "property";
                for (PropertyDesc p : props.props()) {
                    String value = p.defaultValue() + " | " + p.dataType().getName() + " | " + p.description();
                    descriptor.setField("amx.configbean." + propType + "." + p.name(), value);
                }
            }
            String description = "@Element " + name + " of interface " + this.mIntf.getName();
            boolean isReadable = true;
            boolean isWriteable = true;
            boolean isIs = false;
            attrInfo = new MBeanAttributeInfo(name, returnType.getName(), description, true, true, false, descriptor);
        }
        return attrInfo;
    }

    public String getNameHint() {
        return this.mNameHint.mHint;
    }

    public boolean nameHintIsElement() {
        return this.mNameHint.mIsElement;
    }

    public static String toXMLName(String name) {
        return name == null ? name : Dom.convertName((String)name);
    }

    private NameHint findNameHint() {
        if (this.isSingleton()) {
            return NameHint.NONE;
        }
        if (this.mKey != null) {
            return new NameHint(this.mKey);
        }
        String configuredBugKey = this.configuredBugKey();
        for (AttributeMethodInfo info : this.mAttrInfos) {
            if (info.key()) {
                return new NameHint(info.xmlName());
            }
            if (configuredBugKey == null || !info.attrName().equalsIgnoreCase(configuredBugKey)) continue;
            return new NameHint(configuredBugKey);
        }
        return NameHint.NAME;
    }

    public Map<String, String> getDefaultValues(boolean useAttributeNames) {
        HashMap<String, String> m = new HashMap<String, String>();
        MBeanInfo info = this.getMBeanInfo();
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            String defaultValue = ConfigBeanJMXSupport.defaultValue(attrInfo);
            if (defaultValue == null) continue;
            String attrName = attrInfo.getName();
            String name = useAttributeNames ? attrName : ConfigBeanJMXSupport.xmlName(attrInfo, attrName);
            m.put(name, defaultValue);
        }
        return m;
    }

    private static void debug(String s) {
        System.out.println("### " + s);
    }

    private static final class NameHint {
        public static final NameHint NAME = new NameHint("name");
        public static final NameHint NONE = new NameHint(null);
        private final String mHint;
        private final boolean mIsElement;

        public NameHint(String hint, boolean isElement) {
            this.mHint = ConfigBeanJMXSupport.toXMLName(hint);
            this.mIsElement = isElement;
        }

        public NameHint(String hint) {
            this(hint, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DuckTypedInfo {
        private final DuckTyped mDuckTyped;
        private final Method mMethod;

        DuckTypedInfo(Method m, DuckTyped duckTyped) {
            this.mMethod = m;
            this.mDuckTyped = duckTyped;
        }

        public DuckTyped duckTyped() {
            return this.mDuckTyped;
        }

        public String name() {
            return this.mMethod.getName();
        }

        public Class<?> duck() {
            return this.mMethod.getDeclaringClass();
        }

        public Method method() {
            return this.mMethod;
        }

        public Class<?> returnType() {
            return this.method().getReturnType();
        }

        public Class<?>[] signature() {
            return this.method().getParameterTypes();
        }

        public String toString() {
            String paramsString = "";
            Class<?>[] paramTypes = this.signature();
            if (paramTypes.length != 0) {
                StringBuilder builder = new StringBuilder();
                String delim = ", ";
                for (Class<?> paramClass : this.method().getParameterTypes()) {
                    builder.append(ClassUtil.stripPackageName((String)paramClass.getName()) + ", ");
                }
                builder.setLength(builder.length() - ", ".length());
                paramsString = builder.toString();
            }
            return ClassUtil.stripPackageName((String)this.mMethod.getReturnType().getName()) + " " + this.duck().getName() + "." + this.mMethod.getName() + "(" + paramsString + ")";
        }
    }

    public static final class AttributeMethodInfo
    extends MethodInfo {
        private final Attribute mAttribute;

        private AttributeMethodInfo(Method m, Attribute a) {
            super(m, a.value().length() == 0 ? ConfigBeanJMXSupport.typeFromName(JMXUtil.getAttributeName((Method)m)) : a.value());
            this.mAttribute = a;
        }

        public static AttributeMethodInfo get(Method m) {
            Attribute a = m.getAnnotation(Attribute.class);
            return a == null ? null : new AttributeMethodInfo(m, a);
        }

        public Attribute attribute() {
            return this.mAttribute;
        }

        public boolean required() {
            return this.mAttribute.required();
        }

        public boolean key() {
            return this.mAttribute.key();
        }

        public String pattern() {
            Pattern pat = this.mMethod.getAnnotation(Pattern.class);
            return pat == null ? null : pat.regexp();
        }

        public boolean notNull() {
            NotNull n = this.mMethod.getAnnotation(NotNull.class);
            return n != null;
        }
    }

    public static final class ElementMethodInfo
    extends MethodInfo {
        private final Element mElement;

        private ElementMethodInfo(Method m, Element e) {
            super(m, e.value().length() == 0 ? ConfigBeanJMXSupport.typeFromName(JMXUtil.getAttributeName((Method)m)) : e.value());
            this.mElement = e;
        }

        public static ElementMethodInfo get(Method m) {
            Element e = m.getAnnotation(Element.class);
            return e == null ? null : new ElementMethodInfo(m, e);
        }

        public Element element() {
            return this.mElement;
        }

        public boolean anonymous() {
            return ConfigBeanJMXSupport.ANONYMOUS_SUB_ELEMENT.equals(this.xmlName());
        }

        public boolean required() {
            return this.mElement.required();
        }

        public boolean key() {
            return this.mElement.key();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MethodInfo {
        protected final Method mMethod;
        protected final String mAttrName;
        protected final String mXMLName;

        MethodInfo(Method m, String xmlName) {
            this.mMethod = m;
            this.mAttrName = JMXUtil.getAttributeName((Method)m);
            this.mXMLName = xmlName;
        }

        public Method method() {
            return this.mMethod;
        }

        public String attrName() {
            return this.mAttrName;
        }

        public String xmlName() {
            return this.mXMLName;
        }

        public Class<?> returnType() {
            return this.mMethod.getReturnType();
        }

        public abstract boolean required();

        public abstract boolean key();

        public Class<? extends ConfigBeanProxy> intf() {
            Class<?> returnType = this.returnType();
            if (ConfigBeanProxy.class.isAssignableFrom(returnType)) {
                return returnType.asSubclass(ConfigBeanProxy.class);
            }
            return null;
        }
    }
}

