/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core;

import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.AMXException;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Extra;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public class AMXValidator {
    private final MBeanServerConnection mConn;
    private final ObjectName mTarget;
    private final MBeanInfo mMBeanInfo;
    private final AMXProxy mProxy;

    private AMXValidator(AMXProxy amx) {
        Extra extra = amx.extra();
        this.mProxy = amx;
        this.mConn = extra.mbeanServerConnection();
        this.mTarget = extra.objectName();
        this.mMBeanInfo = extra.mbeanInfo();
    }

    private void fail(String msg) {
        throw new AMXException("MBean " + this.mTarget + " failed validation: " + msg);
    }

    public static void validate(AMXProxy proxy) {
        new AMXValidator(proxy).validateAsAMX();
    }

    private void validateObjectName() {
        String nameProp;
        String type = this.mTarget.getKeyProperty("type");
        if (type == null || type.length() == 0) {
            this.fail("type property required in ObjectName");
        }
        if ((nameProp = this.mTarget.getKeyProperty("name")) != null) {
            if (this.mTarget.getKeyProperty("name").length() == 0) {
                this.fail("name property of ObjectName may not be empty");
            }
        } else {
            String name = this.mProxy.getName();
            if (!name.equals("")) {
                this.fail("getName() returned incorrect name for a singleton: " + name);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateRequiredAttributes() {
        Map<String, MBeanAttributeInfo> infos = JMXUtil.attributeInfosToMap(this.mMBeanInfo.getAttributes());
        Set<String> attrNames = infos.keySet();
        if (!attrNames.contains("Name")) {
            this.fail("MBeanInfo does not contain Name attribute");
        }
        if (!attrNames.contains("Parent")) {
            this.fail("MBeanInfo does not contain Parent attribute");
        }
        if (attrNames.contains("Children")) {
            try {
                if (this.mProxy.getChildren() != null) return;
                this.fail("value of Children attribute must not be null");
                return;
            }
            catch (AMXException e) {
                throw e;
            }
            catch (Exception e) {
                this.fail("does not supply children correctly");
                return;
            }
        }
        try {
            this.mProxy.getChildren();
            this.fail("Children attribute is present, but not listed in MBeanInfo");
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateAsAMX() {
        this.validateRequiredAttributes();
        this.validateObjectName();
    }
}

