/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathnameParser {
    private final char mDelim;
    private final char mNameLeft;
    private final char mNameRight;
    private final String mPath;
    private final List<PathPart> mParts;

    private static void debug(Object o) {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mPath + " as " + this.mParts.size() + " parts: ");
        buf.append("{");
        String delim = ", ";
        for (PathPart part : this.mParts) {
            buf.append(part.toString());
            buf.append(", ");
        }
        if (this.mParts.size() != 0) {
            buf.setLength(buf.length() - ", ".length());
        }
        buf.append("}");
        return buf.toString();
    }

    public PathnameParser(String path) {
        this(path, '/', '[', ']');
    }

    public PathnameParser(String path, char delim, char nameLeft, char nameRight) {
        this.mPath = path;
        this.mDelim = delim;
        this.mNameLeft = nameLeft;
        this.mNameRight = nameRight;
        this.mParts = this.parse();
    }

    public List<PathPart> parts() {
        return this.mParts;
    }

    public String type() {
        return this.mParts.get(this.mParts.size() - 1).type();
    }

    public String name() {
        return this.mParts.get(this.mParts.size() - 1).name();
    }

    public String parentPath() {
        if (this.mParts.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.mParts.size() - 1; ++i) {
            PathPart part = this.mParts.get(i);
            buf.append(part.toString());
            if (i >= this.mParts.size() - 2) continue;
            buf.append('/');
        }
        return buf.toString();
    }

    private static Pattern getTypePattern() {
        String typeAloneStr = "([a-zA-Z0-9_-]*)";
        String typePatternStr = "([a-zA-Z0-9_-]*).*";
        Pattern typePattern = Pattern.compile("([a-zA-Z0-9_-]*).*");
        return typePattern;
    }

    public static boolean isValidType(String type) {
        Matcher matcher = PathnameParser.getTypePattern().matcher(type);
        return matcher.matches();
    }

    private void parse(String path, List<PathPart> parts) {
        PathnameParser.debug("PathnameParser: parsing: " + path);
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(path);
        }
        Pattern typePattern = PathnameParser.getTypePattern();
        String namePatternStr = "([^]]*)](.*)";
        Pattern namePattern = Pattern.compile("([^]]*)](.*)");
        String remaining = path;
        while (remaining.length() != 0) {
            Matcher matcher = typePattern.matcher(remaining);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("No match: " + remaining);
            }
            String type = matcher.group(1);
            PathnameParser.debug("PathnameParser, matched type: \"" + type + "\"");
            char matchChar = '\u0000';
            if (type.length() >= remaining.length()) {
                PathPart part = new PathPart(type, null);
                parts.add(part);
                break;
            }
            matchChar = remaining.charAt(type.length());
            remaining = remaining.substring(type.length() + 1);
            PathnameParser.debug("PathnameParser, match char: \"" + matchChar + "\"");
            PathnameParser.debug("PathnameParser, remaining: \"" + remaining + "\"");
            String name = null;
            if (matchChar == this.mNameLeft) {
                int idx = remaining.indexOf(this.mNameRight);
                if (idx < 0) {
                    throw new IllegalArgumentException(path);
                }
                name = remaining.substring(0, idx);
                if ((remaining = remaining.substring(idx + 1)).length() != 0 && remaining.charAt(0) == this.mDelim) {
                    remaining = remaining.substring(1);
                }
            }
            PathPart part = new PathPart(type, name);
            parts.add(part);
            PathnameParser.debug("PathnameParser, matched part: \"" + part + "\"");
        }
        String s = "";
        for (PathPart part : parts) {
            s = s + "{" + part + "}";
        }
        PathnameParser.debug("FINAL PARSE for : " + path + " = " + s);
    }

    private List<PathPart> parse() {
        ArrayList<PathPart> parts = new ArrayList<PathPart>();
        this.parse(this.mPath, parts);
        return parts;
    }

    private static void checkName(String name) {
        if (name != null && (name.indexOf(91) >= 0 || name.indexOf(93) >= 0)) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
    }

    private static void checkType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Illegal type: " + type);
        }
        if (type.indexOf(91) >= 0 || type.indexOf(93) >= 0) {
            throw new IllegalArgumentException("Illegal type: " + type);
        }
        if (!PathnameParser.isValidType(type)) {
            throw new IllegalArgumentException("Illegal type: " + type);
        }
    }

    public static String pathPart(String type, String name) {
        PathnameParser.checkName(name);
        String namePart = name == null ? "" : '[' + name + ']';
        String part = PathnameParser.pathPart(type) + namePart;
        return part;
    }

    public static String pathPart(String type) {
        PathnameParser.checkType(type);
        return type;
    }

    public static String path(String parentPath, String type, String name) {
        if (parentPath != null && parentPath.length() == 0 && !type.equals(Util.deduceType(DomainRoot.class))) {
            throw new IllegalArgumentException("parent path cannot be the empty string");
        }
        String path = parentPath == null || parentPath.equals("/") ? "/" : parentPath + '/';
        path = path + PathnameParser.pathPart(type, name);
        new PathnameParser(path);
        return path;
    }

    public static String parentPath(ObjectName objectName) {
        return objectName.getKeyProperty("pp");
    }

    public static final class PathPart {
        private final String mType;
        private final String mName;

        public PathPart(String type, String name) {
            this.mType = type;
            this.mName = name;
        }

        public String type() {
            return this.mType;
        }

        public String name() {
            return this.mName;
        }

        public String toString() {
            return PathnameParser.pathPart(this.mType, this.mName);
        }
    }
}

