/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.api.amx.AMXMBeanMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final Set<String> PATTERN_PROPS = SetUtil.newUnmodifiableStringSet("type", "name");

    private static void debug(String s) {
        System.out.println(s);
    }

    private Util() {
    }

    public static ObjectName newObjectName(String name) {
        return JMXUtil.newObjectName(name);
    }

    public static ObjectName newObjectName(String domain, String props) {
        return Util.newObjectName(domain + ":" + props);
    }

    public static ObjectName newObjectNamePattern(String domain, String props) {
        return JMXUtil.newObjectNamePattern(domain, props);
    }

    public static ObjectName newObjectNamePattern(ObjectName objectName) {
        String props = objectName.getKeyPropertyListString();
        return Util.newObjectNamePattern(objectName.getDomain(), props);
    }

    public static String makeProp(String name, String value) {
        return JMXUtil.makeProp(name, value);
    }

    public static String makeTypeProp(String value) {
        return Util.makeProp("type", value);
    }

    public static String makeNameProp(String name) {
        return Util.makeProp("name", "" + name);
    }

    public static String makeRequiredProps(String type, String name) {
        String props = Util.makeTypeProp(type);
        if (name != null && name.length() != 0 && !name.equals("")) {
            String nameProp = Util.makeNameProp(name);
            props = Util.concatenateProps(props, nameProp);
        }
        return props;
    }

    public static String getSelfProp(ObjectName objectName) {
        String type = objectName.getKeyProperty("type");
        String name = objectName.getKeyProperty("name");
        return Util.makeProp(type, name);
    }

    public static String getAdditionalProps(ObjectName objectName) {
        Hashtable<String, String> allProps = objectName.getKeyPropertyList();
        allProps.remove("type");
        allProps.remove("name");
        String props = "";
        for (String key : allProps.keySet()) {
            String prop = Util.makeProp(key, allProps.get(key));
            props = Util.concatenateProps(props, prop);
        }
        return props;
    }

    public static String concatenateProps(String props1, String props2) {
        return JMXUtil.concatenateProps(props1, props2);
    }

    public static String concatenateProps(String props1, String props2, String props3) {
        return Util.concatenateProps(Util.concatenateProps(props1, props2), props3);
    }

    public static List<ObjectName> toObjectNames(Collection<? extends AMXProxy> amxs) {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        for (AMXProxy aMXProxy : amxs) {
            objectNames.add(Util.getObjectName(aMXProxy));
        }
        return Collections.checkedList(objectNames, ObjectName.class);
    }

    public static Map<String, ObjectName> toObjectNames(Map<String, ? extends AMXProxy> amxMap) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (String key : amxMap.keySet()) {
            AMXProxy value = amxMap.get(key);
            m.put(key, Util.getObjectName(value));
        }
        return Collections.checkedMap(m, String.class, ObjectName.class);
    }

    public static ObjectName[] toObjectNames(AMXProxy[] amx) {
        ObjectName[] objectNames = new ObjectName[amx.length];
        for (int i = 0; i < objectNames.length; ++i) {
            objectNames[i] = amx[i] == null ? null : Util.getObjectName(amx[i]);
        }
        return objectNames;
    }

    public static final Map<String, ObjectName> createObjectNameMap(Set<ObjectName> objectNames) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (ObjectName objectName : objectNames) {
            String name = Util.getNameProp(objectName);
            assert (!m.containsKey(name)) : "createObjectNameMap: key already present: " + name + " in " + objectName;
            m.put(name, objectName);
        }
        assert (m.keySet().size() == objectNames.size());
        return Collections.checkedMap(m, String.class, ObjectName.class);
    }

    public static <T extends AMXProxy> Map<String, T> createNameMap(Set<T> amxs) {
        HashMap<String, AMXProxy> m = new HashMap<String, AMXProxy>();
        for (AMXProxy amx : amxs) {
            String name = amx.getName();
            m.put(name, amx);
        }
        return m;
    }

    public static <T extends AMXProxy> ObjectName getObjectName(T amx) {
        return amx.extra().objectName();
    }

    public static Map<String, Serializable> getAMXNotificationData(Notification notif) {
        return Collections.unmodifiableMap(JMXUtil.getUserDataMapString_Serializable(notif));
    }

    public static Serializable getAMXNotificationValue(Notification notif, String key) {
        Map<String, Serializable> data = Util.getAMXNotificationData(notif);
        if (data == null) {
            throw new IllegalArgumentException(notif.toString());
        }
        if (!data.containsKey(key)) {
            throw new IllegalArgumentException("Value not found for " + key + " in " + notif);
        }
        return data.get(key);
    }

    public static <T extends Serializable> T getAMXNotificationValue(Notification notif, String key, Class<T> theClass) {
        Serializable value = Util.getAMXNotificationValue(notif, key);
        return (T)((Serializable)theClass.cast(value));
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static AMXProxy asAMX(Object o) {
        return (AMXProxy)AMXProxy.class.cast(o);
    }

    public static <T extends AMXProxy> Set<T> filterAMX(Set<T> candidates, Class<?> desired) {
        HashSet<AMXProxy> result = new HashSet<AMXProxy>();
        for (AMXProxy amx : candidates) {
            if (!desired.isAssignableFrom(amx.getClass())) continue;
            result.add(amx);
        }
        return result;
    }

    public static Map<String, ObjectName> filterByType(ObjectName[] objectNames, String type) {
        HashMap<String, ObjectName> m = null;
        if (objectNames != null) {
            m = new HashMap<String, ObjectName>();
            for (ObjectName o : objectNames) {
                if (!type.equals(o.getKeyProperty("type"))) continue;
                m.put(o.getKeyProperty("name"), o);
            }
        }
        return m;
    }

    public static <T extends AMXProxy> Map<String, T> filterAMX(Map<String, T> candidates, Class<?> desired) {
        HashMap<String, AMXProxy> result = new HashMap<String, AMXProxy>();
        for (String key : candidates.keySet()) {
            AMXProxy amx = (AMXProxy)candidates.get(key);
            if (!desired.isAssignableFrom(amx.getClass())) continue;
            result.put(key, amx);
        }
        return result;
    }

    public static String getTypeProp(AMXProxy amx) {
        return Util.getTypeProp(amx.extra().objectName());
    }

    public static String getTypeProp(ObjectName objectName) {
        return objectName.getKeyProperty("type");
    }

    public static String getNameProp(ObjectName objectName) {
        return objectName.getKeyProperty("name");
    }

    public static String getParentPathProp(ObjectName objectName) {
        return objectName.getKeyProperty("pp");
    }

    public static String getParentPathProp(AMXProxy amx) {
        return Util.getParentPathProp(amx.extra().objectName());
    }

    public static ObjectName getParent(MBeanServer server, ObjectName objectName) {
        return (ObjectName)JMXUtil.getAttribute(server, objectName, "Parent");
    }

    public static String deduceType(Class<?> intf) {
        Object value;
        String type = null;
        AMXMBeanMetadata meta = intf.getAnnotation(AMXMBeanMetadata.class);
        if (meta != null && meta.type().length() != 0 && !meta.type().equals("\u0000")) {
            type = meta.type();
        }
        if (type == null && (value = ClassUtil.getFieldValue(intf, "AMX_TYPE")) instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            type = ClassUtil.stripPackageName(intf.getName());
        }
        return type;
    }

    public static ObjectName getAncestorByType(MBeanServer mbeanServer, ObjectName child, String type) {
        ObjectName cur = child;
        while ((cur = (ObjectName)JMXUtil.getAttribute(mbeanServer, cur, "Parent")) != null && !Util.getTypeProp(cur).equals(type)) {
        }
        return cur;
    }
}

