/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.RuntimeMgr;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.intf.config.ConfigConfig;
import org.glassfish.admin.amx.intf.config.ConfigsConfig;
import org.glassfish.admin.amx.intf.config.DomainConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.Protocol;
import org.glassfish.admin.amx.intf.config.grizzly.Protocols;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeMgrImpl
extends AMXImplBase {
    private final ApplicationRegistry appRegistry = (ApplicationRegistry)Globals.getDefaultHabitat().getComponent(ApplicationRegistry.class);

    public RuntimeMgrImpl(ObjectName parent) {
        super(parent, RuntimeMgr.class);
    }

    public Map<String, String> getDeploymentConfigurations(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            throw new IllegalArgumentException(appName);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            for (Sniffer sniffer : appInfo.getSniffers()) {
                result.putAll(sniffer.getDeploymentConfigurations(appInfo.getSource()));
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void stopDomain() {
        this.executeREST("stop-domain");
    }

    private Protocol getProtocol() {
        ObjectName[] children;
        DomainConfig dc = (DomainConfig)this.getDomainRootProxy().child(DomainConfig.class);
        ConfigsConfig configs = dc.getConfigs();
        ConfigConfig config = (ConfigConfig)configs.getConfig().get("server-config");
        NetworkConfig network = (NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class);
        for (ObjectName o : children = network.getChildren()) {
            RuntimeMgrImpl.cdebug((String)("CHILD: " + o));
        }
        Protocols protocols = network.getProtocols();
        RuntimeMgrImpl.cdebug((String)("Got Protocols: " + protocols));
        Map protocolMap = protocols.getProtocol();
        Protocol protocol = (Protocol)protocolMap.get("admin-listener");
        RuntimeMgrImpl.cdebug((String)("Got Protocol: " + protocol));
        return protocol;
    }

    private int getRESTPort() {
        return this.getProtocol().resolveInteger("Port");
    }

    private String get_asadmin() {
        return this.getProtocol().resolveAttribute("DefaultVirtualServer");
    }

    public String getRESTBaseURL() {
        String scheme = this.getProtocol().resolveBoolean("SecurityEnabled") != false ? "https" : "http";
        String host = "localhost";
        return scheme + "://" + "localhost" + ":" + this.getRESTPort() + "/" + this.get_asadmin() + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeREST(String cmd) {
        String result = null;
        HttpURLConnection conn = null;
        try {
            String url = this.getRESTBaseURL() + cmd;
            URL invoke = new URL(url);
            conn = (HttpURLConnection)invoke.openConnection();
            InputStream is = conn.getInputStream();
            result = RuntimeMgrImpl.toString((Object)is);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = ExceptionUtil.toString((Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }
}

