/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.config.DefaultValues;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.impl.config.AMXConfigLoader;
import org.glassfish.admin.amx.impl.config.AttributeResolverHelper;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupport;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupportRegistry;
import org.glassfish.admin.amx.impl.config.CreateConfigArgSupport;
import org.glassfish.admin.amx.impl.config.RefHelper;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.MBeanInfoSupport;
import org.glassfish.admin.amx.impl.util.SingletonEnforcer;
import org.glassfish.admin.amx.impl.util.UnregistrationListener;
import org.glassfish.admin.amx.intf.config.PropertiesAccess;
import org.glassfish.admin.amx.intf.config.PropertyConfig;
import org.glassfish.admin.amx.intf.config.RefConfig;
import org.glassfish.admin.amx.intf.config.RefConfigReferent;
import org.glassfish.admin.amx.intf.config.SystemPropertiesAccess;
import org.glassfish.admin.amx.intf.config.SystemPropertyConfig;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXConfigImpl
extends AMXImplBase
implements DefaultValues {
    private final ConfigBean mConfigBean;
    private static MBeanInfo configMBeanInfo;
    private static final ConcurrentMap<Class<? extends ConfigBeanProxy>, MBeanInfo> mInfos;
    private static final String CREATE = "create";
    private static final String CREATE_CHILD = "createChild";
    private static final String REMOVE_CHILD = "removeChild";
    private static final Class[] STRING_SIG;
    private static final Set<String> CR_PREFIXES;

    private static synchronized MBeanInfo getAMXConfigMBeanInfo() {
        if (configMBeanInfo == null) {
            configMBeanInfo = MBeanInfoSupport.getMBeanInfo(AMXConfigProxy.class);
        }
        return configMBeanInfo;
    }

    private static MBeanInfo createMBeanInfo(ConfigBean cb) {
        Class intf = cb.getProxyType();
        MBeanInfo newInfo = (MBeanInfo)mInfos.get(intf);
        if (newInfo != null) {
            return newInfo;
        }
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        MBeanInfo info = spt.getMBeanInfo();
        List attrInfos = ListUtil.newListFromArray((Object[])info.getAttributes());
        MBeanInfo spiInfo = MBeanInfoSupport.getAMX_SPIMBeanInfo();
        List spiAttrInfos = ListUtil.newListFromArray((Object[])spiInfo.getAttributes());
        if (spt.isLeaf()) {
            JMXUtil.remove((List)spiAttrInfos, (String)"Children");
        }
        for (MBeanAttributeInfo attrInfo : spiAttrInfos) {
            MBeanAttributeInfo before = (MBeanAttributeInfo)JMXUtil.remove((List)attrInfos, (String)attrInfo.getName());
            attrInfos.add(attrInfo);
        }
        List operationInfos = ListUtil.newListFromArray((Object[])info.getOperations());
        operationInfos.addAll(ListUtil.newListFromArray((Object[])AMXConfigImpl.getAMXConfigMBeanInfo().getOperations()));
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attrInfos.size()];
        attrInfos.toArray(attrs);
        MBeanOperationInfo[] operations = new MBeanOperationInfo[operationInfos.size()];
        operationInfos.toArray(operations);
        newInfo = new MBeanInfo(info.getClassName(), info.getDescription(), attrs, info.getConstructors(), operations, info.getNotifications(), info.getDescriptor());
        mInfos.putIfAbsent(intf, newInfo);
        return newInfo;
    }

    public AMXConfigImpl(ObjectName parentObjectName, ConfigBean configBean) {
        this(parentObjectName, AMXConfigProxy.class, configBean);
    }

    public AMXConfigImpl(ObjectName parentObjectName, Class<? extends AMXProxy> theInterface, ConfigBean configBean) {
        super(parentObjectName, AMXConfigImpl.createMBeanInfo(configBean));
        this.mConfigBean = configBean;
        this.getConfigBeanJMXSupport();
    }

    public void delegateFailed(Throwable t) {
    }

    protected void setAttributeManually(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        AttributeList attrList = new AttributeList();
        attrList.add(attr);
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        AttributeList successList = this.setAttributesInConfigBean(attrList, oldValues);
        if (successList.size() == 0) {
            throw new AttributeNotFoundException(attr.getName());
        }
    }

    public AttributeList setAttributes(AttributeList attrs) {
        AttributeList successList = new AttributeList();
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        AttributeList delegateSuccess = this.setAttributesInConfigBean(attrs, oldValues);
        successList.addAll(delegateSuccess);
        return successList;
    }

    public String getName() {
        ConfigBean cb = this.getConfigBean();
        String name = AMXConfigLoader.getName(cb);
        return name == null ? "" : name;
    }

    private final ConfigBean getConfigBean() {
        return this.mConfigBean;
    }

    private final ConfigBeanProxy getConfigBeanProxy() {
        return this.getConfigBean().getProxy(this.getConfigBean().getProxyType());
    }

    protected Map<String, PropertyConfig> getProperty() {
        return ((PropertiesAccess)this.getSelf(PropertiesAccess.class)).getProperty();
    }

    protected Map<String, SystemPropertyConfig> getSystemProperty() {
        return ((SystemPropertiesAccess)this.getSelf(SystemPropertiesAccess.class)).getSystemProperty();
    }

    public String resolveAttributeValue(String varString) {
        if (!AttributeResolverHelper.needsResolving(varString)) {
            return varString;
        }
        return new AttributeResolverHelper((AMXConfigProxy)this.getSelf(AMXConfigProxy.class)).resolve(varString);
    }

    public String resolveAttribute(String attrName) {
        try {
            Object value = this.getAttribute(attrName);
            return this.resolveAttributeValue(value == null ? null : "" + value);
        }
        catch (AttributeNotFoundException e) {
            System.out.println("resolveAttribute: Attribute not found: " + attrName);
            return null;
        }
    }

    public Boolean resolveBoolean(String attrName) {
        return Boolean.parseBoolean(this.resolveAttribute(attrName));
    }

    public Integer resolveInteger(String attrName) {
        return Integer.parseInt(this.resolveAttribute(attrName));
    }

    public Long resolveLong(String attrName) {
        return Long.parseLong(this.resolveAttribute(attrName));
    }

    public AttributeList resolveAttributes(String[] attrNames) {
        Issues.getAMXIssues().notDone("resolveAttributes: use annotations to create the correct type");
        AttributeList attrs = this.getAttributes(attrNames);
        AttributeList resolvedAttrs = new AttributeList();
        for (Object o : attrs) {
            Attribute r = (Attribute)o;
            Object value = r.getValue();
            if (value instanceof String && AttributeResolverHelper.needsResolving((String)value)) {
                String resolvedValue = this.resolveAttributeValue((String)value);
                r = new Attribute(r.getName(), resolvedValue);
            }
            resolvedAttrs.add(r);
        }
        return resolvedAttrs;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] superInfos = super.getNotificationInfo();
        String description = "";
        String[] notifTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo attributeChange = new MBeanNotificationInfo(notifTypes, AttributeChangeNotification.class.getName(), "");
        MBeanNotificationInfo[] selfInfos = new MBeanNotificationInfo[]{attributeChange};
        MBeanNotificationInfo[] allInfos = JMXUtil.mergeMBeanNotificationInfos((MBeanNotificationInfo[])superInfos, (MBeanNotificationInfo[])selfInfos);
        return allInfos;
    }

    protected void preRemove(ObjectName objectName) {
        AMXConfigProxy amxConfig = (AMXConfigProxy)this.getProxy(objectName, AMXConfigProxy.class);
        if (amxConfig instanceof RefConfigReferent) {
            this.debug(new Object[]{"*** Removing all references to ", objectName});
            Set<RefConfig> failures = RefHelper.removeAllRefsTo((RefConfigReferent)amxConfig, true);
            if (failures.size() != 0) {
                this.debug("FAILURE removing references to " + objectName);
            }
        } else {
            this.debug(new Object[]{"*** not a RefConfigReferent: ", objectName});
        }
    }

    protected ObjectName preRemove(Map<String, ObjectName> items, String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        ObjectName objectName = items.get(name);
        if (objectName == null) {
            throw new IllegalArgumentException("Item not found: " + name);
        }
        this.preRemove(objectName);
        return objectName;
    }

    private boolean isRemoveConfig(String operationName) {
        return operationName.equals(REMOVE_CHILD);
    }

    private boolean isRemoveConfig(String operationName, Object[] args, String[] types) {
        boolean isRemove;
        int numArgs = args == null ? 0 : args.length;
        boolean bl = isRemove = numArgs <= 1 && this.isRemoveConfig(operationName);
        if (isRemove && numArgs == 1) {
            isRemove = types[0].equals(String.class.getName());
        }
        return isRemove;
    }

    private boolean isCreateConfig(String operationName) {
        return operationName.equals(CREATE_CHILD);
    }

    private boolean isGenericCreateConfig(String operationName) {
        try {
            Class[] types = new Class[]{String.class, Map.class};
            return AMXConfigProxy.class.getMethod(operationName, types) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static List<ConfigSupport.AttributeChanges> toAttributeChanges(Map<String, Object> values) {
        ArrayList<ConfigSupport.AttributeChanges> changes = new ArrayList<ConfigSupport.AttributeChanges>();
        if (values != null) {
            for (String name : values.keySet()) {
                Object value = values.get(name);
                if (value == null || value instanceof String) {
                    changes.add((ConfigSupport.AttributeChanges)new ConfigSupport.SingleAttributeChange(name, (String)value));
                    continue;
                }
                changes.add((ConfigSupport.AttributeChanges)new ConfigSupport.MultipleAttributeChanges(name, (String[])value));
            }
        }
        return changes;
    }

    private ObjectName finishCreate(Class<? extends ConfigBeanProxy> elementClass, CreateConfigArgSupport argSpt, List<ConfigSupport.AttributeChanges> changes) throws ClassNotFoundException, TransactionFailure {
        ConfigBean newConfigBean = null;
        PropertiesCallback callback = new PropertiesCallback(argSpt.getProperties(), argSpt.getSystemProperties());
        try {
            newConfigBean = ConfigSupport.createAndSet((ConfigBean)this.getConfigBean(), elementClass, changes, (ConfigSupport.TransactionCallBack)callback);
        }
        catch (Throwable t) {
            AMXConfigImpl.cdebug((String)ExceptionUtil.toString((Throwable)t));
            throw new RuntimeException(t);
        }
        AMXConfigLoader amxLoader = (AMXConfigLoader)SingletonEnforcer.get(AMXConfigLoader.class);
        amxLoader.handleConfigBean(newConfigBean, true);
        ObjectName objectName = newConfigBean.getObjectName();
        AMXConfigProxy newAMX = (AMXConfigProxy)AMXConfigProxy.class.cast(this.getProxyFactory().getProxy(objectName, AMXConfigProxy.class));
        this.setAllProperties(newAMX, argSpt.getProperties(), argSpt.getSystemProperties());
        return objectName;
    }

    protected ObjectName createConfigGeneric(String operationName, Object[] args, String[] types) throws ClassNotFoundException, TransactionFailure {
        if (types.length != 2) {
            throw new IllegalArgumentException("unexpected signature for create");
        }
        String type = (String)args[0];
        Map params = TypeCast.checkMap((Map)TypeCast.asMap((Object)args[1]), String.class, Object.class);
        Class<? extends ConfigBeanProxy> intf = this.getConfigBeanProxyClassForContainedType(type);
        if (intf == null) {
            throw new IllegalArgumentException("ConfigBean of type " + this.getConfigBean().getProxyType() + " does not support sub-element of type " + type);
        }
        return this.createChild(intf, params);
    }

    private ObjectName createChild(Class<? extends ConfigBeanProxy> intf, Map<String, Object> params) throws ClassNotFoundException, TransactionFailure {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(intf);
        if (!spt.isSingleton()) {
            if (params == null) {
                throw new IllegalArgumentException("Named element requires at least its name");
            }
            Set<String> requiredAttrs = spt.requiredAttributeNames();
            for (String s : requiredAttrs) {
                if (params.containsKey(s)) continue;
                throw new IllegalArgumentException("Required attribute missing: " + s);
            }
        }
        CreateConfigArgSupport argSpt = new CreateConfigArgSupport(params);
        List<ConfigSupport.AttributeChanges> changes = AMXConfigImpl.toAttributeChanges(params);
        return this.finishCreate(intf, argSpt, changes);
    }

    private ObjectName createPropertyChild(String type, String name, String value) throws ClassNotFoundException, TransactionFailure {
        Class intf = ConfigSupport.getElementTypeByName((ConfigBeanProxy)this.getConfigBeanProxy(), (String)type);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("Name", name);
        attrs.put("Value", value);
        return this.createChild(intf, attrs);
    }

    private void setAllProperties(AMXConfigProxy amxConfig, Map<String, String> properties, Map<String, String> systemProperties) throws ClassNotFoundException, TransactionFailure {
        if (properties.keySet().size() != 0) {
            for (String propName : properties.keySet()) {
                String propValue = properties.get(propName);
                AMXConfigImpl.cdebug((String)("################## Creating property " + propName + " = " + propValue));
                this.createPropertyChild("property", propName, propValue);
            }
        }
        if (systemProperties.keySet().size() != 0) {
            SystemPropertiesAccess pa = (SystemPropertiesAccess)SystemPropertiesAccess.class.cast(amxConfig);
            for (String propName : systemProperties.keySet()) {
                String propValue = systemProperties.get(propName);
                this.debug("################## Creating System property " + propName + " = " + propValue);
                this.createPropertyChild("system-property", propName, propValue);
            }
        }
    }

    protected String operationNameToSimpleClassname(String operationName) {
        return StringUtil.findAndStripPrefix(CR_PREFIXES, (String)operationName);
    }

    protected void removeSelf() {
        ObjectName objectName = this.getObjectName();
        ConfigBean configBean = this.getConfigBean();
        try {
            AMXConfigImpl.cdebug((String)("REMOVING config of class " + configBean.getProxyType().getName() + " from  parent of type " + this.getConfigBean().getProxyType().getName() + ", ObjectName = " + JMXUtil.toString((ObjectName)objectName)));
            ConfigSupport.deleteChild((ConfigBean)configBean, (ConfigBean)this.getConfigBean());
        }
        catch (TransactionFailure tf) {
            throw new RuntimeException("Transaction failure deleting " + JMXUtil.toString((ObjectName)objectName), tf);
        }
        UnregistrationListener myListener = new UnregistrationListener((MBeanServerConnection)this.getMBeanServer(), objectName);
        long TIMEOUT_MILLIS = 10000L;
        boolean unregisteredOK = myListener.waitForUnregister(10000L);
        if (!unregisteredOK) {
            throw new RuntimeException("Something went wrong unregistering MBean " + JMXUtil.toString((ObjectName)objectName));
        }
    }

    public final void removeConfig(ObjectName childObjectName) {
        this.preRemove(childObjectName);
        try {
            this.getMBeanServer().invoke(childObjectName, "removeSelf", null, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem deleting " + childObjectName, e);
        }
    }

    public final void removeConfig(String type, String name) {
        ObjectName childObjectName = this.child(type, name);
        if (childObjectName == null) {
            throw new RuntimeException(new InstanceNotFoundException("No MBean named " + name + " of type " + type + " found."));
        }
        this.removeConfig(childObjectName);
    }

    protected String operationNameToType(String operationName) {
        String type = null;
        if (this.isRemoveConfig(operationName) || this.isCreateConfig(operationName)) {
            type = this.operationNameToSimpleClassname(operationName);
        }
        return type;
    }

    protected void removeConfig(String operationName) {
        String type = this.operationNameToType(operationName);
        ObjectName childObjectName = this.child(type);
        if (childObjectName == null) {
            throw new RuntimeException(new InstanceNotFoundException(type));
        }
        this.removeConfig(childObjectName);
    }

    protected void removeConfig(String operationName, Object[] args, String[] types) throws InvocationTargetException {
        if (args.length == 1) {
            AMXConfigImpl.cdebug((String)"removeConfig: by operationName + name");
            this.removeConfig(this.operationNameToType(operationName), (String)args[0]);
        } else if (args.length == 2) {
            AMXConfigImpl.cdebug((String)"removeConfig: by  type + name");
            if (!operationName.equals("removeConfig")) {
                throw new IllegalArgumentException();
            }
            this.removeConfig((String)args[0], (String)args[1]);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private Object invokeDuckMethod(ConfigBeanJMXSupport.DuckTypedInfo info, Object[] args) throws MBeanException {
        try {
            AMXConfigImpl.cdebug((String)("invokeDuckMethod(): invoking: " + info.name() + " on " + info.method().getDeclaringClass()));
            if (!info.method().getDeclaringClass().isAssignableFrom(this.getConfigBeanProxy().getClass())) {
                throw new IllegalArgumentException("invokeDuckMethod: " + this.getConfigBean().getProxyType() + " not asssignable to " + info.method().getDeclaringClass());
            }
            Object result = info.method().invoke((Object)this.getConfigBeanProxy(), args);
            AMXConfigImpl.cdebug((String)("invokeDuckMethod(): invoked: " + info.name() + ", got " + result));
            return result;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException, AttributeNotFoundException {
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        this.debugMethod(operationName, args);
        ConfigBeanJMXSupport.DuckTypedInfo duckTypedInfo = null;
        ConfigBeanJMXSupport spt = this.getConfigBeanJMXSupport();
        if (this.isGenericCreateConfig(operationName)) {
            try {
                result = this.createConfigGeneric(operationName, args, types);
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        } else if (this.isRemoveConfig(operationName, args, types)) {
            try {
                this.removeConfig(operationName, args, types);
            }
            catch (InvocationTargetException e) {
                throw new MBeanException(e);
            }
        } else {
            duckTypedInfo = this.getConfigBeanJMXSupport().findDuckTyped(operationName, types);
            result = duckTypedInfo != null ? this.invokeDuckMethod(duckTypedInfo, args) : super.invokeManually(operationName, args, types);
        }
        return result;
    }

    public void sendConfigCreatedNotification(ObjectName configObjectName) {
        this.sendNotification("org.glassfish.admin.amx.intf.ConfigCreated", "org.glassfish.admin.amx.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    public void sendConfigRemovedNotification(ObjectName configObjectName) {
        this.sendNotification("org.glassfish.admin.amx.config.ConfigRemoved", "org.glassfish.admin.amx.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    private final ConfigBeanJMXSupport getConfigBeanJMXSupport() {
        return ConfigBeanJMXSupportRegistry.getInstance(this.getConfigBean());
    }

    private static final Map<String, String> getDefaultValues(Class<? extends ConfigBeanProxy> intf, boolean useAMXAttributeNames) {
        return ConfigBeanJMXSupportRegistry.getInstance(intf).getDefaultValues(useAMXAttributeNames);
    }

    public final Map<String, String> getDefaultValues(String type, boolean useAMXAttributeNames) {
        Class<? extends ConfigBeanProxy> intf = this.getConfigBeanProxyClassForContainedType(type);
        return AMXConfigImpl.getDefaultValues(intf, useAMXAttributeNames);
    }

    public final Map<String, String> getDefaultValues(boolean useAMXAttributeNames) {
        return AMXConfigImpl.getDefaultValues(this.mConfigBean.getProxyType(), useAMXAttributeNames);
    }

    private Class<? extends ConfigBeanProxy> getConfigBeanProxyClassForContainedType(String type) {
        ConfigBeanJMXSupport spt = this.getConfigBeanJMXSupport();
        if (spt == null) {
            throw new IllegalArgumentException("Can't find ConfigBean @Configured class for AMX type " + type);
        }
        return spt.getConfigBeanProxyClassFor(type);
    }

    protected String[] attributeNameToType(String attributeName) {
        return new String[]{ConfigBeanJMXSupport.typeFromName(attributeName), attributeName};
    }

    protected Object getAttributeManually(String name) throws AttributeNotFoundException, ReflectionException, MBeanException {
        return this.getAttributeFromConfigBean(name);
    }

    protected final Object getAttributeFromConfigBean(String amxName) {
        Object[] result = null;
        MBeanAttributeInfo attrInfo = this.getAttributeInfo(amxName);
        String xmlName = ConfigBeanJMXSupport.xmlName(attrInfo, amxName);
        boolean isAttribute = ConfigBeanJMXSupport.isAttribute(attrInfo);
        if (isAttribute) {
            result = this.mConfigBean.rawAttribute(xmlName);
        } else if (ConfigBeanJMXSupport.isElement(attrInfo)) {
            if (String.class.getName().equals(attrInfo.getType())) {
                List leaf = this.mConfigBean.leafElements(xmlName);
                if (leaf != null) {
                    try {
                        result = (String)leaf.get(0);
                    }
                    catch (Exception e) {}
                }
            } else if (attrInfo.getType() == String[].class.getName()) {
                List leaf = this.mConfigBean.leafElements(xmlName);
                if (leaf != null) {
                    List elems = TypeCast.checkList((List)leaf, String.class);
                    result = CollectionUtil.toArray((Collection)elems, String.class);
                }
            } else {
                throw new IllegalArgumentException("getAttributeFromConfigBean: unsupported return type: " + attrInfo.getType());
            }
        }
        return result;
    }

    private Map<String, PropertyChangeEvent> makePropertyChangeEventMap(List<PropertyChangeEvent> changeEvents) {
        HashMap<String, PropertyChangeEvent> m = new HashMap<String, PropertyChangeEvent>();
        for (PropertyChangeEvent changeEvent : changeEvents) {
            if (changeEvent.getPropertyName() == null) {
                throw new IllegalArgumentException("PropertyChangeEvent property names must be specified");
            }
            m.put(changeEvent.getPropertyName(), changeEvent);
        }
        return m;
    }

    private void joinTransaction(Transaction t, WriteableView writeable) throws TransactionFailure {
        if (!writeable.join(t)) {
            t.rollback();
            throw new TransactionFailure("Cannot enlist " + writeable.getProxyType() + " in transaction", null);
        }
    }

    private static void commit(Transaction t) throws TransactionFailure {
        try {
            t.commit();
        }
        catch (RetryableException e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), (Throwable)e);
        }
        catch (TransactionFailure e) {
            AMXConfigImpl.cdebug((String)"failure, not retryable...");
            t.rollback();
            throw e;
        }
    }

    static <T extends ConfigBeanProxy> WriteableView getWriteableView(T s, ConfigBean sourceBean) throws TransactionFailure {
        WriteableView f = new WriteableView(s);
        if (sourceBean.getLock().tryLock()) {
            return f;
        }
        throw new TransactionFailure("Config bean already locked " + sourceBean, null);
    }

    private static Type getCollectionGenericType() {
        try {
            return ConfigSupport.class.getDeclaredMethod("defaultPropertyValue", null).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException();
        }
    }

    private static boolean isCollectionCmd(String s) {
        return s != null && (s.equals("add") || s.equals("remove") || s.equals("replace"));
    }

    private List<String> handleCollection(WriteableView writeable, ConfigModel.Property prop, String cmd, List<String> argValues) {
        if (!AMXConfigImpl.isCollectionCmd(cmd)) {
            throw new IllegalArgumentException("" + cmd);
        }
        Object o = writeable.getter(prop, AMXConfigImpl.getCollectionGenericType());
        List masterList = TypeCast.checkList((List)TypeCast.asList((Object)o), String.class);
        if (cmd.equals("replace")) {
            masterList.retainAll(argValues);
            for (String s : argValues) {
                if (masterList.contains(s)) continue;
                masterList.add(s);
            }
        } else if (cmd.equals("remove")) {
            masterList.removeAll(argValues);
        } else if (cmd.equals("add")) {
            ArrayList<String> temp = new ArrayList<String>(argValues);
            temp.removeAll(masterList);
            masterList.addAll(temp);
        } else {
            throw new IllegalArgumentException(cmd);
        }
        return new ArrayList<String>(masterList);
    }

    protected ConfigModel.Property getConfigModel_Property(String xmlName) {
        ConfigModel.Property cmp = this.mConfigBean.model.findIgnoreCase(xmlName);
        if (cmp == null) {
            throw new IllegalArgumentException("Illegal name: " + xmlName);
        }
        return cmp;
    }

    private void apply(ConfigBean cb, Map<String, Object> changes) throws TransactionFailure {
        MakeChangesApplyer mca = new MakeChangesApplyer(this.mConfigBean, changes);
        mca.apply();
    }

    private Map<String, Object> mapNamesAndValues(Map<String, Object> amxAttrs, Map<String, Object> noMatch) {
        HashMap<String, Object> xmlAttrs = new HashMap<String, Object>();
        Map attrInfos = this.getAttributeInfos();
        for (String amxAttrName : amxAttrs.keySet()) {
            Object valueIn = amxAttrs.get(amxAttrName);
            MBeanAttributeInfo attrInfo = (MBeanAttributeInfo)attrInfos.get(amxAttrName);
            if (attrInfo == null) {
                this.debug("WARNING: setAttributes(): no MBeanAttributeInfo found for: " + amxAttrName);
                noMatch.put(amxAttrName, valueIn);
                continue;
            }
            String xmlName = ConfigBeanJMXSupport.xmlName(attrInfo, amxAttrName);
            if (xmlName != null) {
                String value;
                String string = value = valueIn == null ? null : "" + valueIn;
                if (value != valueIn) {
                    // empty if block
                }
                if (valueIn == null || value instanceof String) {
                    xmlAttrs.put(xmlName, value);
                    continue;
                }
                noMatch.put(amxAttrName, valueIn);
                continue;
            }
            this.debug("WARNING: setAttributes(): no xmlName match found for AMX attribute: " + amxAttrName);
            noMatch.put(amxAttrName, valueIn);
        }
        return xmlAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributesInConfigBean(AttributeList attrsIn, Map<String, Object> oldValues) {
        oldValues.clear();
        Map amxAttrs = JMXUtil.attributeListToValueMap((AttributeList)attrsIn);
        HashMap<String, Object> notMatched = new HashMap<String, Object>();
        Map<String, Object> xmlAttrs = this.mapNamesAndValues(amxAttrs, notMatched);
        if (notMatched.keySet().size() != 0) {
            AMXConfigImpl.cdebug((String)("setAttributes: failed to map these AMX attributes: {" + CollectionUtil.toString(notMatched.keySet(), (String)", ") + "}"));
        }
        AttributeList successfulAttrs = new AttributeList();
        Transactions transactions = (Transactions)this.mConfigBean.getHabitat().getComponent(Transactions.class);
        if (xmlAttrs.size() != 0) {
            MyTransactionListener myListener = new MyTransactionListener(this.mConfigBean);
            transactions.addTransactionsListener((TransactionListener)myListener);
            try {
                MakeChangesApplyer mca = new MakeChangesApplyer(this.mConfigBean, xmlAttrs);
                mca.apply();
                successfulAttrs.addAll(attrsIn);
            }
            catch (TransactionFailure tf) {
                AMXConfigImpl.cdebug((String)ExceptionUtil.toString((Throwable)tf));
            }
            finally {
                transactions.waitForDrain();
                transactions.removeTransactionsListener((TransactionListener)myListener);
            }
        }
        return successfulAttrs;
    }

    static {
        mInfos = new ConcurrentHashMap<Class<? extends ConfigBeanProxy>, MBeanInfo>();
        STRING_SIG = new Class[]{String.class};
        CR_PREFIXES = SetUtil.newUnmodifiableStringSet((String[])new String[]{CREATE, "remove"});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MakeChangesApplyer
    extends Applyer {
        private final Map<String, Object> mChanges;

        public MakeChangesApplyer(ConfigBean cb, Map<String, Object> changes) throws TransactionFailure {
            super(cb);
            this.mChanges = changes;
        }

        @Override
        protected void makeChanges() throws TransactionFailure {
            for (String xmlName : this.mChanges.keySet()) {
                Object value = this.mChanges.get(xmlName);
                ConfigModel.Property prop = AMXConfigImpl.this.getConfigModel_Property(xmlName);
                if (prop.isCollection()) {
                    List results = AMXConfigImpl.this.handleCollection(this.mWriteable, prop, "replace", ListUtil.asStringList((Object)value));
                    continue;
                }
                if (value == null || value instanceof String) {
                    this.mWriteable.setter(prop, value, String.class);
                    continue;
                }
                throw new TransactionFailure("Illegal data type for attribute " + xmlName + ": " + value.getClass().getName());
            }
        }
    }

    private final class ModifyCollectionApplyer
    extends Applyer {
        private volatile List<String> mResult;
        private final String mElementName;
        private final String mCmd;
        private final String[] mValues;

        public ModifyCollectionApplyer(ConfigBean cb, String elementName, String cmd, String[] values) throws TransactionFailure {
            super(cb);
            this.mElementName = elementName;
            this.mCmd = cmd;
            this.mValues = values;
            this.mResult = null;
        }

        protected void makeChanges() throws TransactionFailure {
            ConfigModel.Property prop = AMXConfigImpl.this.getConfigModel_Property(this.mElementName);
            this.mResult = AMXConfigImpl.this.handleCollection(this.mWriteable, prop, this.mCmd, ListUtil.asStringList((Object)this.mValues));
        }
    }

    private class Applyer {
        final Transaction mTransaction;
        final ConfigBean mConfigBean;
        final WriteableView mWriteable;

        public Applyer(ConfigBean cb) throws TransactionFailure {
            this(cb, new Transaction());
        }

        public Applyer(ConfigBean cb, Transaction t) throws TransactionFailure {
            this.mConfigBean = cb;
            this.mTransaction = t;
            ConfigBeanProxy readableView = cb.getProxy(cb.getProxyType());
            this.mWriteable = AMXConfigImpl.getWriteableView(readableView, cb);
        }

        protected void makeChanges() throws TransactionFailure {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void apply() throws TransactionFailure {
            try {
                AMXConfigImpl.this.joinTransaction(this.mTransaction, this.mWriteable);
                this.makeChanges();
                AMXConfigImpl.commit(this.mTransaction);
            }
            finally {
                this.mConfigBean.getLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyTransactionListener
    implements TransactionListener {
        private final List<PropertyChangeEvent> mChangeEvents = new ArrayList<PropertyChangeEvent>();
        private final ConfigBean mTarget;

        MyTransactionListener(ConfigBean target) {
            this.mTarget = target;
        }

        public void transactionCommited(List<PropertyChangeEvent> changes) {
            for (PropertyChangeEvent event : changes) {
                Dom dom;
                Object source = event.getSource();
                if (!(source instanceof ConfigBeanProxy) || !((dom = Dom.unwrap((ConfigBeanProxy)((ConfigBeanProxy)source))) instanceof ConfigBean) || this.mTarget != (ConfigBean)dom) continue;
                this.mChangeEvents.add(event);
            }
        }

        public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
        }

        List<PropertyChangeEvent> getChangeEvents() {
            return this.mChangeEvents;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertiesCallback
    implements ConfigSupport.TransactionCallBack<WriteableView> {
        private final Map<String, String> mProperties;
        private final Map<String, String> mSystemProperties;

        public PropertiesCallback(Map<String, String> properties, Map<String, String> systemProperties) {
            this.mProperties = properties;
            this.mSystemProperties = systemProperties;
        }

        public void performOn(WriteableView item) throws TransactionFailure {
        }
    }
}

