/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.config.AMXConfigImpl;
import org.glassfish.admin.amx.impl.config.AMXConfigLoaderMBean;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupport;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupportRegistry;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.mbean.MBeanImplBase;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.ObjectNames;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.mbeanserver.PendingConfigBeanJob;
import org.glassfish.admin.mbeanserver.PendingConfigBeansNew;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AMXConfigLoader
extends MBeanImplBase
implements AMXConfigLoaderMBean,
TransactionListener {
    private final MBeanServer mMBeanServer;
    private volatile AMXConfigLoaderThread mLoaderThread;
    private final Transactions mTransactions;
    private final Logger mLogger = ImplUtil.getLogger();
    private final PendingConfigBeansNew mPendingConfigBeans;
    private final ConfigBeanRegistry mRegistry = new ConfigBeanRegistry();

    private static void debug(String s) {
        System.out.println(s);
    }

    public AMXConfigLoader(MBeanServer mbeanServer, PendingConfigBeansNew pending, Transactions transactions) {
        if (transactions == null) {
            throw new IllegalStateException();
        }
        this.mTransactions = transactions;
        this.mPendingConfigBeans = pending;
        this.mMBeanServer = mbeanServer;
    }

    private void configBeanRemoved(ConfigBean cb) {
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName != null) {
            ImplUtil.unregisterAMXMBeans((MBeanServer)this.mMBeanServer, (ObjectName)objectName);
            this.mRegistry.remove(objectName);
        } else {
            this.mPendingConfigBeans.remove(cb);
        }
    }

    private void issueAttributeChange(ConfigBean cb, String xmlAttrName, Object oldValue, Object newValue, long whenChanged) {
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName == null) {
            throw new IllegalArgumentException("Can't issue attribute change for null ObjectName for ConfigBean " + cb.getProxyType().getName());
        }
        boolean changed = false;
        if (oldValue != null) {
            changed = !oldValue.equals(newValue);
        } else if (newValue != null) {
            boolean bl = changed = !newValue.equals(oldValue);
        }
        if (changed) {
            // empty if block
        }
    }

    private void sortAndDispatch(List<PropertyChangeEvent> events, long whenChanged) {
        String propertyName;
        Object source;
        Object newValue;
        Object oldValue;
        ArrayList<ConfigBean> newConfigBeans = new ArrayList<ConfigBean>();
        ArrayList<PropertyChangeEvent> remainingEvents = new ArrayList<PropertyChangeEvent>();
        for (PropertyChangeEvent event : events) {
            ConfigBean cb;
            ConfigBeanProxy cbp;
            oldValue = event.getOldValue();
            newValue = event.getNewValue();
            source = event.getSource();
            propertyName = event.getPropertyName();
            if (oldValue == null && newValue instanceof ConfigBeanProxy) {
                cbp = (ConfigBeanProxy)newValue;
                cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                Class proxyClass = cb.getProxyType();
                boolean doWait = this.amxIsRunning();
                this.handleConfigBean(cb, doWait);
                newConfigBeans.add(cb);
                continue;
            }
            if (newValue == null && oldValue instanceof ConfigBeanProxy && this.amxIsRunning()) {
                cbp = (ConfigBeanProxy)oldValue;
                cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                this.configBeanRemoved(cb);
                continue;
            }
            remainingEvents.add(event);
        }
        if (this.amxIsRunning()) {
            for (PropertyChangeEvent event : remainingEvents) {
                String sourceString;
                oldValue = event.getOldValue();
                newValue = event.getNewValue();
                source = event.getSource();
                propertyName = event.getPropertyName();
                String string = sourceString = source instanceof ConfigBeanProxy ? ConfigSupport.proxyType((ConfigBeanProxy)((ConfigBeanProxy)source)).getName() : "" + source;
                if (source instanceof ConfigBeanProxy) {
                    ConfigBeanProxy cbp = (ConfigBeanProxy)source;
                    ConfigBean cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                    Class proxyClass = ConfigSupport.proxyType((ConfigBeanProxy)cbp);
                    if (this.mRegistry.getObjectName(cb) == null) {
                        if (newConfigBeans.contains(cb)) continue;
                        this.handleConfigBean(cb, false);
                        newConfigBeans.add(cb);
                        continue;
                    }
                    this.issueAttributeChange(cb, propertyName, oldValue, newValue, whenChanged);
                    continue;
                }
                AMXConfigLoader.debug("AMXConfigLoader.sortAndDispatch: WARNING: source is not a ConfigBean");
            }
        }
    }

    public void transactionCommited(List<PropertyChangeEvent> changes) {
        this.sortAndDispatch(changes, System.currentTimeMillis());
    }

    public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
    }

    protected void postRegisterHook(Boolean registrationDone) {
        super.postRegisterHook(registrationDone);
        if (registrationDone.booleanValue()) {
            this.mPendingConfigBeans.swapTransactionListener((TransactionListener)this);
        }
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
    }

    protected void postDeregisterHook() {
        super.postDeregisterHook();
        this.mTransactions.removeTransactionsListener((TransactionListener)this);
    }

    protected void handleConfigBean(ConfigBean cb, boolean waitDone) {
        if (this.mRegistry.getObjectName(cb) == null) {
            PendingConfigBeanJob job = this.mPendingConfigBeans.add(cb, waitDone);
            if (waitDone) {
                try {
                    job.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private ConfigBean getActualParent(ConfigBean configBean) {
        ConfigBean parent = AMXConfigLoader.asConfigBean(configBean.parent());
        if (parent != null) {
            ObjectName objectName = this.mRegistry.getObjectName(parent);
        } else if (!configBean.getProxyType().getName().endsWith("Domain")) {
            AMXConfigLoader.debug("WARNING: parent is null for " + configBean.getProxyType().getName() + " (bug in ConfigBeans)");
        }
        return parent;
    }

    private ObjectName getActualParentObjectName(ConfigBean configBean) {
        ObjectName parentObjectName = null;
        ConfigBean parent = this.getActualParent(configBean);
        if (parent != null) {
            parentObjectName = this.mRegistry.getObjectName(parent);
        }
        return parentObjectName;
    }

    static ConfigBean asConfigBean(Object o) {
        return o instanceof ConfigBean ? (ConfigBean)o : null;
    }

    public synchronized ObjectName start() {
        if (this.mLoaderThread == null) {
            this.mLoaderThread = new AMXConfigLoaderThread(this.mPendingConfigBeans);
            this.mLoaderThread.setDaemon(true);
            this.mLoaderThread.start();
            ObjectName objectName = JMXUtil.newObjectName((String)"v3-support", (String)"name=config");
            try {
                this.mMBeanServer.registerMBean(this, objectName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private synchronized boolean amxIsRunning() {
        return this.mLoaderThread != null;
    }

    private ObjectName registerConfigBeanAsMBean(ConfigBean cb) {
        ObjectName objectName = null;
        ConfigBean parentCB = this.getActualParent(cb);
        if (parentCB != null && this.mRegistry.getObjectName(parentCB) == null) {
            this.registerConfigBeanAsMBean(parentCB);
        }
        objectName = this._registerConfigBeanAsMBean(cb, parentCB);
        assert (this.mRegistry.getObjectName(cb) != null);
        return objectName;
    }

    private ObjectName _registerConfigBeanAsMBean(ConfigBean cb, ConfigBean parentCB) {
        Class cbClass = cb.getProxyType();
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName != null) {
            throw new IllegalArgumentException("ConfigBean " + cbClass.getName() + " already registered as " + objectName);
        }
        if (parentCB != null && this.mRegistry.getObjectName(parentCB) == null) {
            throw new IllegalArgumentException("ConfigBean parent " + parentCB.getProxyType().getName() + " must be registered first before child = " + cbClass.getName());
        }
        objectName = this.buildObjectName(cb);
        objectName = this.createAndRegister(cb, objectName);
        ImplUtil.getLogger().fine("REGISTERED MBEAN: " + JMXUtil.toString((ObjectName)objectName));
        return objectName;
    }

    private ObjectName createAndRegister(ConfigBean cb, ObjectName objectNameIn) {
        ObjectName objectName = objectNameIn;
        String type = objectNameIn.getKeyProperty("type");
        ObjectName parentObjectName = this.getActualParentObjectName(cb);
        if (parentObjectName == null) {
            parentObjectName = this.getDomainRoot();
        }
        AMXConfigImpl impl = new AMXConfigImpl(parentObjectName, cb);
        try {
            ObjectInstance instance = this.mMBeanServer.registerMBean((Object)impl, objectNameIn);
            objectName = instance.getObjectName();
            this.mRegistry.add(cb, objectName);
        }
        catch (JMException e) {
            AMXConfigLoader.debug(ExceptionUtil.toString((Throwable)e));
            if (e instanceof InstanceAlreadyExistsException) {
                AMXConfigLoader.debug("" + impl.getMBeanInfo());
            }
            objectName = null;
        }
        return objectName;
    }

    private String getType(ConfigBean cb) {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        return spt.getTypeString();
    }

    public static String getName(ConfigBean cb) {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        if (spt.isSingleton()) {
            return null;
        }
        String name = null;
        String nameHint = spt.getNameHint();
        if (nameHint == null) {
            name = "MISSING_NAME__KEY_MUST_BE_SPECIFIED_IN_INTERFACE";
        } else if (spt.nameHintIsElement()) {
            List leaf = cb.leafElements(nameHint);
            if (leaf != null) {
                List items = TypeCast.checkList((List)leaf, String.class);
                if (items.size() != 1) {
                    throw new IllegalArgumentException("Can't find sub-element of type " + nameHint + " in " + cb.getProxyType().getName());
                }
                name = (String)items.get(0);
            }
        } else {
            name = cb.rawAttribute(nameHint);
        }
        return name;
    }

    private ObjectName getDomainRoot() {
        return ObjectNames.getDomainRootObjectName();
    }

    private DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRoot();
    }

    private ObjectName buildObjectName(ConfigBean cb) {
        ConfigBean parent = this.getActualParent(cb);
        ObjectName parentObjectName = parent == null ? this.getDomainRoot() : this.mRegistry.getObjectName(parent);
        String type = this.getType(cb);
        String name = AMXConfigLoader.getName(cb);
        ObjectName objectName = ObjectNames.buildChildObjectName((MBeanServer)this.mServer, (ObjectName)parentObjectName, (String)type, (String)name);
        return objectName;
    }

    private final class AMXConfigLoaderThread
    extends Thread {
        private final PendingConfigBeansNew mPending;
        volatile boolean mQuit;

        AMXConfigLoaderThread(PendingConfigBeansNew pending) {
            super("AMXConfigLoader.AMXConfigLoaderThread");
            this.mQuit = false;
            this.mPending = pending;
        }

        void quit() {
            this.mQuit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectName registerOne(PendingConfigBeanJob job) {
            ConfigBean cb = job.getConfigBean();
            ObjectName objectName = AMXConfigLoader.this.mRegistry.getObjectName(cb);
            try {
                if (objectName == null) {
                    objectName = AMXConfigLoader.this.registerConfigBeanAsMBean(cb);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                job.releaseLatch();
            }
            return objectName;
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        protected void doRun() throws Exception {
            PendingConfigBeanJob job = this.mPending.take();
            while (!this.mQuit && job != null) {
                ObjectName objectName = this.registerOne(job);
                job = this.mPending.peek();
                if (job == null) continue;
                job = this.mPending.take();
            }
            ObjectName domainConfig = AMXConfigLoader.this.getDomainRootProxy().getDomain().extra().objectName();
            FeatureAvailability.getInstance().registerFeature("AMXConfigReady", (Object)domainConfig);
            while (!this.mQuit) {
                job = this.mPending.take();
                this.registerOne(job);
            }
        }
    }

    private static final class Job {
        final ConfigBean mConfigBean;
        final CountDownLatch mLatch;

        public Job(ConfigBean configBean, CountDownLatch latch) {
            this.mConfigBean = configBean;
            this.mLatch = latch;
        }

        public void releaseLatch() {
            if (this.mLatch != null) {
                this.mLatch.countDown();
            }
        }
    }
}

