/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.admin.amx.base.QueryMgr;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Extra;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.intf.config.ClusterRefConfig;
import org.glassfish.admin.amx.intf.config.ClusterRefConfigReferent;
import org.glassfish.admin.amx.intf.config.DeployedItemRefConfig;
import org.glassfish.admin.amx.intf.config.DeployedItemRefConfigReferent;
import org.glassfish.admin.amx.intf.config.RefConfig;
import org.glassfish.admin.amx.intf.config.RefConfigReferent;
import org.glassfish.admin.amx.intf.config.ResourceRefConfig;
import org.glassfish.admin.amx.intf.config.ResourceRefConfigReferent;
import org.glassfish.admin.amx.intf.config.ServerRefConfig;
import org.glassfish.admin.amx.intf.config.ServerRefConfigReferent;
import org.glassfish.admin.amx.util.AMXDebug;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.Output;
import org.glassfish.admin.amx.util.SetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefHelper {
    public static final String DEPLOYED_ITEM_REF_CONFIG_TYPE = Util.deduceType(DeployedItemRefConfig.class);
    public static final String RESOURCE_REF_CONFIG_TYPE = Util.deduceType(ResourceRefConfig.class);
    public static final String SERVER_REF_CONFIG_TYPE = Util.deduceType(ServerRefConfig.class);
    public static final String CLUSTER_REF_CONFIG_TYPE = Util.deduceType(ClusterRefConfig.class);
    private static final Set<String> REFERENT_J2EE_TYPES = Collections.unmodifiableSet(SetUtil.newSet((Object[])new String[]{DEPLOYED_ITEM_REF_CONFIG_TYPE, RESOURCE_REF_CONFIG_TYPE, SERVER_REF_CONFIG_TYPE, CLUSTER_REF_CONFIG_TYPE}));

    private RefHelper() {
    }

    private static Output getDebug() {
        return AMXDebug.getInstance().getOutput("com.sun.appserv.management.helper.RefHelper");
    }

    public static Set<RefConfig> findAllRefConfigs(QueryMgr queryMgr) {
        Set refs = queryMgr.queryInterfaceSet(RefConfig.class.getName(), null);
        return refs;
    }

    public static <T extends RefConfig> Set<T> findAllRefConfigs(QueryMgr queryMgr, Class<T> intf) {
        Set refs = queryMgr.queryTypeSet(Util.deduceType(intf));
        return RefHelper.as(refs, intf);
    }

    public static Set<ResourceRefConfig> findAllResourceRefConfigs(QueryMgr queryMgr) {
        return RefHelper.findAllRefConfigs(queryMgr, ResourceRefConfig.class);
    }

    public static Set<DeployedItemRefConfig> findAllDeployedItemRefConfigs(QueryMgr queryMgr) {
        return RefHelper.findAllRefConfigs(queryMgr, DeployedItemRefConfig.class);
    }

    public static Set<ServerRefConfig> findAllServerRefConfigs(QueryMgr queryMgr) {
        return RefHelper.findAllRefConfigs(queryMgr, ServerRefConfig.class);
    }

    public static Set<ClusterRefConfig> findAllClusterRefConfigs(QueryMgr queryMgr) {
        return RefHelper.findAllRefConfigs(queryMgr, ClusterRefConfig.class);
    }

    public static Set<RefConfig> findAllRefConfigsWithName(QueryMgr queryMgr, String refJ2EEType, String name) {
        String props = Util.makeRequiredProps((String)refJ2EEType, (String)name);
        Set refs = queryMgr.queryPatternSet(null, props);
        return refs;
    }

    public static String getReferentRefType(RefConfigReferent referent) {
        String type = null;
        if (referent instanceof ResourceRefConfigReferent) {
            type = Util.deduceType(ResourceRefConfig.class);
        } else if (referent instanceof DeployedItemRefConfigReferent) {
            type = Util.deduceType(DeployedItemRefConfig.class);
        } else if (referent instanceof ServerRefConfigReferent) {
            type = Util.deduceType(ServerRefConfig.class);
        } else if (referent instanceof ClusterRefConfigReferent) {
            type = Util.deduceType(ClusterRefConfig.class);
        } else {
            throw new IllegalArgumentException("Unknown referent class: " + Util.getTypeProp((AMXProxy)Util.asAMX((Object)referent)));
        }
        return type;
    }

    public static Set<String> getReferentJ2EETypes() {
        return REFERENT_J2EE_TYPES;
    }

    public static Set<RefConfig> findAllRefConfigs(RefConfigReferent referent) {
        AMXProxy amx = Util.asAMX((Object)referent);
        return RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), RefHelper.getReferentRefType(referent), amx.getName());
    }

    public static Set<RefConfig> findAllRefConfigs(RefConfigReferent referent, String refJ2EEType) {
        AMXProxy amx = Util.asAMX((Object)referent);
        return RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), refJ2EEType, amx.getName());
    }

    public static Set<DeployedItemRefConfig> findAllRefConfigs(DeployedItemRefConfigReferent referent) {
        AMXProxy amx = Util.asAMX((Object)referent);
        Set<RefConfig> refs = RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), DEPLOYED_ITEM_REF_CONFIG_TYPE, amx.getName());
        return RefHelper.as(refs, DeployedItemRefConfig.class);
    }

    public static Set<ResourceRefConfig> findAllRefConfigs(ResourceRefConfigReferent referent) {
        AMXProxy amx = Util.asAMX((Object)referent);
        Set<RefConfig> refs = RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), RESOURCE_REF_CONFIG_TYPE, amx.getName());
        return RefHelper.as(refs, ResourceRefConfig.class);
    }

    public static <T extends RefConfig> Set<T> as(Set<? extends RefConfig> refs, Class<T> intf) {
        HashSet<AMXProxy> s = new HashSet<AMXProxy>();
        for (RefConfig refConfig : refs) {
            s.add(refConfig.as(intf));
        }
        return s;
    }

    public static Set<ServerRefConfig> findAllRefConfigs(ServerRefConfigReferent referent) {
        AMXProxy amx = Util.asAMX((Object)referent);
        return RefHelper.as(RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), SERVER_REF_CONFIG_TYPE, amx.name()), ServerRefConfig.class);
    }

    private static QueryMgr getQueryMgr(AMXProxy amx) {
        return amx.extra().proxyFactory().getDomainRoot().getQueryMgr();
    }

    public static Set<ClusterRefConfig> findAllRefConfigs(ClusterRefConfigReferent referent) {
        AMXProxy amx = Util.asAMX((Object)referent);
        Set<RefConfig> refs = RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), CLUSTER_REF_CONFIG_TYPE, amx.name());
        return RefHelper.as(refs, ClusterRefConfig.class);
    }

    public static Set<RefConfig> removeAllRefsTo(RefConfigReferent item, boolean allowSingleFailure) {
        Set<RefConfig> refs = RefHelper.findAllRefConfigs(item);
        Set<RefConfig> failures = RefHelper.removeRefConfigs(refs);
        if (!(failures.size() == 0 || failures.size() <= 1 && allowSingleFailure)) {
            List objectNames = Util.toObjectNames(failures);
            throw new IllegalArgumentException("failure removing refererences:\n{" + CollectionUtil.toString((Collection)objectNames, (String)"\n") + "\n}");
        }
        return failures;
    }

    public static Set<RefConfig> removeRefConfigs(Set<RefConfig> refs) {
        HashSet<RefConfig> failures = new HashSet<RefConfig>();
        for (RefConfig ref : refs) {
            Extra extra = ref.extra();
            if (!extra.valid()) continue;
            AMXConfigProxy rrc = (AMXConfigProxy)AMXConfigProxy.class.cast(ref.getParent());
            try {
                rrc.removeChild(Util.getTypeProp((AMXProxy)ref), ref.getName());
            }
            catch (Exception e) {
                failures.add(ref);
            }
        }
        return failures;
    }
}

