/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.base.Tools;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsImpl
extends AMXImplBase {
    private static final String NL = StringUtil.NEWLINE();
    private static final String WILD_SUFFIX = ",*";
    private static final String WILD_ALL = "*";

    public ToolsImpl(ObjectName parent) {
        super(parent, Tools.class);
    }

    private static ObjectName newObjectName(String s) {
        try {
            return new ObjectName(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getInfo() {
        return this.info(WILD_ALL);
    }

    public String infoPP(String parentPath, boolean recursive) {
        Pathnames paths = this.getDomainRootProxy().getPathnames();
        Object[] objectNames = paths.listObjectNames(parentPath, recursive);
        Set s = SetUtil.newSet((Object[])objectNames);
        return this.info(s);
    }

    public String infoType(String type) {
        return this.info("*:type=" + type + WILD_SUFFIX);
    }

    public String infoPath(String path) {
        ObjectName objectName = this.getDomainRootProxy().getPathnames().resolvePath(path);
        ArrayList<ObjectName> c = objectName == null ? new ArrayList() : Collections.singleton(objectName);
        return this.info(c);
    }

    String info(Collection<ObjectName> objectNames) {
        StringBuffer buf = new StringBuffer();
        if (objectNames.size() != 0) {
            String NL = StringUtil.NEWLINE();
            for (ObjectName objectName : objectNames) {
                MBeanInfo mbeanInfo = ProxyFactory.getInstance((MBeanServer)this.getMBeanServer()).getMBeanInfo(objectName);
                buf.append("MBeanInfo for " + objectName + NL);
                buf.append(JMXUtil.toString((MBeanInfo)mbeanInfo));
                buf.append(NL + NL + NL + NL);
            }
        }
        buf.append("Matched " + objectNames.size() + " mbean(s).");
        return buf.toString();
    }

    public String info(String searchStringIn) {
        String domain = this.getObjectName().getDomain();
        ObjectName pattern = ToolsImpl.newObjectName(searchStringIn);
        if (pattern == null && (searchStringIn.length() == 0 || searchStringIn.equals(WILD_ALL))) {
            pattern = ToolsImpl.newObjectName("*:*");
        }
        if (pattern == null) {
            String temp = searchStringIn;
            boolean hasProps = temp.indexOf("=") > 0;
            boolean hasDomain = temp.indexOf(":") >= 0;
            boolean isPattern = temp.endsWith(WILD_SUFFIX);
            if (!(hasProps || hasDomain || isPattern)) {
                pattern = ToolsImpl.newObjectName("*:type=" + temp + WILD_SUFFIX);
                if (pattern == null) {
                    pattern = ToolsImpl.newObjectName("*:j2eeType=" + temp + WILD_SUFFIX);
                }
                if (pattern == null) {
                    pattern = ToolsImpl.newObjectName("*:name=" + temp + WILD_SUFFIX);
                }
            }
            if (pattern == null) {
                return "No MBeans found for: " + searchStringIn;
            }
        }
        Set<ObjectName> objectNames = this.getMBeanServer().queryNames(pattern, null);
        return this.info(objectNames);
    }

    public Object validate(AMXProxy proxy) {
        DomainRoot dr = this.getDomainRootProxy();
        Pathnames paths = dr.getPathnames();
        try {
            String path = proxy.path();
            ObjectName actualObjectName = Util.getObjectName((AMXProxy)proxy);
            ObjectName o = paths.resolvePath(path);
            if (o == null) {
                return "Path " + path + " does not resolve to any ObjectName, should resolve to: " + actualObjectName;
            }
            if (!actualObjectName.equals(o)) {
                return "Path " + path + " does not resolve to ObjectName: " + actualObjectName;
            }
        }
        catch (Throwable t) {
            return t;
        }
        return null;
    }

    public String validate() {
        ObjectName[] all;
        Stuff stuff = new Stuff();
        DomainRoot dr = this.getDomainRootProxy();
        Pathnames paths = dr.getPathnames();
        HashMap m = new HashMap();
        Object result = this.validate((AMXProxy)dr);
        stuff.result(Util.getObjectName((AMXProxy)dr), result);
        for (ObjectName objectName : all = paths.listObjectNames(dr.path(), true)) {
            AMXProxy amx = this.getProxyFactory().getProxy(objectName);
            result = this.validate(amx);
            stuff.result(objectName, result);
        }
        return all.length + " MBeans tested." + NL + stuff.toString();
    }

    private static final class Stuff {
        private final Map<ObjectName, Object> mFailures = new HashMap<ObjectName, Object>();
        private final StringBuilder mBuf = new StringBuilder();

        void result(ObjectName objectName, Object result) {
            if (result != null) {
                this.mFailures.put(objectName, result);
                this.mBuf.append(objectName + ": " + result + NL);
            }
        }

        public String toString() {
            return this.mFailures.size() + " failures." + NL + this.mBuf.toString();
        }
    }
}

