/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.path;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.glassfish.admin.amx.impl.path.DottedNameWildcardMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DottedNameWildcardMatcherImpl
implements DottedNameWildcardMatcher {
    final Set<String> mSearchSet;

    public DottedNameWildcardMatcherImpl(Set<String> searchSet) {
        this.mSearchSet = searchSet;
    }

    Set<String> resolveAll(String wildcardedName, Iterator<String> iter) {
        HashSet<String> resolvedSet = new HashSet<String>();
        Pattern pattern = Pattern.compile(wildcardedName);
        while (iter.hasNext()) {
            String candidate = iter.next();
            if (!pattern.matcher(candidate).matches()) continue;
            resolvedSet.add(candidate);
        }
        return resolvedSet;
    }

    @Override
    public Set<String> matchDottedNames(String dottedNameString) {
        HashSet<String> resolvedSet = null;
        if (dottedNameString.equals(".*")) {
            resolvedSet = new HashSet<String>();
            resolvedSet.addAll(this.mSearchSet);
        } else {
            resolvedSet = this.resolveAll(dottedNameString, this.mSearchSet.iterator());
        }
        return resolvedSet;
    }
}

