/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.path;

import java.util.Collections;
import java.util.List;
import org.glassfish.admin.amx.impl.path.DottedNameSpecialChars;
import org.glassfish.admin.amx.impl.path.DottedNameStrings;
import org.glassfish.admin.amx.impl.path.ParsedV3Pathname;
import org.glassfish.admin.amx.impl.path.PathPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class V3Pathname {
    final String mSourceString;
    final ParsedV3Pathname mParsed;

    public V3Pathname(String sourceString) {
        this.mSourceString = sourceString;
        try {
            this.mParsed = ParsedV3Pathname.parse(sourceString);
        }
        catch (Exception e) {
            String msg = DottedNameStrings.getString("MalformedDottedName", sourceString);
            throw new IllegalArgumentException(msg);
        }
    }

    public String toString() {
        return this.mSourceString;
    }

    static boolean needsEscaping(String part) {
        boolean needsEscaping = false;
        int numChars = part.length();
        for (int i = 0; i < numChars; ++i) {
            char theChar = part.charAt(i);
            if (DottedNameSpecialChars.ESCAPEABLE_CHARS_STR.indexOf(theChar) < 0) continue;
            needsEscaping = true;
            break;
        }
        return needsEscaping;
    }

    public static String escapePart(String part) {
        String result = part;
        if (V3Pathname.needsEscaping(part)) {
            int numChars = part.length();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < numChars; ++i) {
                char theChar = part.charAt(i);
                if (DottedNameSpecialChars.ESCAPEABLE_CHARS_STR.indexOf(theChar) >= 0) {
                    buf.append('\\');
                }
                buf.append(theChar);
            }
            return buf.toString();
        }
        return result;
    }

    public static String hyphenate(String name) {
        int length = name.length();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char lowerc;
            char c = name.charAt(i);
            boolean isUpper = Character.isUpperCase(c);
            char c2 = lowerc = isUpper ? Character.toLowerCase(c) : c;
            if (isUpper && i != 0 && Character.isUpperCase(name.charAt(i - 1))) {
                b.append("-");
                b.append(lowerc);
                continue;
            }
            if (!isUpper && i < length - 1 && Character.isUpperCase(name.charAt(i + 1))) {
                b.append(lowerc);
                b.append("-");
                continue;
            }
            b.append(lowerc);
        }
        return b.toString();
    }

    public List<PathPart> getParts() {
        return Collections.unmodifiableList(this.mParsed.getParts());
    }

    public ParsedV3Pathname getParsed() {
        return this.mParsed;
    }

    public PathPart getPart(int i) {
        return this.mParsed.getParts().get(i);
    }

    public static boolean isWildcardName(String name) {
        boolean isWild = false;
        int numWilds = "*".length();
        for (int i = 0; i < numWilds; ++i) {
            char wildChar = "*".charAt(i);
            if (name.indexOf(wildChar) < 0) continue;
            isWild = true;
            break;
        }
        return isWild;
    }

    public boolean isWildcardName() {
        return V3Pathname.isWildcardName(this.toString());
    }

    public int hashCode() {
        int hashcode = 17;
        hashcode = 37 * hashcode + this.mSourceString.hashCode();
        hashcode = 37 * hashcode + this.mParsed.hashCode();
        return hashcode;
    }

    public boolean equals(Object other) {
        boolean equals = false;
        equals = !(other instanceof V3Pathname) ? false : (other == this ? true : this.toString().equals(other.toString()));
        return equals;
    }
}

