/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client.handler;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AMXClientLogger;
import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.client.handler.PerMBeanCache;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanProxyHandler;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AMXProxyHandler
extends MBeanProxyHandler
implements Extra {
    protected final PerMBeanCache mCache;
    private boolean mCheckedForInvariantMBeanInfo = false;
    protected static final String DEBUG_ID = "com.sun.appserv.management.client.handler.AMXProxyHandler";
    private static final String CREATE = "create";
    private static final String GET = "get";
    private static final String MAP_SUFFIX = "Map";
    private static final String SET_SUFFIX = "Set";
    private static final String LIST_SUFFIX = "List";
    private static final String OBJECT_NAME_MAP_SUFFIX = "ObjectNameMap";
    private static final String OBJECT_NAME_SET_SUFFIX = "ObjectNameSet";
    private static final String OBJECT_NAME_LIST_SUFFIX = "ObjectNameList";
    private static final String OBJECT_NAME_SUFFIX = "ObjectName";
    private static final String CONTAINEE_J2EE_TYPES = "ContaineeJ2EETypes";
    private static final String CONTAINER = "Container";
    private static final String DOMAIN_ROOT = "DomainRoot";
    private static final String MBEAN_INFO = "MBeanInfo";
    private static final String ATTRIBUTE_NAMES = "AttributeNames";
    private static final String J2EE_NAME = "Name";
    private static final String J2EE_TYPE = "J2EEType";
    public static final String ADD_NOTIFICATION_LISTENER = "addNotificationListener";
    public static final String REMOVE_NOTIFICATION_LISTENER = "removeNotificationListener";
    private static final String QUERY = "query";
    private static final String STRING = String.class.getName();
    private static final String[] EMPTY_SIG = new String[0];
    private static final String[] STRING_SIG = new String[]{STRING};
    private static final String[] STRING2_SIG = new String[]{STRING, STRING};
    private static final String GET_SINGLETON_CONTAINEE = "getSingletonContainee";
    private static final String GET_CONTAINEE = "getContainee";
    private static final String GET_SINGLETON_CONTAINEE_OBJECT_NAME = "getSingletonContaineeObjectName";
    private static final String[] GET_SINGLETON_CONTAINEE_OBJECT_NAME_SIG1 = STRING_SIG;
    private static final String[] GET_SINGLETON_CONTAINEE_OBJECT_NAME_SIG2 = STRING2_SIG;
    private static final String[] GET_OBJECT_NAMES_SIG_EMPTY = EMPTY_SIG;
    private static final String[] GET_OBJECT_NAMES_SIG_STRING = STRING_SIG;
    private static final Map<String, AMX> EMPTY_String_AMX = Collections.emptyMap();
    private static final Class[] NOTIFICATION_LISTENER_SIG1 = new Class[]{NotificationListener.class};
    private static final Class[] NOTIFICATION_LISTENER_SIG2 = new Class[]{NotificationListener.class, NotificationFilter.class, Object.class};
    private static final Set<String> CACHED_ATTRIBUTE_NAMES = GSetUtil.newUnmodifiableStringSet("MBeanInfoIsInvariant", "InterfaceName", "Group", "FullType", "ContaineeJ2EETypes");
    private static final String GET_MBEAN_INFO = "getMBeanInfo";
    private static final String GET_J2EE_TYPE = "getJ2EEType";
    private static final String GET_J2EE_NAME = "getName";
    private static final String GET_ATTRIBUTE_NAMES = "getAttributeNames";
    private static final String GET_CONTAINER = "getContainer";
    private static final String GET_EXTRA = "getExtra";
    private static final String GET_ALL_ATTRIBUTES = "getAllAttributes";
    private static final String GET_DOMAIN_ROOT = "getDomainRoot";
    private static final String GET_OBJECT_NAME = "getObjectName";
    private static final Set<String> SPECIAL_METHOD_NAMES = GSetUtil.newUnmodifiableStringSet("getMBeanInfo", "getJ2EEType", "getName", "getAttributeNames", "getContainer", "getDomainRoot", "getObjectName", "getExtra", "getAllAttributes", "addNotificationListener", "removeNotificationListener");

    @Override
    protected String getDebugID() {
        return DEBUG_ID;
    }

    protected AMXProxyHandler(ConnectionSource connectionSource, ObjectName proxiedMBeanObjectName) throws IOException {
        super(connectionSource, proxiedMBeanObjectName);
        this.mDebug = AMXDebug.getInstance().getOutput(this.getDebugID());
        this.mCache = new PerMBeanCache();
        this.setProxyLogger(AMXClientLogger.getInstance());
    }

    protected void cacheAttribute(Attribute attr) {
        this.mCache.cacheAttribute(attr);
    }

    protected Attribute getCachedAttribute(String attrName) throws IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        Attribute attr = this.mCache.getCachedAttribute(attrName);
        if (attr == null) {
            MBeanServerConnection conn = this.getConnection();
            Object value = this.getConnection().getAttribute(this.getTargetObjectName(), attrName);
            attr = new Attribute(attrName, value);
            this.mCache.cacheAttribute(attr);
        }
        return attr;
    }

    protected Object getCachedAttributeValue(String attrName) throws IOException, JMException {
        Attribute attr = this.getCachedAttribute(attrName);
        assert (attr != null) : "getCachedAttributeValue: null for " + attrName;
        return attr == null ? null : attr.getValue();
    }

    private AMX getCachedProxy(Object key) {
        AMXProxyHandler handler;
        AMX proxy = null;
        proxy = key instanceof ObjectName ? this.getProxyFactory().getProxy((ObjectName)key, AMX.class) : Util.asAMX(this.mCache.getCachedItem(key));
        if (proxy != null && !(handler = (AMXProxyHandler)Proxy.getInvocationHandler(proxy)).targetIsValid()) {
            this.debug("removing cached proxy for key: ", key);
            this.mCache.remove(key);
            proxy = null;
        }
        return proxy;
    }

    private void cacheProxy(String key, AMX proxy) {
        this.mCache.cacheItem(key, proxy);
    }

    protected ObjectName getContainerObjectName() throws IOException, JMException {
        return (ObjectName)this.getCachedAttributeValue("ContainerObjectName");
    }

    protected Class getProxyInterface(ObjectName objectName) throws IOException, JMException, ClassNotFoundException {
        AMX proxy = this.getProxyFactory().getProxy(objectName, AMX.class);
        Class<?> proxyInterface = ClassUtil.getClassFromName(Util.getExtra(proxy).getInterfaceName());
        return proxyInterface;
    }

    private String _getInterfaceName() throws IOException, JMException {
        return (String)this.getCachedAttributeValue("InterfaceName");
    }

    @Override
    public String getInterfaceName() {
        try {
            return this._getInterfaceName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ProxyFactory getProxyFactory() {
        return ProxyFactory.getInstance(this.getConnectionSource());
    }

    synchronized Container getContainer(AMX myProxy) throws IOException, JMException, ClassNotFoundException {
        ObjectName objectName;
        Container containerProxy = null;
        if (!(myProxy instanceof DomainRoot) && (objectName = this.getContainerObjectName()) != null) {
            containerProxy = this.getProxyFactory().getProxy(objectName, Container.class);
        }
        return containerProxy;
    }

    private final DomainRoot getDomainRoot() throws IOException {
        return this.getProxyFactory().getDomainRoot();
    }

    protected synchronized AMX createProxy(ObjectName objectName) {
        return this.getProxyFactory().getProxy(objectName, AMX.class);
    }

    protected static boolean isProxyMapGetter(Method method, int argCount) {
        boolean isProxyMapGetter = false;
        String name = method.getName();
        if (name.startsWith(GET) && name.endsWith(MAP_SUFFIX) && !name.endsWith(OBJECT_NAME_MAP_SUFFIX) && argCount <= 1 && Map.class.isAssignableFrom(method.getReturnType())) {
            isProxyMapGetter = true;
        }
        return isProxyMapGetter;
    }

    protected static boolean isProxyListGetter(Method method, int argCount) {
        boolean isProxyListGetter = false;
        String name = method.getName();
        if ((name.startsWith(GET) || name.startsWith(QUERY)) && name.endsWith(LIST_SUFFIX) && !name.endsWith(OBJECT_NAME_LIST_SUFFIX) && argCount <= 1 && List.class.isAssignableFrom(method.getReturnType())) {
            isProxyListGetter = true;
        }
        return isProxyListGetter;
    }

    protected static boolean isSingleProxyGetter(Method method, int argCount) {
        boolean isProxyGetter = false;
        String name = method.getName();
        if ((name.startsWith(GET) || name.startsWith(QUERY)) && argCount <= 2 && AMX.class.isAssignableFrom(method.getReturnType())) {
            isProxyGetter = true;
        }
        return isProxyGetter;
    }

    protected static boolean isProxySetGetter(Method method, int argCount) {
        boolean isProxySetGetter = false;
        String name = method.getName();
        if ((name.startsWith(GET) || name.startsWith(QUERY)) && name.endsWith(SET_SUFFIX) && !name.endsWith(OBJECT_NAME_SET_SUFFIX) && argCount <= 2 && Set.class.isAssignableFrom(method.getReturnType())) {
            isProxySetGetter = true;
        }
        return isProxySetGetter;
    }

    private static String proxyGetterToObjectNameGetter(String methodName) {
        return methodName + OBJECT_NAME_SUFFIX;
    }

    private Object invokeTarget(String methodName, Object[] args, String[] sig) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException, AttributeNotFoundException {
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        if (numArgs == 0 && methodName.startsWith(GET)) {
            String attributeName = StringUtil.stripPrefix(methodName, GET);
            result = this.getConnection().getAttribute(this.getTargetObjectName(), attributeName);
        } else {
            result = this.getConnection().invoke(this.getTargetObjectName(), methodName, args, sig);
        }
        return result;
    }

    private String getJ2EEType(Class c) {
        return (String)ClassUtil.getFieldValue(c, "J2EE_TYPE");
    }

    AMX invokeSingleProxyGetter(Object myProxy, Method method, Object[] args) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException, AttributeNotFoundException {
        String methodName = method.getName();
        int numArgs = args == null ? 0 : args.length;
        String argString = args == null ? "" : ArrayStringifier.stringify(args, "_");
        String cacheKey = methodName + argString;
        AMX proxy = this.getCachedProxy(cacheKey);
        if (proxy == null) {
            Class<?> returnClass = method.getReturnType();
            ObjectName objectName = null;
            String j2eeType = this.getJ2EEType(returnClass);
            if (numArgs == 0) {
                String newMethodName = AMXProxyHandler.proxyGetterToObjectNameGetter(methodName);
                objectName = (ObjectName)this.invokeTarget(newMethodName, null, EMPTY_SIG);
            } else if (numArgs == 1 && args[0].getClass() == String.class) {
                String newMethodName = AMXProxyHandler.proxyGetterToObjectNameGetter(methodName);
                objectName = (ObjectName)this.invokeTarget(newMethodName, args, STRING_SIG);
            } else if ((methodName.equals(GET_SINGLETON_CONTAINEE) || methodName.equals(GET_CONTAINEE)) && numArgs == 2) {
                String newMethodName = AMXProxyHandler.proxyGetterToObjectNameGetter(methodName);
                objectName = (ObjectName)this.invokeTarget(newMethodName, args, GET_SINGLETON_CONTAINEE_OBJECT_NAME_SIG2);
            } else {
                this.getProxyLogger().warning("Unknown form of proxy getter: " + method);
                assert (false);
                throw new IllegalArgumentException();
            }
            if (objectName != null) {
                proxy = this.createProxy(objectName);
            }
            if (proxy != null) {
                if (cacheKey != null) {
                    this.cacheProxy(cacheKey, proxy);
                }
            } else {
                this.getProxyLogger().fine("invokeSingleProxyGetter: NULL ObjectName for: " + methodName + "()");
            }
        }
        return proxy;
    }

    protected static boolean isProxyCreator(Method method) {
        String methodName = method.getName();
        return methodName.startsWith(CREATE) && AMX.class.isAssignableFrom(method.getReturnType());
    }

    AMX invokeProxyCreator(Method method, Object[] args) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException, AttributeNotFoundException {
        String methodName = method.getName();
        String[] stringSig = AMXProxyHandler.getStringSig(method);
        ObjectName objectName = (ObjectName)this.invokeTarget(methodName, args, stringSig);
        assert (objectName != null) : "received null ObjectName from: " + methodName + " on target " + this.getTargetObjectName();
        AMX proxy = this.createProxy(objectName);
        assert (this.getProxyFactory().getProxy(Util.getExtra(proxy).getObjectName(), AMX.class, false) == proxy);
        return proxy;
    }

    private static String toString(Object o) {
        String result = o == null ? "null" : SmartStringifier.toString(o);
        int MAX_LENGTH = 256;
        if (result.length() > 256) {
            result = result.substring(0, 255) + "...";
        }
        return result;
    }

    private static String[] getStringSig(Method method) {
        Class[] sig = method.getParameterTypes();
        String[] stringSig = ClassUtil.classnamesFromSignature(sig);
        return stringSig;
    }

    protected static String convertMethodName(String srcName, String srcSuffix, String resultSuffix) {
        if (!srcName.endsWith(srcSuffix)) {
            throw new IllegalArgumentException(srcName + " does not end with " + srcSuffix);
        }
        String baseName = srcName.substring(0, srcName.lastIndexOf(srcSuffix));
        return baseName + resultSuffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, ?> invokeProxyMapGetter(Object myProxy, Method method, Object[] args) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException, ClassNotFoundException, AttributeNotFoundException, JMException {
        int argCount = args == null ? 0 : args.length;
        String methodName = method.getName();
        String getObjectNameMapName = AMXProxyHandler.convertMethodName(methodName, MAP_SUFFIX, OBJECT_NAME_MAP_SUFFIX);
        MBeanServerConnection conn = this.getConnection();
        Map m = TypeCast.asMap(this.invokeTarget(getObjectNameMapName, args, AMXProxyHandler.getStringSig(method)));
        assert (m != null) : "mbean " + this.getTargetObjectName() + " returned null Map for " + getObjectNameMapName;
        Map<String, AMX> result = null;
        if (m.keySet().size() == 0) return EMPTY_String_AMX;
        ProxyFactory proxyFactory = this.getProxyFactory();
        Object firstValue = m.values().iterator().next();
        if (firstValue instanceof ObjectName) {
            Map<String, ObjectName> onm = TypeCast.asMap(m);
            Map<String, AMX> proxyMap = proxyFactory.toProxyMap(onm);
            return proxyMap;
        }
        if (!(firstValue instanceof Map)) throw new IllegalArgumentException();
        Map objectNameMaps = TypeCast.asMap(m);
        HashMap<String, AMX> proxyMaps = new HashMap<String, AMX>();
        Iterator i$ = objectNameMaps.keySet().iterator();
        while (i$.hasNext()) {
            String j2eeType = (String)i$.next();
            Map objectNameMap = (Map)objectNameMaps.get(j2eeType);
            Map<String, AMX> proxyMap = proxyFactory.toProxyMap(objectNameMap);
            proxyMaps.put(j2eeType, (AMX)((Object)proxyMap));
        }
        return proxyMaps;
    }

    private List<AMX> invokeProxyListGetter(Object myProxy, Method method, Object[] args) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException, ClassNotFoundException, AttributeNotFoundException, JMException {
        String remoteNAME = AMXProxyHandler.convertMethodName(method.getName(), LIST_SUFFIX, OBJECT_NAME_LIST_SUFFIX);
        List<ObjectName> objectNames = TypeCast.asList(this.invokeTarget(remoteNAME, args, AMXProxyHandler.getStringSig(method)));
        List<AMX> result = this.getProxyFactory().toProxyList(objectNames);
        return result;
    }

    private Set<AMX> invokeProxySetGetter(Object myProxy, Method method, Object[] args) throws IOException, JMException, ClassNotFoundException {
        assert (Set.class.isAssignableFrom(method.getReturnType()));
        String methodName = method.getName();
        String getObjectNamesName = AMXProxyHandler.convertMethodName(methodName, SET_SUFFIX, OBJECT_NAME_SET_SUFFIX);
        MBeanServerConnection conn = this.getConnection();
        String[] stringSig = AMXProxyHandler.getStringSig(method);
        Set<ObjectName> objectNames = TypeCast.asSet(this.invokeTarget(getObjectNamesName, args, stringSig));
        Set<AMX> proxies = this.getProxyFactory().toProxySet(objectNames);
        return proxies;
    }

    private synchronized MBeanInfo _getMBeanInfo() throws IOException, InstanceNotFoundException, ReflectionException, IntrospectionException {
        MBeanInfo mbeanInfo = null;
        if (!this.mCheckedForInvariantMBeanInfo) {
            this.mCheckedForInvariantMBeanInfo = true;
            try {
                Boolean cacheIt = (Boolean)this.getAttribute("MBeanInfoIsInvariant");
                this.setMBeanInfoIsInvariant(cacheIt);
                this.cacheMBeanInfo(cacheIt);
            }
            catch (Exception e) {
                this.cacheMBeanInfo(false);
                this.setMBeanInfoIsInvariant(false);
            }
        }
        mbeanInfo = this.getMBeanInfo(this.getCacheMBeanInfo());
        return mbeanInfo;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            return this._getMBeanInfo();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectName getObjectName() {
        return this.getTargetObjectName();
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        Map<String, Object> result = Collections.emptyMap();
        try {
            String[] names = this.getAttributeNames();
            AttributeList attrs = this.getAttributes(names);
            result = JMXUtil.attributeListToValueMap(attrs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public String[] getAttributeNames() {
        String attrName = ATTRIBUTE_NAMES;
        Attribute attr = null;
        try {
            attr = this.getCachedAttribute(ATTRIBUTE_NAMES);
        }
        catch (AttributeNotFoundException e) {
            attr = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String[] names = null;
        if (attr == null) {
            MBeanInfo mbeanInfo = this.getMBeanInfo();
            names = JMXUtil.getAttributeNames(mbeanInfo.getAttributes());
            if (this.getMBeanInfoIsInvariant()) {
                this.cacheAttribute(new Attribute(ATTRIBUTE_NAMES, names));
            }
        } else {
            names = (String[])attr.getValue();
        }
        return names;
    }

    private Object handleSpecialMethod(Object myProxy, Method method, Object[] args) throws ClassNotFoundException, JMException, IOException {
        String methodName = method.getName();
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        boolean handled = true;
        if (numArgs == 0) {
            if (methodName.equals(GET_CONTAINER)) {
                result = this.getContainer(Util.asAMX(myProxy));
            } else if (methodName.equals(GET_EXTRA)) {
                assert (this instanceof Extra);
                result = this;
            } else if (methodName.equals(GET_OBJECT_NAME)) {
                result = this.getTargetObjectName();
            } else if (methodName.equals(GET_DOMAIN_ROOT)) {
                result = this.getDomainRoot();
            } else if (methodName.equals(GET_ATTRIBUTE_NAMES)) {
                result = this.getAttributeNames();
            } else if (methodName.equals(GET_J2EE_TYPE)) {
                result = Util.getJ2EEType(this.getTargetObjectName());
            } else if (methodName.equals(GET_J2EE_NAME)) {
                result = Util.getName(this.getTargetObjectName());
            } else if (methodName.equals(GET_ALL_ATTRIBUTES)) {
                result = this.getAllAttributes();
            } else {
                handled = false;
            }
        } else {
            if (numArgs == 1 && methodName.equals("equals")) {
                return this.equals(args[0]);
            }
            Class[] signature = method.getParameterTypes();
            if (methodName.equals(ADD_NOTIFICATION_LISTENER) && (ClassUtil.sigsEqual(NOTIFICATION_LISTENER_SIG1, signature) || ClassUtil.sigsEqual(NOTIFICATION_LISTENER_SIG2, signature))) {
                this.addNotificationListener(args);
            } else if (methodName.equals(REMOVE_NOTIFICATION_LISTENER) && (ClassUtil.sigsEqual(NOTIFICATION_LISTENER_SIG1, signature) || ClassUtil.sigsEqual(NOTIFICATION_LISTENER_SIG2, signature))) {
                this.removeNotificationListener(args);
            } else {
                handled = false;
            }
        }
        if (!handled) {
            assert (false);
            throw new RuntimeException("unknown method: " + method);
        }
        return result;
    }

    @Override
    public final Object invoke(Object myProxy, Method method, Object[] args) throws Throwable {
        try {
            Object result = this._invoke(myProxy, method, args);
            assert (result == null || ClassUtil.IsPrimitiveClass(method.getReturnType()) || method.getReturnType().isAssignableFrom(result.getClass())) : method.getName() + ": result of type " + result.getClass().getName() + " not assignable to " + method.getReturnType().getName() + ", " + "interfaces: " + AMXProxyHandler.toString(result.getClass().getInterfaces() + ", ObjectName = " + JMXUtil.toString(this.getTargetObjectName()));
            return result;
        }
        catch (IOException e) {
            this.getProxyFactory().checkConnection();
            throw e;
        }
        catch (InstanceNotFoundException e) {
            this.checkValid();
            throw e;
        }
    }

    protected Object _invoke(Object myProxy, Method method, Object[] args) throws Throwable {
        this.debugMethod(method.getName(), args);
        if (!this.targetIsValid()) {
            throw new InstanceNotFoundException(this.getTargetObjectName().toString());
        }
        Object result = null;
        String methodName = method.getName();
        int numArgs = args == null ? 0 : args.length;
        boolean handled = false;
        if (SPECIAL_METHOD_NAMES.contains(methodName)) {
            handled = true;
            result = this.handleSpecialMethod(myProxy, method, args);
        } else if (JMXUtil.isIsOrGetter(method)) {
            assert (!handled);
            String attrName = JMXUtil.getAttributeName(method);
            if (CACHED_ATTRIBUTE_NAMES.contains(attrName)) {
                result = this.getCachedAttributeValue(attrName);
                handled = true;
            }
        }
        if (!handled) {
            result = AMXProxyHandler.isSingleProxyGetter(method, numArgs) ? this.invokeSingleProxyGetter(myProxy, method, args) : (AMXProxyHandler.isProxySetGetter(method, numArgs) ? this.invokeProxySetGetter(myProxy, method, args) : (AMXProxyHandler.isProxyMapGetter(method, numArgs) ? this.invokeProxyMapGetter(myProxy, method, args) : (AMXProxyHandler.isProxyListGetter(method, numArgs) ? this.invokeProxyListGetter(myProxy, method, args) : (AMXProxyHandler.isProxyCreator(method) ? this.invokeProxyCreator(method, args) : super.invoke(myProxy, method, args)))));
        }
        if (this.getDebug()) {
            this.debug((Object)(AMXDebug.methodString(methodName, args) + " => " + AMXProxyHandler.toString(result)));
        }
        return result;
    }

    protected void addNotificationListener(Object[] args) throws IOException, InstanceNotFoundException {
        NotificationListener listener = (NotificationListener)args[0];
        NotificationFilter filter = (NotificationFilter)(args.length <= 1 ? null : args[1]);
        Object handback = args.length <= 1 ? null : args[2];
        this.getConnection().addNotificationListener(this.getTargetObjectName(), listener, filter, handback);
    }

    protected void removeNotificationListener(Object[] args) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener listener = (NotificationListener)args[0];
        if (args.length == 1) {
            this.getConnection().removeNotificationListener(this.getTargetObjectName(), listener);
        } else {
            NotificationFilter filter = (NotificationFilter)args[1];
            Object handback = args[2];
            this.getConnection().removeNotificationListener(this.getTargetObjectName(), listener, filter, handback);
        }
    }
}

