/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.MBeanTrackerMBean;
import org.glassfish.admin.amx.base.Utility;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.AMX_SPI;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.loader.AMXStartupServiceNew;
import org.glassfish.admin.amx.impl.mbean.MBeanImplBase;
import org.glassfish.admin.amx.impl.util.MBeanInfoSupport;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.ThrowableMapper;
import org.glassfish.admin.amx.util.jmx.AttributeChangeNotificationBuilder;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.stringifier.AttributeChangeNotificationStringifier;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXImplBase
extends MBeanImplBase
implements DynamicMBean,
MBeanRegistration,
NotificationEmitter,
AMX_SPI {
    protected static final String GET = "get";
    protected static final String SET = "set";
    private final ObjectName mParent;
    protected volatile MBeanInfo mMBeanInfo;
    private final boolean mEmitAttributeChangeNotifications = true;
    private static final MBeanNotificationInfo[] EMPTY_NOTIFICATIONS = new MBeanNotificationInfo[0];
    protected static final ObjectName[] EMPTY_OBJECT_NAMES = new ObjectName[0];
    private static final Class[] GETTER_SIG = new Class[0];
    protected static final String GET_PREFIX = "get";
    protected static final String OBJECT_NAME_SUFFIX = "ObjectName";

    protected static void cdebug(String s) {
        System.out.println(s);
    }

    public AMXImplBase(ObjectName parentObjectName, Class<? extends AMX_SPI> intf) {
        this(parentObjectName, MBeanInfoSupport.getMBeanInfo(intf));
    }

    public AMXImplBase(ObjectName parentObjectName) {
        this(parentObjectName, (MBeanInfo)null);
    }

    public AMXImplBase(ObjectName parentObjectName, MBeanInfo mbeanInfo) {
        this.mParent = parentObjectName;
        this.mMBeanInfo = mbeanInfo;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    protected final boolean shouldEmitNotifications() {
        return this.getListenerCount() != 0;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return EMPTY_NOTIFICATIONS;
    }

    protected ProxyFactory getProxyFactory() {
        return ProxyFactory.getInstance((MBeanServer)this.getMBeanServer());
    }

    protected <T extends AMXProxy> T getProxy(ObjectName objectName, Class<T> intf) {
        return (T)this.getProxyFactory().getProxy(this.getObjectName(), intf);
    }

    protected final <T extends AMXProxy> T getSelf(Class<T> intf) {
        return (T)this.getProxyFactory().getProxy(this.getObjectName(), intf);
    }

    protected AMXProxy getSelf() {
        return this.getProxyFactory().getProxy(this.getObjectName(), AMXProxy.class);
    }

    public final ObjectName getParent() {
        return this.mParent;
    }

    protected ObjectName getAncestorByType(String type) {
        return Util.getAncestorByType((MBeanServer)this.getMBeanServer(), (ObjectName)this.getObjectName(), (String)type);
    }

    public final AMXProxy getParentProxy() {
        ObjectName parent = this.getParent();
        return parent == null ? null : this.getProxyFactory().getProxy(parent, AMXProxy.class);
    }

    public MBeanTrackerMBean getMBeanTracker() {
        return AMXStartupServiceNew.getMBeanTracker(this.getMBeanServer());
    }

    public ObjectName[] getChildren() {
        Set children = this.getMBeanTracker().getChildrenOf(this.getObjectName());
        if (children == null) {
            return null;
        }
        return (ObjectName[])CollectionUtil.toArray((Collection)children, ObjectName.class);
    }

    public ObjectName[] getChildren(Set<String> types) {
        ObjectName[] children = this.getChildren();
        HashSet<ObjectName> matching = new HashSet<ObjectName>();
        for (ObjectName child : children) {
            if (!types.contains(Util.getTypeProp((ObjectName)child))) continue;
            matching.add(child);
        }
        return (ObjectName[])CollectionUtil.toArray(matching, ObjectName.class);
    }

    public Map<String, ObjectName> getChildrenMap(String type) {
        return Util.filterByType((ObjectName[])this.getChildren(), (String)type);
    }

    protected boolean supportsChildren() {
        return true;
    }

    protected ObjectName child(String type, String name) {
        Map<String, ObjectName> c = this.getChildrenMap(type);
        return c.get(name);
    }

    protected ObjectName child(String type) {
        Collection<ObjectName> c = this.getChildrenMap(type).values();
        int num = c.size();
        if (num > 1) {
            throw new IllegalArgumentException("More than one child of type " + type);
        }
        return num == 0 ? null : c.iterator().next();
    }

    protected ObjectName child(Class<?> intf) {
        String type = Util.deduceType(intf);
        return this.child(type);
    }

    protected static boolean isUtilityMBean(Class mbeanInterface) {
        return Utility.class.isAssignableFrom(mbeanInterface);
    }

    public final Set<String> getAttributeNames() {
        return this.getAttributeInfos().keySet();
    }

    protected final void unimplementedOperation(String operation) {
        String msg = "UNIMPLEMENTED OPERATION: " + operation + " in " + this.getObjectName();
        this.logInfo(msg);
        throw new UnsupportedOperationException(operation);
    }

    protected final Object unimplementedAttribute(String attrName) {
        String msg = "UNIMPLEMENTED ATTRIBUTE: " + attrName + " in " + this.getObjectName();
        this.logInfo(msg);
        return null;
    }

    protected final void impossible(Throwable t) {
        this.logSevere("AMXImplBase.impossible: " + t.getMessage());
        assert (false);
        throw new RuntimeException(t);
    }

    private Object convertToClass(Object value, Class theClass) throws Exception {
        Object result = value;
        if (value instanceof String) {
            result = ClassUtil.InstantiateFromString((Class)theClass, (String)((String)value));
        } else {
            this.getMBeanLogger().info("convertToClass: don't know how to convert: " + value.getClass().getName());
        }
        return result;
    }

    protected Object getAttributeNoThrow(String name) {
        Object result = null;
        try {
            result = this.getAttribute(name);
        }
        catch (Exception e) {
            throw new RuntimeException(new ThrowableMapper((Throwable)e).map());
        }
        return result;
    }

    private boolean getMBeanInfoIsInvariant() {
        return true;
    }

    protected synchronized Map<String, MBeanAttributeInfo> getAttributeInfos() {
        return JMXUtil.attributeInfosToMap((MBeanAttributeInfo[])this.getMBeanInfo().getAttributes());
    }

    protected MBeanAttributeInfo getAttributeInfo(String name) {
        return this.getAttributeInfos().get(name);
    }

    protected boolean isReadOnlyAttribute(String name) {
        MBeanAttributeInfo info = this.getAttributeInfo(name);
        return info == null ? true : !info.isWritable();
    }

    public Logger getLogger() {
        return this.getMBeanLogger();
    }

    @Override
    public final Object getAttribute(String name) throws AttributeNotFoundException {
        Object result = null;
        if (name == null) {
            throw new AttributeNotFoundException("Illegal/unknown attribute: " + name + " for " + this.getObjectName());
        }
        try {
            result = this.getAttributeInternal(name);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeNotFoundException(name);
        }
        return result;
    }

    protected boolean attributeTypeMatches(String attributeName, Class<?> clazz) {
        boolean matches = false;
        MBeanAttributeInfo info = this.getAttributeInfo(attributeName);
        if (info != null && clazz.getName().equals(info.getType())) {
            matches = true;
        }
        return matches;
    }

    protected Object getAttributeInternal(String name) throws AttributeNotFoundException, ReflectionException, MBeanException {
        Object result = null;
        boolean handleManually = false;
        Method m = this.findGetter(name);
        if (m != null) {
            result = this.getAttributeByMethod(name, m);
            this.debug((Object)("getAttribute: " + name + " CALLED GETTER: " + m + " = " + result));
        } else {
            result = this.attributeTypeMatches(name, ObjectName.class) ? this.getObjectNameAttribute(name) : (this.attributeTypeMatches(name, ObjectName[].class) ? this.getObjectNamesForAttribute(name) : this.getAttributeManually(name));
        }
        return result;
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        this.trace("AMXImplBase.getAttributes: " + SmartStringifier.toString((Object)names));
        AttributeList attrs = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            try {
                this.trace("%%% calling getAttribute: " + names[i] + " on " + this.getObjectName());
                Object value = this.getAttribute(names[i]);
                attrs.add(new Attribute(names[i], value));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attrs;
    }

    private final void rethrowAttributeNotFound(Throwable t, String attrName) throws AttributeNotFoundException {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)t);
        if (rootCause instanceof AttributeNotFoundException) {
            throw (AttributeNotFoundException)rootCause;
        }
        String msg = "Attribute not found: " + StringUtil.quote((Object)attrName) + " of MBean " + this.getObjectName() + "[" + rootCause.getMessage() + "]";
        throw new AttributeNotFoundException(msg);
    }

    protected Object getAttributeByMethod(String attrName, Method m) throws AttributeNotFoundException {
        Object result = null;
        try {
            result = m.invoke((Object)this, (Object[])null);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.trace("InvocationTargetException: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(ExceptionUtil.getRootCause((Throwable)e), attrName);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            this.trace("ILLEGAL ACCESS TO: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(ExceptionUtil.getRootCause((Throwable)e), attrName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trace("Exception: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(ExceptionUtil.getRootCause((Throwable)e), attrName);
        }
        return result;
    }

    protected void setAttributeByMethod(Attribute attr, Method m) throws AttributeNotFoundException, InvalidAttributeValueException {
        try {
            m.invoke((Object)this, attr.getValue());
        }
        catch (InvocationTargetException e) {
            this.trace("setAttributeByMethod: InvocationTargetException: " + e);
            Throwable t = ExceptionUtil.getRootCause((Throwable)e);
            if (t instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)t;
            }
            this.rethrowAttributeNotFound(e, attr.getName());
        }
        catch (IllegalAccessException e) {
            this.trace("setAttributeByMethod: IllegalAccessException: " + e);
            this.rethrowAttributeNotFound(e, attr.getName());
        }
        catch (Exception e) {
            this.trace("setAttributeByMethod: Exception: " + e);
            this.rethrowAttributeNotFound(e, attr.getName());
        }
    }

    protected String[] attributeNameToType(String attributeName) {
        return new String[]{attributeName, attributeName.toLowerCase()};
    }

    protected ObjectName[] getObjectNamesForAttribute(String attributeName) {
        String type;
        String[] types = this.attributeNameToType(attributeName);
        ObjectName[] result = null;
        Map<String, ObjectName> children = null;
        String[] arr$ = types;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (children = this.getChildrenMap(type = arr$[i$])).keySet().size() == 0; ++i$) {
        }
        if (children == null || children.keySet().size() == 0) {
            result = EMPTY_OBJECT_NAMES;
        } else {
            result = new ObjectName[children.keySet().size()];
            children.values().toArray(result);
        }
        return result;
    }

    protected ObjectName getObjectNameAttribute(String attributeName) {
        String type;
        String[] types = this.attributeNameToType(attributeName);
        ObjectName result = null;
        String[] arr$ = types;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (result = this.child(type = arr$[i$])) == null; ++i$) {
        }
        return result;
    }

    protected Object getAttributeManually(String attributeName) throws AttributeNotFoundException, ReflectionException, MBeanException {
        throw new AttributeNotFoundException(attributeName);
    }

    protected void setAttributeManually(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        throw new AttributeNotFoundException(attr.getName());
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        String name = attr.getName();
        if (this.isReadOnlyAttribute(name)) {
            throw new IllegalArgumentException("Attribute is read-only: " + attr.getName());
        }
        boolean failure = true;
        try {
            this.setAttributeInternal(attr);
            failure = false;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InvalidAttributeValueException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setAttributeInternal(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, ReflectionException, MBeanException {
        Object oldValue;
        this.trace("setAttribute: " + attr.getName() + " = " + attr.getValue());
        boolean handleManually = false;
        Method m = this.findSetter(attr);
        boolean shouldEmitNotifications = this.shouldEmitNotifications();
        Object object = oldValue = shouldEmitNotifications ? this.getAttribute(attr.getName()) : null;
        if (m != null) {
            this.setAttributeByMethod(attr, m);
        } else {
            this.setAttributeManually(attr);
        }
        if (shouldEmitNotifications) {
            String attrType = this.getAttributeType(attr.getName());
            this.sendAttributeChangeNotification("", attr.getName(), attrType, System.currentTimeMillis(), oldValue, attr.getValue());
        }
    }

    protected final String getAttributeType(String attrName) {
        String amxName = attrName;
        MBeanAttributeInfo info = JMXUtil.getMBeanAttributeInfo((MBeanInfo)this.getMBeanInfo(), (String)amxName);
        if (info == null) {
            this.logWarning("getAttributeType: unknown attribute: " + attrName);
        }
        return info == null ? String.class.getName() : info.getType();
    }

    protected synchronized void sendAttributeChangeNotification(String msg, String name, String attrType, long when, Object oldValue, Object newValue) {
        if (oldValue != null && !oldValue.equals(newValue)) {
            AttributeChangeNotificationBuilder builder = (AttributeChangeNotificationBuilder)this.getNotificationBuilder("jmx.attribute.change");
            AttributeChangeNotification n = builder.buildAttributeChange(msg, name, attrType, when, oldValue, newValue);
            System.out.println("AttributeChangeNotification: " + AttributeChangeNotificationStringifier.DEFAULT.stringify((Object)n));
            this.sendNotification(n);
        }
    }

    private void sendAttributeChangeNotifications(AttributeList attrList, Map<String, Object> oldValues) {
        long when = System.currentTimeMillis();
        Map attrsMap = JMXUtil.attributeListToStringMap((AttributeList)attrList);
        if (!((Object)attrsMap.keySet()).equals(oldValues.keySet())) {
            throw new IllegalArgumentException();
        }
        String msg = "";
        for (String attrName : attrsMap.keySet()) {
            String attrType = this.getAttributeType(attrName);
            Object oldValue = oldValues.get(attrName);
            Object newValue = attrsMap.get(attrName);
            this.sendAttributeChangeNotification("", attrName, attrType, when, oldValue, newValue);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attrs) {
        AttributeList successList = new AttributeList();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            try {
                this.setAttribute(attr);
                successList.add(attr);
                continue;
            }
            catch (Exception e) {
                this.debug((Object)ExceptionUtil.toString((Throwable)e));
            }
        }
        return successList;
    }

    protected final Method findMethod(String methodName, Class[] sig) {
        return ClassUtil.findMethod(this.getClass(), (String)methodName, (Class[])sig);
    }

    protected final Method findGetter(String name) {
        String methodName = "get" + name;
        Method m = this.findMethod(methodName, GETTER_SIG);
        if (m == null) {
            m = this.findMethod("is" + name, GETTER_SIG);
        }
        return m;
    }

    protected final Method findSetter(Attribute attr) {
        Object value = attr.getValue();
        Class valueClass = null;
        if (value == null) {
            MBeanAttributeInfo info = this.getAttributeInfos().get(attr.getName());
            if (info != null) {
                try {
                    valueClass = ClassUtil.getClassFromName((String)info.getType());
                }
                catch (Exception e) {}
            }
        } else {
            valueClass = value.getClass();
        }
        if (valueClass == null) {
            return null;
        }
        String methodName = SET + attr.getName();
        Class[] sig = new Class[]{valueClass};
        Method setter = this.findMethod(methodName, sig);
        Class primitiveClass = ClassUtil.ObjectClassToPrimitiveClass((Class)valueClass);
        if (setter == null && primitiveClass != valueClass) {
            sig[0] = primitiveClass;
            setter = this.findMethod(methodName, sig);
        }
        return setter;
    }

    protected boolean operationNameMatches(String operationName, String prefix, String suffix) {
        return operationName.startsWith(prefix) && operationName.endsWith(suffix);
    }

    protected boolean getterNameMatches(String operationName, String suffix) {
        return this.operationNameMatches(operationName, "get", suffix);
    }

    protected void handleException(Exception e) throws MBeanException, ReflectionException {
        ThrowableMapper mapper = new ThrowableMapper((Throwable)e);
        Throwable mapped = mapper.map();
        if (mapped instanceof ReflectionException) {
            throw (ReflectionException)mapped;
        }
        if (mapped instanceof MBeanException) {
            throw (MBeanException)mapped;
        }
        if (!(mapped instanceof Exception)) {
            Exception wrapper = new Exception(mapped);
            throw new MBeanException(wrapper);
        }
        throw new MBeanException((Exception)mapped);
    }

    protected void handleGetAttributeException(Exception e) throws MBeanException, ReflectionException, AttributeNotFoundException {
        if (e instanceof AttributeNotFoundException) {
            throw (AttributeNotFoundException)e;
        }
        this.handleException(e);
    }

    protected void handleInvokeThrowable(Exception e) throws MBeanException, ReflectionException {
        this.handleException(e);
    }

    @Override
    public final Object invoke(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException {
        Object result = null;
        boolean unimplemented = false;
        int numArgs = args != null ? args.length : 0;
        try {
            Class[] signature = ClassUtil.signatureFromClassnames((String[])types);
            Method m = this.findMethod(operationName, signature);
            if (m != null) {
                this.debugMethod("invoking method: " + operationName, args);
                result = m.invoke((Object)this, args);
            } else {
                result = operationName.equals("toString") && numArgs == 0 ? this.toString() : this.invokeManually(operationName, args, types);
            }
        }
        catch (Exception e) {
            this.debug((Object)ExceptionUtil.toString((Throwable)e));
            this.handleInvokeThrowable(e);
        }
        return result;
    }

    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException, AttributeNotFoundException {
        throw new NoSuchMethodException("no operation " + operationName + AMXImplBase.toString(types) + " in " + this.getObjectName());
    }

    public String getName() {
        String name = Util.getNameProp((ObjectName)this.getObjectName());
        return name == null ? "" : name;
    }

    public String getType() {
        return Util.getTypeProp((ObjectName)this.getObjectName());
    }

    protected ObjectName preRegisterModifyName(MBeanServer server, ObjectName nameIn) {
        return nameIn;
    }

    @Override
    public final synchronized ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        ObjectName nameFromSuper = super.preRegister(server, nameIn);
        this.mSelfObjectName = this.preRegisterModifyName(server, nameFromSuper);
        this.mSelfObjectName = this.preRegisterHook(this.mSelfObjectName);
        this.preRegisterDone();
        return this.mSelfObjectName;
    }

    protected ObjectName preRegisterHook(ObjectName selfObjectName) throws Exception {
        return selfObjectName;
    }

    protected void preRegisterDone() throws Exception {
        this.debug("AMXImplBase.preRegister() done for: ", this.getObjectName());
    }

    protected MBeanInfo postRegisterModifyMBeanInfo(MBeanInfo info) {
        return info;
    }

    @Override
    protected void postRegisterHook(Boolean registrationSucceeded) {
        if (registrationSucceeded.booleanValue()) {
            this.mMBeanInfo = this.postRegisterModifyMBeanInfo(this.mMBeanInfo);
            this.registerChildren();
        }
    }

    protected void registerChildren() {
    }

    @Override
    protected void preDeregisterHook() throws Exception {
        super.preDeregisterHook();
        this.unregisterChildren();
    }

    protected void unregisterChildren() {
        ObjectName[] children;
        for (ObjectName child : children = this.getChildren()) {
            try {
                this.getMBeanServer().unregisterMBean(child);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public final DomainRoot getDomainRootProxy() {
        return this.getProxyFactory().getDomainRootProxy(false);
    }

    public final ObjectName getDomainRoot() {
        return this.getProxyFactory().getDomainRootObjectName();
    }

    protected String stringify(Object o) {
        return SmartStringifier.toString((Object)o);
    }

    public String toString() {
        return this.java();
    }

    public String java() {
        return this.getDomainRootProxy().getTools().java(this.getObjectName());
    }

    protected ObjectName registerChild(Object mbean, ObjectName childObjectName) {
        try {
            ObjectName objectName = this.getMBeanServer().registerMBean(mbean, childObjectName).getObjectName();
            return objectName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ObjectNameBuilder getObjectNames() {
        return new ObjectNameBuilder(this.getMBeanServer(), this.getObjectName());
    }
}

