/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.base;

import com.sun.appserv.management.base.MapCapable;
import com.sun.appserv.management.util.jmx.OpenMBeanUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.ObjectUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapCapableBase
implements MapCapable {
    private Map<String, Serializable> mFields = new HashMap<String, Serializable>();
    private boolean mWasMadeImmutable = false;
    private String mClassName;

    public int hashCode() {
        return ObjectUtil.hashCode(this.mFields, this.mClassName) ^ (this.mWasMadeImmutable ? 1 : 0);
    }

    protected MapCapableBase(String className) {
        this.mClassName = className;
    }

    protected <T extends Serializable> MapCapableBase(Map<String, T> m, String className) {
        this(className);
        this.mClassName = className;
        if (m != null) {
            this.putAll(m);
            this.getFields().remove("MapCapableClassName");
        }
    }

    protected <T extends Serializable> void checkValidType(Map<String, T> m, String requiredType) {
        String type = (String)m.get("MapCapableClassName");
        if (!requiredType.equals(type)) {
            throw new IllegalArgumentException("Illegal MAP_CAPABLE_CLASS_NAME_KEY: " + type);
        }
    }

    protected abstract boolean validate();

    @Override
    public String getMapClassName() {
        return this.mClassName;
    }

    protected void illegalObject(Object o) {
        throw new IllegalArgumentException("Object is of illegal class and/or non-Serializable class " + o.getClass().getName());
    }

    protected void checkInJavaUtil(Object o) {
        if (!o.getClass().getName().startsWith("java.util.")) {
            this.illegalObject(o);
        }
    }

    protected final void checkLegalObject(Object o, boolean allowMapCapable) {
        if (o != null) {
            if (o instanceof Collection) {
                this.checkInJavaUtil(o);
                Collection oc = TypeCast.asCollection(o);
                for (Object next : oc) {
                    this.checkLegalObject(next);
                }
            } else if (o.getClass().getComponentType() != null) {
                Object[] ta = (Object[])o;
                for (int i = 0; i < ta.length; ++i) {
                    this.checkLegalObject(ta[i]);
                }
            } else if (o instanceof MapCapable) {
                if (allowMapCapable) {
                    this.checkLegalObject(((MapCapable)o).asMap());
                } else {
                    this.illegalObject(o);
                }
            } else if (o instanceof Map) {
                this.checkInJavaUtil(o);
                this.checkLegalObject(((Map)o).keySet());
                this.checkLegalObject(((Map)o).values());
            } else if (o instanceof Throwable) {
                String classname = o.getClass().getName();
                if (!classname.startsWith("java.") && !classname.startsWith("javax.")) {
                    this.illegalObject(o);
                }
                this.checkLegalObject(this.asT(((Throwable)o).getCause()));
            } else if (OpenMBeanUtil.getSimpleType(o.getClass()) == null) {
                this.illegalObject(o);
            }
        }
    }

    private Serializable asT(Object o) {
        return (Serializable)Serializable.class.cast(o);
    }

    protected final void checkLegalObject(Object o) {
        this.checkLegalObject(o, true);
    }

    protected boolean validateNullOrOfType(String key, Class<?> theClass) {
        Serializable o = this.getField(key);
        return o == null || theClass.isAssignableFrom(o.getClass());
    }

    protected final void validateThrow() {
        if (!this.validate()) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    protected Serializable asMapHook(String key, Serializable value) {
        Serializable result = value;
        if (result instanceof MapCapable) {
            Map<String, Serializable> m = ((MapCapable)((Object)result)).asMap();
            TypeCast.checkSerializable(m);
            result = (Serializable)Serializable.class.cast(m);
        }
        return result;
    }

    @Override
    public final Map<String, Serializable> asMap() {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        for (String key : this.getFields().keySet()) {
            Serializable value = this.getField(key);
            Serializable s = this.asMapHook(key, value);
            result.put(key, s);
        }
        result.put("MapCapableClassName", (Serializable)((Object)this.getMapClassName()));
        this.checkLegalObject(result, false);
        return result;
    }

    public void makeImmutable() {
        if (!this.mWasMadeImmutable) {
            this.mFields = Collections.unmodifiableMap(this.mFields);
            this.mWasMadeImmutable = true;
        }
    }

    public void putField(String key, Serializable value) {
        this.checkLegalObject(value);
        Serializable newValue = this.putFieldHook(key, value);
        this.getFields().put(key, newValue);
    }

    protected Serializable putFieldHook(String key, Serializable value) {
        return value;
    }

    protected <T extends Serializable> void putAll(Map<String, T> m) {
        if (m != null) {
            for (String key : m.keySet()) {
                this.putField(key, (Serializable)m.get(key));
            }
        }
    }

    private Map<String, Serializable> getFields() {
        return this.mFields;
    }

    protected Serializable getField(String key) {
        return this.getFields().get(key);
    }

    protected final Serializable getObject(String key) {
        return this.getFields().get(key);
    }

    protected final String getString(String key) {
        return (String)((Object)this.getObject(key));
    }

    protected final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    protected final Boolean getBoolean(String key) {
        return (Boolean)this.getObject(key);
    }

    protected final Byte getByte(String key) {
        return (Byte)this.getObject(key);
    }

    protected final boolean getboolean(String key) {
        Boolean b = this.getBoolean(key);
        if (b == null) {
            throw new IllegalArgumentException(key);
        }
        return b;
    }

    protected final Integer getInteger(String key) {
        return (Integer)this.getObject(key);
    }

    protected final Map<String, Serializable> getMap(String key) {
        return TypeCast.asMap(this.getObject(key));
    }

    protected final File getFile(String key) {
        String s = this.getString(key);
        return s == null ? null : new File(s);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapCapableBase)) {
            return false;
        }
        boolean equals = false;
        MapCapableBase rhs = (MapCapableBase)o;
        equals = MapUtil.mapsEqual(this.getFields(), rhs.getFields());
        return equals;
    }

    public String toString() {
        return MapUtil.toString(this.getFields());
    }
}

