/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.ResourceBundleStringSource;
import com.sun.appserv.management.util.misc.StringSource;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageStringSources {
    static final Map<Class<? extends StringSource>, StringSource> mSources = new HashMap<Class<? extends StringSource>, StringSource>();

    public static StringSource get(Class<? extends StringSource> theClass, StringSource delegate) {
        StringSource source = mSources.get(theClass);
        if (source == null) {
            source = PackageStringSources.init(theClass, delegate);
            mSources.put(theClass, source);
        }
        return source;
    }

    private PackageStringSources() {
    }

    private static StringSource init(Class<? extends StringSource> theClass, StringSource delegate) {
        StringSource source = null;
        String packageName = theClass.getPackage().getName();
        try {
            String classname = packageName + ".PackageStrings";
            Class<StringSource> packageStringSourceClass = ClassUtil.getClassFromName(classname).asSubclass(StringSource.class);
            Constructor<StringSource> c = packageStringSourceClass.getConstructor(StringSource.class);
            source = c.newInstance(delegate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (source == null) {
            ResourceBundle bundle = ResourceBundle.getBundle(packageName + ".Strings", Locale.getDefault(), theClass.getClassLoader());
            source = new ResourceBundleStringSource(bundle, delegate);
        }
        return source;
    }
}

