/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.base.AMXAttributes;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NameMapping {
    private final String mJ2EEType;
    private final ConcurrentMap<String, String> mAMXToXML = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> mXMLToAMX = new ConcurrentHashMap<String, String>();

    public NameMapping(String j2eeType) {
        this.mJ2EEType = j2eeType;
    }

    private static void debug(String s) {
        System.out.println(s);
    }

    public String getJ2EEType() {
        return this.mJ2EEType;
    }

    public String getXMLName(String amxName) {
        return this.getXMLName(amxName, false);
    }

    public String getXMLName(String anyName, boolean friendlyMatching) {
        String xmlName = (String)this.mAMXToXML.get(anyName);
        if (xmlName == null && friendlyMatching) {
            xmlName = this.mXMLToAMX.keySet().contains(anyName) ? anyName : this._matchName(anyName, this.mXMLToAMX.keySet());
        }
        return xmlName;
    }

    public String getAMXName(String xmlName) {
        return (String)this.mXMLToAMX.get(xmlName);
    }

    private String _matchName(String anyName, Set<String> xmlCandidates) {
        if (AMXAttributes.AMX_ATTR_NAMES.contains(anyName) && !"Name".equalsIgnoreCase(anyName)) {
            return null;
        }
        String canonical = anyName.toLowerCase();
        String xmlName = null;
        for (String xmlCandidate : xmlCandidates) {
            String temp = xmlCandidate.replace("-", "");
            if (!canonical.equals(xmlCandidate) && !canonical.equals(xmlCandidate.replace("-", ""))) continue;
            xmlName = xmlCandidate;
            break;
        }
        return xmlName;
    }

    public void pairNames(String amxName, String xmlName) {
        this.mAMXToXML.put(amxName, xmlName);
        this.mXMLToAMX.put(xmlName, amxName);
    }

    public String pairNames(String amxName, Set<String> xmlCandidates) {
        String xmlName = this._matchName(amxName, xmlCandidates);
        if (xmlName != null) {
            this.pairNames(amxName, xmlName);
        }
        return xmlName;
    }
}

