/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core.proxy;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.annotation.Stability;
import org.glassfish.admin.amx.annotation.Taxonomy;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.api.amx.AMXLoader;
import org.glassfish.api.amx.AMXValues;

@Taxonomy(stability=Stability.UNCOMMITTED)
public final class AMXBooter {
    public static final ObjectName AMX_BOOTER_OBJECT_NAME = JMXUtil.newObjectName(AMXLoader.AMX3_SUPPORT_DOMAIN + ":name=booter-new");
    public static final String BOOT_AMX_OPERATION_NAME = "bootAMX";

    private AMXBooter() {
    }

    public static ObjectName bootAMX(MBeanServerConnection conn) {
        ObjectName domainRootObjectName = AMXBooter.findDomainRoot(conn);
        if (domainRootObjectName == null) {
            try {
                domainRootObjectName = (ObjectName)conn.invoke(AMX_BOOTER_OBJECT_NAME, BOOT_AMX_OPERATION_NAME, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return domainRootObjectName;
    }

    public static ObjectName findDomainRoot(MBeanServerConnection conn) {
        ObjectName objectName = AMXValues.domainRoot();
        try {
            if (!conn.isRegistered(objectName)) {
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return objectName;
    }
}

