/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.loader;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.MBeanTracker;
import org.glassfish.admin.amx.base.MBeanTrackerMBean;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.AMXBooter;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.loader.Loader;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.SingletonEnforcer;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.TimingDelta;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.mbeanserver.AMXStartupServiceMBean;
import org.glassfish.admin.mbeanserver.BooterNewMBean;
import org.glassfish.api.amx.AMXLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public final class AMXStartupServiceNew
implements PostConstruct,
PreDestroy,
AMXStartupServiceMBean {
    @Inject
    Habitat mHabitat;
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    private volatile ObjectName mAMXLoaderObjectName;
    private volatile MBeanTracker mSupport;
    private static final ObjectName MBEAN_TRACKER_OBJECT_NAME = JMXUtil.newObjectName((String)AMXLoader.AMX3_SUPPORT_DOMAIN, (String)"type=mbean-tracker");
    private static final String AMX_LOADER_DEFAULT_OBJECTNAME = AMXLoader.LOADER_PREFIX + "core";
    private static ObjectName LOADER_OBJECTNAME = null;

    private static void debug(String s) {
        System.out.println(s);
    }

    public static MBeanTrackerMBean getMBeanTracker(MBeanServer server) {
        return MBeanServerInvocationHandler.newProxyInstance(server, MBEAN_TRACKER_OBJECT_NAME, MBeanTrackerMBean.class, false);
    }

    public void postConstruct() {
        TimingDelta delta = new TimingDelta();
        SingletonEnforcer.register(this.getClass(), this);
        if (this.mMBeanServer == null) {
            throw new Error("AMXStartup: null MBeanServer");
        }
        try {
            StandardMBean mbean = new StandardMBean(this, AMXStartupServiceMBean.class);
            this.mMBeanServer.registerMBean(mbean, OBJECT_NAME);
            this.mSupport = new MBeanTracker();
            this.mMBeanServer.registerMBean(this.mSupport, MBEAN_TRACKER_OBJECT_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
        ImplUtil.getLogger().fine("Initialized AMXStartupServiceNew in " + delta.elapsedMillis() + " ms, registered as " + OBJECT_NAME);
    }

    public void preDestroy() {
        ImplUtil.getLogger().info("AMXStartupService.preDestroy(): stopping AMX");
        this.unloadAMXMBeans();
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        try {
            return (JMXServiceURL[])this.mMBeanServer.getAttribute(BooterNewMBean.OBJECT_NAME, "JMXServiceURLs");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public static AMXStartupServiceMBean getAMXStartupServiceMBeanProxy(MBeanServer mbs) {
        AMXStartupServiceMBean ss = null;
        if (mbs.isRegistered(OBJECT_NAME)) {
            ss = (AMXStartupServiceMBean)AMXStartupServiceMBean.class.cast(MBeanServerInvocationHandler.newProxyInstance(mbs, OBJECT_NAME, AMXStartupServiceMBean.class, false));
        }
        return ss;
    }

    public synchronized ObjectName getDomainRoot() {
        try {
            return this.getDomainRootProxy().extra().objectName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRootProxy(false);
    }

    public ObjectName loadAMXMBeans() {
        ObjectName objectName = AMXBooter.findDomainRoot((MBeanServerConnection)this.mMBeanServer);
        if (objectName == null) {
            try {
                objectName = this._loadAMXMBeans();
            }
            catch (Exception e) {
                AMXStartupServiceNew.debug("AMXStartupServiceNew.loadAMXMBeans: " + e);
                throw new RuntimeException(e);
            }
        }
        return objectName;
    }

    public static synchronized ObjectName loadAMX(MBeanServer mbeanServer) {
        if (LOADER_OBJECTNAME == null) {
            boolean inDAS = true;
            Issues.getAMXIssues().notDone("LoadAMX.loadAMX(): determine if this is the DAS");
            Loader loader = new Loader();
            ObjectName tempObjectName = JMXUtil.newObjectName((String)AMX_LOADER_DEFAULT_OBJECTNAME);
            try {
                LOADER_OBJECTNAME = mbeanServer.registerMBean(loader, tempObjectName).getObjectName();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return LOADER_OBJECTNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectName _loadAMXMBeans() {
        this.mAMXLoaderObjectName = AMXStartupServiceNew.loadAMX(this.mMBeanServer);
        FeatureAvailability.getInstance().registerFeature("AMXCoreReady", (Object)this.getDomainRoot());
        ImplUtil.getLogger().info("AMXStartupServiceNew: AMX core MBeans are ready for use, DamainRoot = " + this.getDomainRoot());
        try {
            Collection loaders = this.mHabitat.getAllByContract(AMXLoader.class);
            AMXLoaderThread[] threads = new AMXLoaderThread[loaders.size()];
            int i = 0;
            for (AMXLoader loader : loaders) {
                threads[i] = new AMXLoaderThread(loader);
                threads[i].start();
                ++i;
            }
            for (AMXLoaderThread thread : threads) {
                thread.waitDone();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            FeatureAvailability.getInstance().registerFeature("AMXReady", (Object)this.getDomainRoot());
            ImplUtil.getLogger().info("AMXStartupServiceNew: AMX ready for use, DomainRoot = " + this.getDomainRoot());
        }
        return this.getDomainRoot();
    }

    public synchronized void unloadAMXMBeans() {
        if (this.getDomainRoot() != null) {
            Collection loaders = this.mHabitat.getAllByContract(AMXLoader.class);
            for (AMXLoader loader : loaders) {
                try {
                    loader.unloadAMXMBeans();
                }
                catch (Exception e) {
                    ImplUtil.getLogger().info("AMXLoader failed to unload: " + e);
                }
            }
            ImplUtil.unregisterAMXMBeans((AMXProxy)this.getDomainRootProxy());
        }
    }

    private static final class AMXLoaderThread
    extends Thread {
        private final AMXLoader mLoader;
        private volatile ObjectName mTop;
        private final CountDownLatch mLatch;

        public AMXLoaderThread(AMXLoader loader) {
            this.mLoader = loader;
            this.mLatch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ImplUtil.getLogger().info("AMXStartupServiceNew.AMXLoaderThread: loading: " + this.mLoader.getClass().getName());
                this.mTop = this.mLoader.loadAMXMBeans();
            }
            catch (Exception e) {
                ImplUtil.getLogger().info("AMXStartupServiceNew._loadAMXMBeans: AMXLoader failed to load: " + e);
                e.printStackTrace();
            }
            finally {
                this.mLatch.countDown();
            }
        }

        public ObjectName waitDone() {
            try {
                this.mLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.mTop;
        }

        public ObjectName top() {
            return this.mTop;
        }
    }
}

