/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.loader;

import java.io.File;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.api.amx.AMXValues;

public final class BootUtil {
    private final String mAppserverDomainName;
    private final File mInstanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"));
    private final String mAMX_JMXDomain;
    private static BootUtil INSTANCE = null;
    private final boolean mOfflineAMX;

    private BootUtil(boolean offline) {
        this.mAppserverDomainName = this.mInstanceRoot.getName();
        this.mAMX_JMXDomain = AMXValues.amxJMXDomain();
        this.mOfflineAMX = offline;
    }

    public File getInstanceRoot() {
        return this.mInstanceRoot;
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    public String getServerName() {
        Issues.getAMXIssues().notDone("BootUtil.getServerName()");
        return "server";
    }

    public static synchronized void init(boolean offline) {
        INSTANCE = new BootUtil(offline);
    }

    public boolean getOffline() {
        return this.mOfflineAMX;
    }

    public static synchronized BootUtil getInstance() {
        if (INSTANCE == null) {
            throw new IllegalArgumentException("must call init() first");
        }
        return INSTANCE;
    }

    private ObjectName getObjectName(String props) {
        String domain = this.getAMXSupportJMXDomain();
        return Util.newObjectName((String)domain, (String)props);
    }

    public String getAMXSupportJMXDomain() {
        return this.getAMXJMXDomainName() + "-support";
    }

    public String getAMXJMXDomainName() {
        return this.mAMX_JMXDomain;
    }
}

