/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.logging.Logging;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.FileUtils;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.ThrowableMapper;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.NotificationBuilder;
import org.glassfish.api.amx.AMXValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggingImpl
extends AMXImplBase {
    private final Map<Level, String> mLevelToNotificationTypeMap;
    private final Map<String, NotificationBuilder> mNotificationTypeToNotificationBuilderMap;
    private static final String SERVER_LOG_NAME = "server.log";
    private static final String ACCESS_LOG_NAME = "access.log";
    final String FILE_SEP;
    private final String mServerName;
    private static MBeanNotificationInfo[] SELF_NOTIFICATION_INFOS = null;
    private static final Integer INTEGER_0 = 0;
    private static final Map<String, Integer> EMPTY_ERROR_DISTRIBUTION_MAP = Collections.emptyMap();
    private static final Set<String> LEGAL_DISTRIBUTION_LEVELS = SetUtil.newUnmodifiableStringSet((String[])new String[]{Level.SEVERE.toString(), Level.WARNING.toString()});
    private static final Object[] LEVELS_AND_NOTIF_TYPES = new Object[]{Level.SEVERE, Logging.LOG_RECORD_SEVERE_NOTIFICATION_TYPE, Level.WARNING, Logging.LOG_RECORD_WARNING_NOTIFICATION_TYPE, Level.INFO, Logging.LOG_RECORD_INFO_NOTIFICATION_TYPE, Level.CONFIG, Logging.LOG_RECORD_CONFIG_NOTIFICATION_TYPE, Level.FINE, Logging.LOG_RECORD_FINE_NOTIFICATION_TYPE, Level.FINER, Logging.LOG_RECORD_FINER_NOTIFICATION_TYPE, Level.FINEST, Logging.LOG_RECORD_FINEST_NOTIFICATION_TYPE};
    private long mMyThreadID = -1L;

    public static ObjectName getObjectName(String serverName) {
        String requiredProps = Util.makeRequiredProps((String)Util.deduceType(Logging.class), (String)serverName);
        String ServerRootMonitorType = "ServerRootMonitor";
        String parentProp = Util.makeProp((String)"ServerRootMonitor", (String)serverName);
        String props = Util.concatenateProps((String)requiredProps, (String)parentProp);
        return Util.newObjectName((String)AMXValues.amxJMXDomain(), (String)props);
    }

    public LoggingImpl(ObjectName parent, String serverName) {
        super(parent, Logging.class);
        this.mServerName = serverName;
        this.FILE_SEP = System.getProperty("file.separator");
        this.mLevelToNotificationTypeMap = LoggingImpl.initLevelToNotificationTypeMap();
        this.mNotificationTypeToNotificationBuilderMap = new HashMap<String, NotificationBuilder>();
    }

    @Override
    protected MBeanInfo postRegisterModifyMBeanInfo(MBeanInfo info) {
        MBeanOperationInfo[] ops = info.getOperations();
        int idx = JMXUtil.findMBeanOperationInfo((MBeanInfo)info, (String)"queryServerLog", null);
        MBeanOperationInfo op = ops[idx];
        ops[idx] = new MBeanOperationInfo(op.getName(), op.getDescription(), op.getSignature(), Map.class.getName(), 0);
        return JMXUtil.newMBeanInfo((MBeanInfo)info, (MBeanOperationInfo[])ops);
    }

    private static synchronized MBeanNotificationInfo[] getSelfNotificationInfos() {
        if (SELF_NOTIFICATION_INFOS == null) {
            String[] types = SetUtil.toStringArray((Set)Logging.ALL_LOG_RECORD_NOTIFICATION_TYPES);
            MBeanNotificationInfo selfInfo = new MBeanNotificationInfo(types, Notification.class.getName(), "LogRecord notifications");
            SELF_NOTIFICATION_INFOS = new MBeanNotificationInfo[]{selfInfo};
        }
        return SELF_NOTIFICATION_INFOS;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] superInfos = super.getNotificationInfo();
        MBeanNotificationInfo[] all = JMXUtil.mergeMBeanNotificationInfos((MBeanNotificationInfo[])superInfos, (MBeanNotificationInfo[])LoggingImpl.getSelfNotificationInfos());
        return all;
    }

    private void unimplemented() {
        throw new RuntimeException("Not implemented.");
    }

    public void setModuleLogLevel(String module, String level) {
        this.unimplemented();
        this.getLogMBean().setLogLevel(module, level);
    }

    public String getModuleLogLevel(String module) {
        this.unimplemented();
        return this.getLogMBean().getLogLevel(module);
    }

    public int getLogLevelListenerCount(Level logLevel) {
        String notifType = this.logLevelToNotificationType(logLevel);
        int count = this.getNotificationEmitter().getNotificationTypeListenerCount(notifType);
        return count;
    }

    public String[] getLogFileKeys() {
        this.unimplemented();
        return new String[]{"server", "access"};
    }

    public synchronized String[] getLogFileNames(String key) {
        String[] result = null;
        if (!"server".equals(key)) {
            throw new IllegalArgumentException(key);
        }
        this.unimplemented();
        result = this.getLogMBean().getArchivedLogfiles();
        return result;
    }

    public synchronized String getLogFile(String key, String fileName) {
        this.unimplemented();
        if (!"server".equals(key)) {
            throw new IllegalArgumentException("" + key);
        }
        String dir = this.getLogMBean().getLogFilesDirectory();
        String file = dir + this.FILE_SEP + fileName;
        try {
            return FileUtils.fileToString((File)new File(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void rotateAllLogFiles() {
        this.unimplemented();
        this.getLogMBean().rotateNow();
    }

    public synchronized void rotateLogFile(String key) {
        this.unimplemented();
        if ("access".equals(key)) {
            throw new IllegalArgumentException("not supported: " + key);
        }
        if (!"server".equals(key)) {
            throw new IllegalArgumentException("" + key);
        }
        this.unimplemented();
    }

    private Properties attributesToProps(List<Attribute> attrs) {
        Properties props = new Properties();
        if (attrs != null) {
            for (Attribute attr : attrs) {
                Object value = attr.getValue();
                if (value == null) {
                    throw new IllegalArgumentException(attr.getName() + "=" + null);
                }
                props.put(attr.getName(), value.toString());
            }
        }
        return props;
    }

    private List<Serializable[]> convertQueryResult(AttributeList queryResult) {
        AttributeList fieldAttrs = (AttributeList)((Attribute)queryResult.get(0)).getValue();
        String[] fieldHeaders = new String[fieldAttrs.size()];
        for (int i = 0; i < fieldHeaders.length; ++i) {
            Attribute attr = (Attribute)fieldAttrs.get(i);
            fieldHeaders[i] = (String)attr.getValue();
        }
        List srcRecords = TypeCast.asList((Object)((Attribute)queryResult.get(1)).getValue());
        ArrayList<Serializable[]> results = new ArrayList<Serializable[]>(srcRecords.size());
        results.add((Serializable[])fieldHeaders);
        for (int recordIdx = 0; recordIdx < srcRecords.size(); ++recordIdx) {
            List record = (List)srcRecords.get(recordIdx);
            assert (record.size() == fieldHeaders.length);
            Serializable[] fieldValues = new Serializable[fieldHeaders.length];
            for (int fieldIdx = 0; fieldIdx < fieldValues.length; ++fieldIdx) {
                fieldValues[fieldIdx] = (Serializable)record.get(fieldIdx);
            }
            results.add(fieldValues);
        }
        return results;
    }

    public List<Serializable[]> queryServerLog(String name, long startIndex, boolean searchForward, int maximumNumberOfResults, Long fromTime, Long toTime, String logLevel, Set<String> modules, List<Attribute> nameValuePairs) {
        List<Serializable[]> result = this.queryServerLogInternal(name, startIndex, searchForward, maximumNumberOfResults, fromTime, toTime, logLevel, modules, nameValuePairs);
        return result;
    }

    private List<Serializable[]> queryServerLogInternal(String name, long startIndex, boolean searchForward, int maximumNumberOfResults, Long fromTime, Long toTime, String logLevel, Set<String> modules, List<Attribute> nameValuePairs) {
        this.unimplemented();
        if (name == null) {
            throw new IllegalArgumentException("use MOST_RECENT_NAME, not null");
        }
        boolean sortAscending = true;
        List moduleList = ListUtil.newListFromCollection(modules);
        Properties props = this.attributesToProps(nameValuePairs);
        String actualName = "MostRecentLogFileName".equals(name) ? null : name;
        AttributeList result = this.getLogMBean().getLogRecordsUsingQuery(actualName, startIndex, searchForward, true, maximumNumberOfResults, fromTime == null ? null : new Date(fromTime), toTime == null ? null : new Date(toTime), logLevel, true, moduleList, props);
        return this.convertQueryResult(result);
    }

    public Map<String, Number>[] getErrorInfo() {
        this.unimplemented();
        List<Map<String, Object>> infos = this.getLogMBean().getErrorInformation();
        Map[] results = (Map[])TypeCast.asArray((Object)new HashMap[infos.size()]);
        for (int i = 0; i < results.length; ++i) {
            Map<String, Object> info = infos.get(i);
            assert (info.keySet().size() == 3);
            Long timestamp = Long.parseLong(info.get("TimeStamp").toString());
            Integer severeCount = Integer.parseInt(info.get("SevereCount").toString());
            Integer warningCount = Integer.parseInt(info.get("WarningCount").toString());
            HashMap<String, Number> item = new HashMap<String, Number>(info.size());
            item.put("TimeStamp", timestamp);
            item.put("SevereCount", severeCount);
            item.put("WarningCount", warningCount);
            results[i] = item;
        }
        return results;
    }

    public Map<String, Integer> getErrorDistribution(long timestamp, String level) {
        if (!LEGAL_DISTRIBUTION_LEVELS.contains(level)) {
            throw new IllegalArgumentException(level);
        }
        this.unimplemented();
        Map<String, Integer> result = this.getLogMBean().getErrorDistribution(timestamp, Level.parse(level));
        if (result != null) {
            Set<String> moduleIDs = result.keySet();
            for (String moduleID : moduleIDs) {
                if (result.get(moduleID) != null) continue;
                result.put(moduleID, INTEGER_0);
            }
        } else {
            result = EMPTY_ERROR_DISTRIBUTION_MAP;
        }
        return result;
    }

    public void setKeepErrorStatisticsForIntervals(int num) {
        this.unimplemented();
        this.getLogMBean().setKeepErrorStatisticsForIntervals(num);
    }

    public int getKeepErrorStatisticsForIntervals() {
        return 0;
    }

    public void setErrorStatisticsIntervalMinutes(long minutes) {
        this.unimplemented();
        this.getLogMBean().setErrorStatisticsIntervalDuration(minutes);
    }

    public long getErrorStatisticsIntervalMinutes() {
        return 0L;
    }

    public String[] getLoggerNames() {
        return EMPTY_STRING_ARRAY;
    }

    public String[] getLoggerNamesUnder(String loggerName) {
        this.unimplemented();
        List names = TypeCast.checkList((List)this.getLogMBean().getLoggerNamesUnder(loggerName), String.class);
        return names.toArray(EMPTY_STRING_ARRAY);
    }

    public String[] getDiagnosticCauses(String messageID) {
        this.unimplemented();
        List causes = TypeCast.checkList((List)this.getLogMBean().getDiagnosticCausesForMessageId(messageID), String.class);
        String[] result = null;
        if (causes != null) {
            result = causes.toArray(new String[causes.size()]);
        }
        return result;
    }

    public String[] getDiagnosticChecks(String messageID) {
        this.unimplemented();
        List checks = TypeCast.checkList((List)this.getLogMBean().getDiagnosticChecksForMessageId(messageID), String.class);
        String[] result = null;
        if (checks != null) {
            result = new String[checks.size()];
            checks.toArray(result);
        }
        return result;
    }

    public String getDiagnosticURI(String messageID) {
        this.unimplemented();
        return this.getLogMBean().getDiagnosticURIForMessageId(messageID);
    }

    private static Map<Level, String> initLevelToNotificationTypeMap() {
        HashMap<Level, String> m = new HashMap<Level, String>();
        for (int i = 0; i < LEVELS_AND_NOTIF_TYPES.length; i += 2) {
            Level level = (Level)LEVELS_AND_NOTIF_TYPES[i];
            String notifType = (String)LEVELS_AND_NOTIF_TYPES[i + 1];
            m.put(level, notifType);
        }
        return Collections.unmodifiableMap(m);
    }

    private String logLevelToNotificationType(Level level) {
        String notificationType = this.mLevelToNotificationTypeMap.get(level);
        if (notificationType == null) {
            // empty if block
        }
        return notificationType;
    }

    @Override
    protected void preRegisterDone() throws Exception {
        this.initNotificationTypeToNotificationBuilderMap(this.getObjectName());
    }

    private void initNotificationTypeToNotificationBuilderMap(ObjectName objectName) {
        this.mNotificationTypeToNotificationBuilderMap.clear();
        for (String notifType : Logging.ALL_LOG_RECORD_NOTIFICATION_TYPES) {
            this.mNotificationTypeToNotificationBuilderMap.put(notifType, new NotificationBuilder(notifType, (Object)objectName));
        }
    }

    private NotificationBuilder notificationTypeToNotificationBuilder(String notificationType) {
        NotificationBuilder builder = this.mNotificationTypeToNotificationBuilderMap.get(notificationType);
        assert (builder != null);
        return builder;
    }

    private Map<String, Serializable> logRecordToMap(LogRecord record, String recordAsString) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("LogRecord.toString", (Serializable)((Object)recordAsString));
        m.put("LogRecord.Level", record.getLevel());
        m.put("LogRecord.LoggerName", (Serializable)((Object)record.getLoggerName()));
        m.put("LogRecord.Message", (Serializable)((Object)record.getMessage()));
        m.put("LogRecord.Millis", Long.valueOf(record.getMillis()));
        m.put("LogRecord.SequenceNumber", Long.valueOf(record.getSequenceNumber()));
        m.put("LogRecord.SourceClassName", (Serializable)((Object)record.getSourceClassName()));
        m.put("LogRecord.SourceMethodName", (Serializable)((Object)record.getSourceMethodName()));
        m.put("LogRecord.ThreadID", Integer.valueOf(record.getThreadID()));
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            Throwable mapped = new ThrowableMapper(thrown).map();
            m.put("LogRecord.Thrown", mapped);
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)thrown);
            if (rootCause != thrown) {
                Throwable mappedRootCause = new ThrowableMapper(rootCause).map();
                m.put("LogRecord.ThrownRootCause", mappedRootCause);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void privateLoggingHook(LogRecord logRecord, Formatter formatter) {
        if ((long)logRecord.getThreadID() == this.mMyThreadID) {
            this.debug((Object)"privateLoggingHook: recusive call!!!");
            throw new RuntimeException("recursive call");
        }
        LoggingImpl loggingImpl = this;
        synchronized (loggingImpl) {
            this.mMyThreadID = Thread.currentThread().getId();
            Level level = logRecord.getLevel();
            try {
                if (this.getLogLevelListenerCount(level) != 0) {
                    String notifType = this.logLevelToNotificationType(level);
                    NotificationBuilder builder = this.notificationTypeToNotificationBuilder(notifType);
                    String logRecordAsString = formatter.format(logRecord);
                    Map<String, Serializable> userData = this.logRecordToMap(logRecord, logRecordAsString);
                    Notification notif = builder.buildNewWithMap(logRecordAsString, userData);
                    this.debug((Object)("privateLoggingHook: sending: " + notif));
                    this.sendNotification(notif);
                }
            }
            finally {
                this.mMyThreadID = -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmitLogMessage(String level, String message) {
        String saveLevel = this.getMBeanLogLevel();
        this.setMBeanLogLevel(level);
        try {
            this.debug((Object)("testEmitLogMessage: logging: message = " + message));
            this.getLogger().log(Level.parse(level), message);
        }
        finally {
            this.setMBeanLogLevel(saveLevel);
        }
    }

    private LogMBeanIntf getLogMBean() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface LogMBeanIntf
    extends NotificationEmitter {
        public List getLoggerNames();

        public List getLoggerNamesUnder(String var1);

        public String getLogLevel(String var1);

        public void setLogLevel(String var1, String var2);

        public void setLogLevelForModule(String var1, String var2);

        public AttributeList getLogRecordsUsingQuery(String var1, Long var2, Boolean var3, Boolean var4, Integer var5, Date var6, Date var7, String var8, Boolean var9, List var10, Properties var11);

        public String[] getArchivedLogfiles();

        public void rotateNow();

        public void rotateAccessLog();

        public String getLogFilesDirectory();

        public ArrayList getDiagnosticCausesForMessageId(String var1);

        public ArrayList getDiagnosticChecksForMessageId(String var1);

        public String getDiagnosticURIForMessageId(String var1);

        public List<Map<String, Object>> getErrorInformation();

        public Map<String, Integer> getErrorDistribution(long var1, Level var3);

        public void setKeepErrorStatisticsForIntervals(int var1);

        public int getKeepErrorStatisticsForIntervals();

        public void setErrorStatisticsIntervalDuration(long var1);

        public long getErrorStatisticsIntervalDuration();
    }
}

