/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.DescriptorSupport;
import org.glassfish.admin.amx.annotation.Stability;
import org.glassfish.admin.amx.annotation.Taxonomy;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.config.AMXConfigLoader;
import org.glassfish.admin.amx.impl.config.AttributeResolverHelper;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupport;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupportRegistry;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.MBeanInfoSupport;
import org.glassfish.admin.amx.impl.util.SingletonEnforcer;
import org.glassfish.admin.amx.impl.util.UnregistrationListener;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
public class AMXConfigImpl
extends AMXImplBase {
    private final ConfigBean mConfigBean;
    private static MBeanInfo configMBeanInfo;
    private static final ConcurrentMap<Class<? extends ConfigBeanProxy>, MBeanInfo> mInfos;

    private static synchronized MBeanInfo getAMXConfigMBeanInfo() {
        if (configMBeanInfo == null) {
            configMBeanInfo = MBeanInfoSupport.getMBeanInfo(AMXConfigProxy.class);
        }
        return configMBeanInfo;
    }

    private static MBeanInfo createMBeanInfo(ConfigBean cb) {
        Class intf = cb.getProxyType();
        MBeanInfo newInfo = (MBeanInfo)mInfos.get(intf);
        if (newInfo != null) {
            return newInfo;
        }
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        MBeanInfo info = spt.getMBeanInfo();
        List attrInfos = ListUtil.newListFromArray((Object[])info.getAttributes());
        MBeanInfo spiInfo = MBeanInfoSupport.getAMX_SPIMBeanInfo();
        List spiAttrInfos = ListUtil.newListFromArray((Object[])spiInfo.getAttributes());
        if (spt.isLeaf()) {
            JMXUtil.remove((List)spiAttrInfos, (String)"Children");
        }
        for (MBeanAttributeInfo attrInfo : spiAttrInfos) {
            String attrName = attrInfo.getName();
            MBeanAttributeInfo priorAttrInfo = (MBeanAttributeInfo)JMXUtil.remove((List)attrInfos, (String)attrName);
            if (attrName.equals("Name") && priorAttrInfo != null) {
                DescriptorSupport mergedD = JMXUtil.mergeDescriptors((Descriptor)attrInfo.getDescriptor(), (Descriptor)priorAttrInfo.getDescriptor());
                MBeanAttributeInfo newAttrInfo = new MBeanAttributeInfo(attrName, attrInfo.getType(), attrInfo.getDescription(), attrInfo.isReadable(), attrInfo.isWritable(), attrInfo.isIs(), mergedD);
                attrInfos.add(newAttrInfo);
                continue;
            }
            attrInfos.add(attrInfo);
        }
        List operationInfos = ListUtil.newListFromArray((Object[])info.getOperations());
        operationInfos.addAll(ListUtil.newListFromArray((Object[])AMXConfigImpl.getAMXConfigMBeanInfo().getOperations()));
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attrInfos.size()];
        attrInfos.toArray(attrs);
        MBeanOperationInfo[] operations = new MBeanOperationInfo[operationInfos.size()];
        operationInfos.toArray(operations);
        newInfo = new MBeanInfo(info.getClassName(), info.getDescription(), attrs, info.getConstructors(), operations, info.getNotifications(), info.getDescriptor());
        mInfos.putIfAbsent(intf, newInfo);
        return newInfo;
    }

    public AMXConfigImpl(ObjectName parentObjectName, ConfigBean configBean) {
        this(parentObjectName, AMXConfigProxy.class, configBean);
    }

    public AMXConfigImpl(ObjectName parentObjectName, Class<? extends AMXProxy> theInterface, ConfigBean configBean) {
        super(parentObjectName, AMXConfigImpl.createMBeanInfo(configBean));
        this.mConfigBean = configBean;
        this.getConfigBeanJMXSupport();
    }

    protected void setAttributeManually(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        AttributeList attrList = new AttributeList();
        attrList.add(attr);
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        AttributeList successList = this.setAttributesInConfigBean(attrList, oldValues);
        if (successList.size() == 0) {
            throw new AttributeNotFoundException(attr.getName());
        }
    }

    public AttributeList setAttributes(AttributeList attrs) {
        AttributeList successList = new AttributeList();
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        AttributeList delegateSuccess = this.setAttributesInConfigBean(attrs, oldValues);
        successList.addAll(delegateSuccess);
        return successList;
    }

    public String getName() {
        ConfigBean cb = this.getConfigBean();
        String name = AMXConfigLoader.getName(cb);
        return name == null ? "" : name;
    }

    private final ConfigBean getConfigBean() {
        return this.mConfigBean;
    }

    private final ConfigBeanProxy getConfigBeanProxy() {
        return this.getConfigBean().getProxy(this.getConfigBean().getProxyType());
    }

    public String resolveAttributeValue(String varString) {
        if (!AttributeResolverHelper.needsResolving(varString)) {
            return varString;
        }
        return new AttributeResolverHelper((AMXConfigProxy)this.getSelf(AMXConfigProxy.class)).resolve(varString);
    }

    public String resolveAttribute(String attrName) {
        try {
            Object value = this.getAttribute(attrName);
            return this.resolveAttributeValue(value == null ? null : "" + value);
        }
        catch (AttributeNotFoundException e) {
            System.out.println("resolveAttribute: Attribute not found: " + attrName + " on " + this.getObjectName());
            return null;
        }
    }

    public Boolean resolveBoolean(String attrName) {
        return Boolean.parseBoolean(this.resolveAttribute(attrName));
    }

    public Integer resolveInteger(String attrName) {
        return Integer.parseInt(this.resolveAttribute(attrName));
    }

    public Long resolveLong(String attrName) {
        return Long.parseLong(this.resolveAttribute(attrName));
    }

    public AttributeList resolveAttributes(String[] attrNames) {
        Issues.getAMXIssues().notDone("resolveAttributes: use annotations to create the correct type");
        AttributeList attrs = this.getAttributes(attrNames);
        AttributeList resolvedAttrs = new AttributeList();
        for (Object o : attrs) {
            Attribute r = (Attribute)o;
            Object value = r.getValue();
            if (value instanceof String && AttributeResolverHelper.needsResolving((String)value)) {
                String resolvedValue = this.resolveAttributeValue((String)value);
                r = new Attribute(r.getName(), resolvedValue);
            }
            resolvedAttrs.add(r);
        }
        return resolvedAttrs;
    }

    private static void toAttributeChanges(Map<String, Object> values, List<ConfigSupport.AttributeChanges> changes, Map<String, Map<String, Object>> subs) {
        if (values != null) {
            for (String nameAsProvided : values.keySet()) {
                Object value = values.get(nameAsProvided);
                String xmlName = ConfigBeanJMXSupport.toXMLName(nameAsProvided);
                if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) {
                    String valueString = value == null ? null : "" + value;
                    ConfigSupport.SingleAttributeChange change = new ConfigSupport.SingleAttributeChange(xmlName, valueString);
                    changes.add((ConfigSupport.AttributeChanges)change);
                    continue;
                }
                if (value instanceof Map) {
                    Map m = TypeCast.checkMap((Map)((Map)Map.class.cast(value)), String.class, Object.class);
                    subs.put(xmlName, m);
                    continue;
                }
                if (value instanceof String[]) {
                    changes.add((ConfigSupport.AttributeChanges)new ConfigSupport.MultipleAttributeChanges(xmlName, (String[])value));
                    continue;
                }
                throw new IllegalArgumentException("Value of class " + value.getClass().getName() + " not supported for attribute " + nameAsProvided);
            }
        }
    }

    private ObjectName finishCreate(Class<? extends ConfigBeanProxy> elementClass, List<ConfigSupport.AttributeChanges> changes, Map<String, Map<String, Object>> subs) throws ClassNotFoundException, TransactionFailure {
        if (subs.keySet().size() != 0) {
            AMXConfigImpl.cdebug((String)("Sub-elements to create: " + CollectionUtil.toString(subs.keySet(), (String)", ")));
        }
        ConfigBean newConfigBean = null;
        SubElementsCallback callback = new SubElementsCallback(subs);
        try {
            newConfigBean = ConfigSupport.createAndSet((ConfigBean)this.getConfigBean(), elementClass, changes, (ConfigSupport.TransactionCallBack)callback);
        }
        catch (Throwable t) {
            AMXConfigImpl.cdebug((String)ExceptionUtil.toString((Throwable)t));
            throw new RuntimeException(t);
        }
        AMXConfigLoader amxLoader = (AMXConfigLoader)SingletonEnforcer.get(AMXConfigLoader.class);
        amxLoader.handleConfigBean(newConfigBean, true);
        ObjectName objectName = ConfigBeanRegistry.getInstance().getObjectName(newConfigBean);
        return objectName;
    }

    public ObjectName createChild(String type, Map<String, Object> params) {
        Class<? extends ConfigBeanProxy> intf = this.getConfigBeanProxyClassForContainedType(type);
        if (intf == null) {
            throw new IllegalArgumentException("ConfigBean of type " + this.getConfigBean().getProxyType() + " does not support sub-element of type " + type);
        }
        try {
            return this.createChild(intf, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private static Map<String, Object> paramsToMap(Object[] params) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (int i = 0; i < params.length; i += 2) {
            String name = (String)params[i];
            Object value = params[i + 1];
            if (value == null || value instanceof String) {
                m.put(name, value);
                continue;
            }
            if (value instanceof Object[]) {
                m.put(name, AMXConfigImpl.paramsToMap((Object[])value));
                continue;
            }
            m.put(name, value);
        }
        return m;
    }

    public ObjectName createChild(String type, Object[] params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        return this.createChild(type, AMXConfigImpl.paramsToMap(params));
    }

    private ObjectName createChild(Class<? extends ConfigBeanProxy> intf, Map<String, Object> paramsIn) throws ClassNotFoundException, TransactionFailure {
        String xmlKeyName;
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(intf);
        HashMap<String, Object> params = new HashMap<String, Object>(paramsIn);
        if (params.containsKey("Name") && (xmlKeyName = spt.getNameHint()) != null) {
            Object value = params.remove("Name");
            params.put(xmlKeyName, value);
        }
        if (!spt.isSingleton()) {
            if (params == null) {
                throw new IllegalArgumentException("Named element requires at least its name");
            }
            Set<String> requiredAttrs = spt.requiredAttributeNames();
            for (String reqName : requiredAttrs) {
                String xmlName = ConfigBeanJMXSupport.toXMLName(reqName);
                if (params.containsKey(reqName) || params.containsKey(xmlName)) continue;
                throw new IllegalArgumentException("Required attribute missing: " + reqName);
            }
        }
        ArrayList<ConfigSupport.AttributeChanges> changes = new ArrayList<ConfigSupport.AttributeChanges>();
        HashMap<String, Map<String, Object>> subs = new HashMap<String, Map<String, Object>>();
        AMXConfigImpl.toAttributeChanges(params, changes, subs);
        return this.finishCreate(intf, changes, subs);
    }

    public void removeChild(String type) {
        ObjectName child = this.child(type);
        if (child == null) {
            throw new RuntimeException(new InstanceNotFoundException("No MBean of type " + type + " found."));
        }
        this.remove(child);
    }

    public void removeChild(String type, String name) {
        ObjectName child = this.child(type, name);
        if (child == null) {
            throw new RuntimeException(new InstanceNotFoundException("No MBean named " + name + " of type " + type + " found."));
        }
        this.remove(child);
    }

    private final void remove(ObjectName childObjectName) {
        try {
            ConfigBean childConfigBean = ConfigBeanRegistry.getInstance().getConfigBean(childObjectName);
            try {
                AMXConfigImpl.cdebug((String)("REMOVING config of class " + childConfigBean.getProxyType().getName() + " from  parent of type " + this.getConfigBean().getProxyType().getName() + ", ObjectName = " + JMXUtil.toString((ObjectName)childObjectName)));
                ConfigSupport.deleteChild((ConfigBean)this.getConfigBean(), (ConfigBean)childConfigBean);
            }
            catch (TransactionFailure tf) {
                throw new RuntimeException("Transaction failure deleting " + JMXUtil.toString((ObjectName)childObjectName), tf);
            }
            UnregistrationListener myListener = new UnregistrationListener((MBeanServerConnection)this.getMBeanServer(), childObjectName);
            long TIMEOUT_MILLIS = 10000L;
            boolean unregisteredOK = myListener.waitForUnregister(10000L);
            if (!unregisteredOK) {
                throw new RuntimeException("Something went wrong unregistering MBean " + JMXUtil.toString((ObjectName)childObjectName));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem deleting " + childObjectName, e);
        }
    }

    private Object invokeDuckMethod(ConfigBeanJMXSupport.DuckTypedInfo info, Object[] args) throws MBeanException {
        try {
            if (!info.method().getDeclaringClass().isAssignableFrom(this.getConfigBeanProxy().getClass())) {
                throw new IllegalArgumentException("invokeDuckMethod: " + this.getConfigBean().getProxyType() + " not asssignable to " + info.method().getDeclaringClass());
            }
            Object result = info.method().invoke((Object)this.getConfigBeanProxy(), args);
            result = this.translateResult(result);
            return result;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private ObjectName getObjectName(ConfigBeanProxy cbp) {
        Dom dom = Dom.unwrap((ConfigBeanProxy)cbp);
        if (dom instanceof ConfigBean) {
            return ConfigBeanRegistry.getInstance().getObjectName((ConfigBean)dom);
        }
        return null;
    }

    private Object translateResult(Object result) {
        Class<?> componentType;
        if (result instanceof String) {
            return result;
        }
        Object out = result;
        if (result instanceof ConfigBeanProxy) {
            out = this.getObjectName((ConfigBeanProxy)result);
        } else if (result instanceof Collection) {
            Collection c = (Collection)((Object)result);
            ArrayList<Object> translated = new ArrayList<Object>();
            for (Object item : c) {
                translated.add(this.translateResult(item));
            }
            out = result instanceof Set ? new HashSet(translated) : (result instanceof AbstractQueue ? new LinkedBlockingDeque(translated) : translated);
        } else if (result instanceof Map) {
            Map resultMap = result;
            HashMap<Object, Object> outMap = new HashMap<Object, Object>();
            for (Object key : resultMap.keySet()) {
                outMap.put(this.translateResult(key), this.translateResult(resultMap.get(key)));
            }
            out = outMap;
        } else if (result.getClass().isArray() && ConfigBeanProxy.class.isAssignableFrom(componentType = result.getClass().getComponentType())) {
            Object[] items = (Object[])result;
            ObjectName[] objectNames = new ObjectName[items.length];
            for (int i = 0; i < items.length; ++i) {
                objectNames[i] = this.getObjectName((ConfigBeanProxy)items[i]);
            }
            out = objectNames;
        }
        return out;
    }

    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException, AttributeNotFoundException {
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        this.debugMethod(operationName, args);
        ConfigBeanJMXSupport.DuckTypedInfo duckTypedInfo = null;
        ConfigBeanJMXSupport spt = this.getConfigBeanJMXSupport();
        duckTypedInfo = this.getConfigBeanJMXSupport().findDuckTyped(operationName, types);
        result = duckTypedInfo != null ? this.invokeDuckMethod(duckTypedInfo, args) : super.invokeManually(operationName, args, types);
        return result;
    }

    public void sendConfigCreatedNotification(ObjectName configObjectName) {
        this.sendNotification("org.glassfish.admin.amx.intf.ConfigCreated", "org.glassfish.admin.amx.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    public void sendConfigRemovedNotification(ObjectName configObjectName) {
        this.sendNotification("org.glassfish.admin.amx.config.ConfigRemoved", "org.glassfish.admin.amx.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    private final ConfigBeanJMXSupport getConfigBeanJMXSupport() {
        return ConfigBeanJMXSupportRegistry.getInstance(this.getConfigBean());
    }

    private static final Map<String, String> getDefaultValues(Class<? extends ConfigBeanProxy> intf, boolean useAMXAttributeNames) {
        return ConfigBeanJMXSupportRegistry.getInstance(intf).getDefaultValues(useAMXAttributeNames);
    }

    public final Map<String, String> getDefaultValues(String type, boolean useAMXAttributeNames) {
        Class<? extends ConfigBeanProxy> intf = this.getConfigBeanProxyClassForContainedType(type);
        return AMXConfigImpl.getDefaultValues(intf, useAMXAttributeNames);
    }

    public final Map<String, String> getDefaultValues(boolean useAMXAttributeNames) {
        return AMXConfigImpl.getDefaultValues(this.mConfigBean.getProxyType(), useAMXAttributeNames);
    }

    private Class<? extends ConfigBeanProxy> getConfigBeanProxyClassForContainedType(String type) {
        ConfigBeanJMXSupport spt = this.getConfigBeanJMXSupport();
        if (spt == null) {
            throw new IllegalArgumentException("Can't find ConfigBean @Configured class for AMX type " + type);
        }
        return ConfigBeanJMXSupportRegistry.getConfigBeanProxyClassFor(spt, type);
    }

    protected String[] attributeNameToType(String attributeName) {
        return new String[]{Util.typeFromName((String)attributeName), attributeName};
    }

    protected Object getAttributeManually(String name) throws AttributeNotFoundException, ReflectionException, MBeanException {
        return this.getAttributeFromConfigBean(name);
    }

    protected final Object getAttributeFromConfigBean(String amxName) {
        Object[] result = null;
        MBeanAttributeInfo attrInfo = this.getAttributeInfo(amxName);
        if (attrInfo == null) {
            ConfigBeanJMXSupport.DuckTypedInfo info = this.getConfigBeanJMXSupport().findDuckTyped("get" + amxName, null);
            if (info == null) {
                info = this.getConfigBeanJMXSupport().findDuckTyped("is" + amxName, null);
            }
            if (info != null) {
                try {
                    result = this.invokeDuckMethod(info, null);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(new MBeanException(e, amxName));
                }
            }
            throw new RuntimeException(new AttributeNotFoundException(amxName));
        }
        String xmlName = ConfigBeanJMXSupport.xmlName(attrInfo, amxName);
        boolean isAttribute = ConfigBeanJMXSupport.isAttribute(attrInfo);
        if (isAttribute) {
            result = this.mConfigBean.rawAttribute(xmlName);
        } else if (ConfigBeanJMXSupport.isElement(attrInfo)) {
            if (String.class.getName().equals(attrInfo.getType())) {
                List leaf = this.mConfigBean.leafElements(xmlName);
                if (leaf != null) {
                    try {
                        result = (String)leaf.get(0);
                    }
                    catch (Exception e) {}
                }
            } else if (attrInfo.getType() == String[].class.getName()) {
                List leaf = this.mConfigBean.leafElements(xmlName);
                if (leaf != null) {
                    List elems = TypeCast.checkList((List)leaf, String.class);
                    result = CollectionUtil.toArray((Collection)elems, String.class);
                }
            } else {
                throw new IllegalArgumentException("getAttributeFromConfigBean: unsupported return type: " + attrInfo.getType());
            }
        }
        return result;
    }

    private Map<String, PropertyChangeEvent> makePropertyChangeEventMap(List<PropertyChangeEvent> changeEvents) {
        HashMap<String, PropertyChangeEvent> m = new HashMap<String, PropertyChangeEvent>();
        for (PropertyChangeEvent changeEvent : changeEvents) {
            if (changeEvent.getPropertyName() == null) {
                throw new IllegalArgumentException("PropertyChangeEvent property names must be specified");
            }
            m.put(changeEvent.getPropertyName(), changeEvent);
        }
        return m;
    }

    private void joinTransaction(Transaction t, WriteableView writeable) throws TransactionFailure {
        if (!writeable.join(t)) {
            t.rollback();
            throw new TransactionFailure("Cannot enlist " + writeable.getProxyType() + " in transaction", null);
        }
    }

    private static void commit(Transaction t) throws TransactionFailure {
        try {
            t.commit();
        }
        catch (RetryableException e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), (Throwable)e);
        }
        catch (TransactionFailure e) {
            AMXConfigImpl.cdebug((String)"failure, not retryable...");
            t.rollback();
            throw e;
        }
    }

    static <T extends ConfigBeanProxy> WriteableView getWriteableView(T s, ConfigBean sourceBean) throws TransactionFailure {
        WriteableView f = new WriteableView(s);
        if (sourceBean.getLock().tryLock()) {
            return f;
        }
        throw new TransactionFailure("Config bean already locked " + sourceBean, null);
    }

    private static Type getCollectionGenericType() {
        try {
            return ConfigSupport.class.getDeclaredMethod("defaultPropertyValue", null).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException();
        }
    }

    private List<String> handleCollection(WriteableView writeable, ConfigModel.Property prop, String cmd, List<String> argValues) {
        Object o = writeable.getter(prop, AMXConfigImpl.getCollectionGenericType());
        List masterList = TypeCast.checkList((List)TypeCast.asList((Object)o), String.class);
        if (cmd.equals("replace")) {
            masterList.retainAll(argValues);
            for (String s : argValues) {
                if (masterList.contains(s)) continue;
                masterList.add(s);
            }
        } else if (cmd.equals("remove")) {
            masterList.removeAll(argValues);
        } else if (cmd.equals("add")) {
            ArrayList<String> temp = new ArrayList<String>(argValues);
            temp.removeAll(masterList);
            masterList.addAll(temp);
        } else {
            throw new IllegalArgumentException(cmd);
        }
        return new ArrayList<String>(masterList);
    }

    protected ConfigModel.Property getConfigModel_Property(String xmlName) {
        ConfigModel.Property cmp = this.mConfigBean.model.findIgnoreCase(xmlName);
        if (cmp == null) {
            throw new IllegalArgumentException("Illegal name: " + xmlName);
        }
        return cmp;
    }

    private Map<String, Object> mapNamesAndValues(Map<String, Object> amxAttrs, Map<String, Object> noMatch) {
        HashMap<String, Object> xmlAttrs = new HashMap<String, Object>();
        Map attrInfos = this.getAttributeInfos();
        for (String amxAttrName : amxAttrs.keySet()) {
            Object valueIn = amxAttrs.get(amxAttrName);
            MBeanAttributeInfo attrInfo = (MBeanAttributeInfo)attrInfos.get(amxAttrName);
            if (attrInfo == null) {
                this.debug("WARNING: setAttributes(): no MBeanAttributeInfo found for: " + amxAttrName);
                noMatch.put(amxAttrName, valueIn);
                continue;
            }
            String xmlName = ConfigBeanJMXSupport.xmlName(attrInfo, amxAttrName);
            if (xmlName != null) {
                Object value = valueIn;
                if (valueIn == null || value instanceof String) {
                    xmlAttrs.put(xmlName, (String)value);
                    continue;
                }
                ConfigModel.Property prop = this.getConfigModel_Property(xmlName);
                if (prop != null && prop.isCollection()) {
                    if (valueIn instanceof String[] || valueIn instanceof List) {
                        xmlAttrs.put(xmlName, ListUtil.asStringList((Object)valueIn));
                        continue;
                    }
                    noMatch.put(amxAttrName, valueIn);
                    continue;
                }
                noMatch.put(amxAttrName, valueIn);
                continue;
            }
            this.debug("WARNING: setAttributes(): no xmlName match found for AMX attribute: " + amxAttrName);
            noMatch.put(amxAttrName, valueIn);
        }
        return xmlAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributesInConfigBean(AttributeList attrsIn, Map<String, Object> oldValues) {
        oldValues.clear();
        Map amxAttrs = JMXUtil.attributeListToValueMap((AttributeList)attrsIn);
        HashMap<String, Object> notMatched = new HashMap<String, Object>();
        Map<String, Object> xmlAttrs = this.mapNamesAndValues(amxAttrs, notMatched);
        if (notMatched.keySet().size() != 0) {
            AMXConfigImpl.cdebug((String)("setAttributes: failed to map these AMX attributes: {" + CollectionUtil.toString(notMatched.keySet(), (String)", ") + "}"));
        }
        AttributeList successfulAttrs = new AttributeList();
        Transactions transactions = (Transactions)this.mConfigBean.getHabitat().getComponent(Transactions.class);
        if (xmlAttrs.size() != 0) {
            MyTransactionListener myListener = new MyTransactionListener(this.mConfigBean);
            transactions.addTransactionsListener((TransactionListener)myListener);
            try {
                MakeChangesApplyer mca = new MakeChangesApplyer(this.mConfigBean, xmlAttrs);
                mca.apply();
                successfulAttrs.addAll(attrsIn);
            }
            catch (TransactionFailure tf) {
                AMXConfigImpl.cdebug((String)ExceptionUtil.toString((Throwable)tf));
            }
            finally {
                transactions.waitForDrain();
                transactions.removeTransactionsListener((TransactionListener)myListener);
            }
        }
        return successfulAttrs;
    }

    static {
        mInfos = new ConcurrentHashMap<Class<? extends ConfigBeanProxy>, MBeanInfo>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MakeChangesApplyer
    extends Applyer {
        private final Map<String, Object> mChanges;

        public MakeChangesApplyer(ConfigBean cb, Map<String, Object> changes) throws TransactionFailure {
            super(cb);
            this.mChanges = changes;
        }

        @Override
        protected void makeChanges() throws TransactionFailure {
            for (String xmlName : this.mChanges.keySet()) {
                Object value = this.mChanges.get(xmlName);
                ConfigModel.Property prop = AMXConfigImpl.this.getConfigModel_Property(xmlName);
                if (prop.isCollection()) {
                    List results = AMXConfigImpl.this.handleCollection(this.mWriteable, prop, "replace", ListUtil.asStringList((Object)value));
                    continue;
                }
                if (value == null || value instanceof String) {
                    this.mWriteable.setter(prop, value, String.class);
                    continue;
                }
                throw new TransactionFailure("Illegal data type for attribute " + xmlName + ": " + value.getClass().getName());
            }
        }
    }

    private final class ModifyCollectionApplyer
    extends Applyer {
        private volatile List<String> mResult;
        private final String mElementName;
        private final String mCmd;
        private final String[] mValues;

        public ModifyCollectionApplyer(ConfigBean cb, String elementName, String cmd, String[] values) throws TransactionFailure {
            super(cb);
            this.mElementName = elementName;
            this.mCmd = cmd;
            this.mValues = values;
            this.mResult = null;
        }

        protected void makeChanges() throws TransactionFailure {
            ConfigModel.Property prop = AMXConfigImpl.this.getConfigModel_Property(this.mElementName);
            this.mResult = AMXConfigImpl.this.handleCollection(this.mWriteable, prop, this.mCmd, ListUtil.asStringList((Object)this.mValues));
        }
    }

    private class Applyer {
        final Transaction mTransaction;
        final ConfigBean mConfigBean;
        final WriteableView mWriteable;

        public Applyer(ConfigBean cb) throws TransactionFailure {
            this(cb, new Transaction());
        }

        public Applyer(ConfigBean cb, Transaction t) throws TransactionFailure {
            this.mConfigBean = cb;
            this.mTransaction = t;
            ConfigBeanProxy readableView = cb.getProxy(cb.getProxyType());
            this.mWriteable = AMXConfigImpl.getWriteableView(readableView, cb);
        }

        protected void makeChanges() throws TransactionFailure {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void apply() throws TransactionFailure {
            try {
                AMXConfigImpl.this.joinTransaction(this.mTransaction, this.mWriteable);
                this.makeChanges();
                AMXConfigImpl.commit(this.mTransaction);
            }
            finally {
                this.mConfigBean.getLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyTransactionListener
    implements TransactionListener {
        private final List<PropertyChangeEvent> mChangeEvents = new ArrayList<PropertyChangeEvent>();
        private final ConfigBean mTarget;

        MyTransactionListener(ConfigBean target) {
            this.mTarget = target;
        }

        public void transactionCommited(List<PropertyChangeEvent> changes) {
            for (PropertyChangeEvent event : changes) {
                Dom dom;
                Object source = event.getSource();
                if (!(source instanceof ConfigBeanProxy) || !((dom = Dom.unwrap((ConfigBeanProxy)((ConfigBeanProxy)source))) instanceof ConfigBean) || this.mTarget != (ConfigBean)dom) continue;
                this.mChangeEvents.add(event);
            }
        }

        public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
        }

        List<PropertyChangeEvent> getChangeEvents() {
            return this.mChangeEvents;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SubElementsCallback
    implements ConfigSupport.TransactionCallBack<WriteableView> {
        private final Map<String, Map<String, Object>> mSubs;

        public SubElementsCallback(Map<String, Map<String, Object>> subs) {
            this.mSubs = subs;
        }

        public void performOn(WriteableView item) throws TransactionFailure {
            ConfigBeanJMXSupport sptRoot = ConfigBeanJMXSupportRegistry.getInstance(Domain.class);
            ConfigSupport configSupport = (ConfigSupport)AMXConfigImpl.this.mConfigBean.getHabitat().getComponent(ConfigSupport.class);
            this.recursiveCreate(item, sptRoot, configSupport, this.mSubs);
        }

        private void recursiveCreate(WriteableView parent, ConfigBeanJMXSupport sptRoot, ConfigSupport configSupport, Map<String, Map<String, Object>> subs) throws TransactionFailure {
            for (String type : subs.keySet()) {
                Class<? extends ConfigBeanProxy> clazz = ConfigBeanJMXSupportRegistry.getConfigBeanProxyClassFor(sptRoot, type);
                ConfigBeanProxy childProxy = parent.allocateProxy(clazz);
                ConfigBean child = (ConfigBean)Dom.unwrap((ConfigBeanProxy)childProxy);
                WriteableView childW = (WriteableView)WriteableView.class.cast(Proxy.getInvocationHandler(Proxy.class.cast(childProxy)));
                AMXConfigImpl.cdebug((String)("Created sub-element of type: " + type + ", " + clazz));
                Map<String, Object> attrs = subs.get(type);
                if (attrs == null) {
                    throw new IllegalArgumentException("Null attributes Map for type " + type);
                }
                Map moreSubs = MapUtil.newMap();
                for (String attrName : attrs.keySet()) {
                    Object attrValue = attrs.get(attrName);
                    if (attrValue instanceof Map) {
                        AMXConfigImpl.cdebug((String)("Found sub-element " + attrName + " for " + type + " with Map " + attrValue));
                        moreSubs.put(attrName, Map.class.cast(attrValue));
                        continue;
                    }
                    ConfigModel.Property modelProp = child.model.findIgnoreCase(Dom.convertName((String)attrName));
                    if (modelProp == null) {
                        throw new IllegalArgumentException("Can't find ConfigModel.Property for attr " + attrName + " on " + type);
                    }
                    AMXConfigImpl.cdebug((String)("setting attribute \"" + attrName + "\" to \"" + attrValue + "\" on " + type));
                    childW.setter(modelProp, attrValue, String.class);
                    AMXConfigImpl.cdebug((String)("set attribute \"" + attrName + "\" to \"" + attrValue + "\" on " + type));
                }
                if (moreSubs.keySet().size() == 0) continue;
                this.recursiveCreate(childW, sptRoot, configSupport, moreSubs);
            }
        }
    }
}

