/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.intf.config;

import org.glassfish.admin.amx.annotation.Stability;
import org.glassfish.admin.amx.annotation.Taxonomy;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.Application;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.Resource;
import org.glassfish.admin.amx.intf.config.Resources;

@Taxonomy(stability=Stability.UNCOMMITTED)
public final class AMXConfigUtil {
    private AMXConfigUtil() {
    }

    public static Domain getDomainConfig(AMXProxy amx) {
        DomainRoot domainRoot = amx.extra().proxyFactory().getDomainRootProxy(false);
        return (Domain)domainRoot.child(Domain.class);
    }

    public static Resource getResourceByName(AMXProxy any, String name) {
        Domain domainConfig = AMXConfigUtil.getDomainConfig(any);
        if (domainConfig == null) {
            throw new IllegalArgumentException("NULL DOMAIN CONFIG");
        }
        Resources resources = domainConfig.getResources();
        Resource resourceConfig = null;
        for (AMXProxy child : resources.childrenSet()) {
            if (!child.getName().equals(name)) continue;
            resourceConfig = (Resource)child.as(Resource.class);
            break;
        }
        return resourceConfig;
    }

    public static Application getApplicationByName(AMXProxy any, String name) {
        Domain domainConfig = AMXConfigUtil.getDomainConfig(any);
        Application appConfig = (Application)domainConfig.getApplications().childrenMap(Application.class).get(name);
        if (appConfig == null) {
            appConfig = (Application)domainConfig.getSystemApplications().childrenMap(Application.class).get(name);
        }
        return appConfig;
    }
}

