/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.Query;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.RegexUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.ObjectNameQueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMgrImpl
extends AMXImplBase {
    public QueryMgrImpl(ObjectName parentObjectName) {
        super(parentObjectName, Query.class);
    }

    public ObjectName[] queryProps(String props) {
        return this.queryPattern(Util.newObjectNamePattern((String)this.getJMXDomain(), (String)props));
    }

    public ObjectName[] queryTypes(Set<String> types) throws IOException {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (ObjectName objectName : this.queryAll()) {
            if (!types.contains(Util.getTypeProp((ObjectName)objectName))) continue;
            result.add(objectName);
        }
        return this.asArray(result);
    }

    public ObjectName[] queryType(String type) {
        return this.queryProps(Util.makeTypeProp((String)type));
    }

    public ObjectName[] queryName(String name) {
        return this.queryProps(Util.makeNameProp((String)name));
    }

    public ObjectName[] queryPattern(ObjectName pattern) {
        return this.asArray(JMXUtil.queryNames((MBeanServer)this.getMBeanServer(), (ObjectName)pattern, null));
    }

    public ObjectName[] queryTypeName(String type, String name) {
        return this.queryProps(Util.makeRequiredProps((String)type, (String)name));
    }

    private static String[] convertToRegex(String[] wildExprs) {
        String[] regexExprs = null;
        if (wildExprs != null) {
            regexExprs = new String[wildExprs.length];
            for (int i = 0; i < wildExprs.length; ++i) {
                String regex;
                String expr = wildExprs[i];
                regexExprs[i] = regex = expr == null ? null : RegexUtil.wildcardToJavaRegex((String)expr);
            }
        }
        return regexExprs;
    }

    private Set<ObjectName> matchWild(Set<ObjectName> candidates, String[] wildKeys, String[] wildValues) {
        String[] regexNames = QueryMgrImpl.convertToRegex(wildKeys);
        String[] regexValues = QueryMgrImpl.convertToRegex(wildValues);
        ObjectNameQueryImpl query = new ObjectNameQueryImpl();
        Set resultSet = query.matchAll(candidates, regexNames, regexValues);
        return resultSet;
    }

    public ObjectName[] queryWildAll(String[] wildKeys, String[] wildValues) {
        Object[] candidates = this.queryAll();
        Set candidatesSet = SetUtil.newSet((Object[])candidates);
        return this.asArray(this.matchWild(candidatesSet, wildKeys, wildValues));
    }

    public ObjectName[] queryAll() {
        ObjectName pat = Util.newObjectNamePattern((String)this.getJMXDomain(), (String)"");
        Set names = JMXUtil.queryNames((MBeanServer)this.getMBeanServer(), (ObjectName)pat, null);
        return this.asArray(names);
    }

    private final ObjectName[] asArray(Set<ObjectName> items) {
        return (ObjectName[])CollectionUtil.toArray(items, ObjectName.class);
    }
}

