/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.Sample;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public final class SampleImpl
extends AMXImplBase {
    private final Map<String, Serializable> mAttributes = Collections.synchronizedMap(new HashMap());
    private MBeanInfo mExtendedMBeanInfo = null;
    private static final int MEGABYTE = 0x100000;

    public void emitNotifications(Serializable data, int numNotifs, long interval) {
        if (numNotifs <= 0) {
            throw new IllegalArgumentException("" + numNotifs);
        }
        new EmitterThread(data, numNotifs, interval).start();
    }

    public SampleImpl(ObjectName parentObjectName) {
        super(parentObjectName, Sample.class);
    }

    public void addAttribute(String name, Serializable value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.mAttributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.mAttributes.remove(name);
        this.mExtendedMBeanInfo = null;
    }

    public boolean getMBeanInfoIsInvariant() {
        return false;
    }

    private synchronized MBeanInfo createMBeanInfo(MBeanInfo baseMBeanInfo) {
        MBeanAttributeInfo[] dynamicAttrInfos = new MBeanAttributeInfo[this.mAttributes.keySet().size()];
        int i = 0;
        for (String name : this.mAttributes.keySet()) {
            Serializable value = this.mAttributes.get(name);
            String type = value == null ? String.class.getName() : value.getClass().getName();
            dynamicAttrInfos[i] = new MBeanAttributeInfo(name, type, "dynamically-added Attribute", true, true, false);
            ++i;
        }
        MBeanAttributeInfo[] attrInfos = JMXUtil.mergeMBeanAttributeInfos((MBeanAttributeInfo[])dynamicAttrInfos, (MBeanAttributeInfo[])baseMBeanInfo.getAttributes());
        return JMXUtil.newMBeanInfo((MBeanInfo)baseMBeanInfo, (MBeanAttributeInfo[])attrInfos);
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mExtendedMBeanInfo == null) {
            this.mExtendedMBeanInfo = this.createMBeanInfo(super.getMBeanInfo());
        }
        return this.mExtendedMBeanInfo;
    }

    protected Serializable getAttributeManually(String name) {
        return this.mAttributes.get(name);
    }

    protected void setAttributeManually(Attribute attr) {
        this.mAttributes.put(attr.getName(), (Serializable)Serializable.class.cast(attr.getValue()));
    }

    public void uploadBytes(byte[] bytes) {
    }

    public byte[] downloadBytes(int numBytes) {
        if (numBytes < 0 || numBytes > 0xA00000) {
            throw new IllegalArgumentException("Illegal count: " + numBytes);
        }
        byte[] bytes = new byte[numBytes];
        return bytes;
    }

    public ObjectName[] getAllAMX() {
        List all = Util.toObjectNames((Collection)this.getDomainRootProxy().getQueryMgr().queryAll());
        return (ObjectName[])CollectionUtil.toArray((Collection)all, ObjectName.class);
    }

    private final class EmitterThread
    extends Thread {
        private final Serializable mData;
        private final int mNumNotifs;
        private final long mIntervalMillis;

        public EmitterThread(Serializable data, int numNotifs, long intervalMillis) {
            this.mData = data;
            this.mNumNotifs = numNotifs;
            this.mIntervalMillis = intervalMillis;
        }

        public void run() {
            for (int i = 0; i < this.mNumNotifs; ++i) {
                SampleImpl.this.sendNotification("Sample", "UserData", this.mData);
                try {
                    Thread.sleep(this.mIntervalMillis);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

