/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.util;

import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.server.ServerEnvironmentImpl;

public final class ImplUtil {
    private static void debug(String s) {
        System.out.println(s);
    }

    public static Logger getLogger() {
        return LogDomains.getLogger(ServerEnvironmentImpl.class, (String)"javax.enterprise.system.tools.admin");
    }

    public static void unregisterAMXMBeans(AMXProxy top) {
        if (top == null) {
            throw new IllegalArgumentException();
        }
        MBeanServer mbeanServer = (MBeanServer)top.extra().mbeanServerConnection();
        Set children = top.extra().childrenSet();
        if (children != null) {
            for (AMXProxy amx : children) {
                ImplUtil.unregisterAMXMBeans(amx);
            }
        }
        ImplUtil.unregisterOneMBean(mbeanServer, Util.getObjectName((AMXProxy)top));
    }

    public static void unregisterAMXMBeans(MBeanServer mbs, ObjectName objectName) {
        ImplUtil.unregisterAMXMBeans(ProxyFactory.getInstance((MBeanServer)mbs).getProxy(objectName, AMXProxy.class));
    }

    public static boolean unregisterOneMBean(MBeanServer mbeanServer, ObjectName objectName) {
        boolean success = false;
        try {
            mbeanServer.unregisterMBean(objectName);
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }
}

