/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.embedded.tasks;

import java.io.File;
import java.io.IOException;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.Server;

public class Util {
    public static Server getServer(String serverID, String installRoot, String instanceRoot, String configFile, Boolean autoDelete) throws IOException {
        Server server = Server.getServer((String)serverID);
        if (server != null) {
            return server;
        }
        Server.Builder builder = new Server.Builder(serverID);
        EmbeddedFileSystem efs = Util.getFileSystem(installRoot, instanceRoot, configFile, autoDelete);
        server = builder.embeddedFileSystem(efs).build();
        return server;
    }

    public static EmbeddedFileSystem getFileSystem(String installRoot, String instanceRoot, String configFile, Boolean autoDelete) {
        EmbeddedFileSystem.Builder efsb = new EmbeddedFileSystem.Builder();
        if (installRoot != null) {
            efsb.installRoot(new File(installRoot), true);
        }
        if (instanceRoot != null) {
            System.setProperty("com.sun.aas.instanceRootURI", "file:" + instanceRoot);
            efsb.instanceRoot(new File(instanceRoot));
        }
        if (configFile != null) {
            efsb.configurationFile(new File(configFile));
        }
        if (autoDelete != null) {
            efsb.autoDelete(autoDelete.booleanValue());
        }
        return efsb.build();
    }

    public static void createPort(Server server, String configFile, int port) throws IOException {
        if (configFile == null && port == -1) {
            server.createPort(8080);
        } else if (port != -1) {
            server.createPort(port);
        }
    }
}

