/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.embedded.tasks;

import com.sun.enterprise.admin.cli.ArgumentTokenizer;
import com.sun.enterprise.admin.cli.Parser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.glassfish.ant.embedded.tasks.TaskBase;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.embedded.Server;

public class AdminTask
extends TaskBase {
    String serverID = "EmbeddedServer";
    String command;
    String commandLine;
    CommandProperty commandProperty;
    List<CommandProperty> commandProperties = new ArrayList<CommandProperty>();

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setCommandLine(String cmdLine) {
        this.commandLine = cmdLine;
    }

    public CommandProperty createCommandProperty() {
        this.commandProperty = new CommandProperty();
        this.commandProperties.add(this.commandProperty);
        return this.commandProperty;
    }

    public CommandProperty createCommandProperty(String name, String value) {
        CommandProperty property = new CommandProperty();
        property.setName(name);
        return property;
    }

    private ParameterMap getCommandParameters() {
        ParameterMap params = new ParameterMap();
        for (CommandProperty property : this.commandProperties) {
            params.set((Object)property.getName(), (Object)property.getValue());
        }
        return params;
    }

    public void execute() throws BuildException {
        if (this.command == null && this.commandLine == null) {
            this.error("Either command or commandLine should be specified");
            return;
        }
        Server server = Server.getServer((String)this.serverID);
        if (server == null) {
            this.error("Embedded Server [" + this.serverID + "] not running");
            return;
        }
        CommandRunner runner = (CommandRunner)server.getHabitat().getComponent(CommandRunner.class);
        ActionReport report = (ActionReport)server.getHabitat().getComponent(ActionReport.class);
        if (this.commandLine != null) {
            try {
                this.log("executing admin task[serverID=" + this.serverID + "] : " + this.commandLine);
                String[] args = this.getArgs(this.commandLine);
                if (args.length == 0) {
                    this.error("admin command not specified");
                    return;
                }
                if (args[0].equalsIgnoreCase("set") && args.length > 1) {
                    this.commandLine = args[0] + " --values = " + this.commandLine.substring(args[0].length() + 1);
                    args = this.getArgs(this.commandLine);
                }
                Parser parser = new Parser(args, 1, null, true);
                ParameterMap pMap = parser.getOptions();
                pMap.set((Object)"DEFAULT", (Collection)parser.getOperands());
                runner.getCommandInvocation(args[0], report).parameters(pMap).execute();
                if (report.hasFailures()) {
                    throw new Exception(report.getMessage());
                }
                if (report.hasWarnings()) {
                    System.out.println(report.getMessage());
                }
                System.out.println("executed : " + this.commandLine);
            }
            catch (Exception ex) {
                this.error(ex);
            }
        } else {
            this.log("executing admin command: " + this.command + " serverID = " + this.serverID);
            runner.getCommandInvocation(this.command, report).parameters(this.getCommandParameters()).execute();
        }
        this.log("admin task executed");
    }

    private String[] getArgs(String line) throws ArgumentTokenizer.ArgumentException {
        ArrayList<String> args = new ArrayList<String>();
        ArgumentTokenizer t = new ArgumentTokenizer(line);
        while (t.hasMoreTokens()) {
            args.add(t.nextToken());
        }
        return args.toArray(new String[args.size()]);
    }

    public class CommandProperty {
        String name;
        String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

