/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AdminTask
extends Task {
    String installDir;
    String command;
    String commandStr;

    public AdminTask() {
        this.setCommand("");
    }

    public void setTarget(String target) {
        this.optionIgnored("target");
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void addCommandParameter(String name, String value) {
        this.command = this.command + " --" + name + "=" + value;
    }

    public void addCommandOperand(String value) {
        this.command = this.command + " " + value;
    }

    public void setUser(String user) {
        this.addCommandParameter("user", user);
    }

    public void setPasswordFile(String passwordfile) {
        this.addCommandParameter("passwordfile", passwordfile);
    }

    public void setHost(String host) {
        this.addCommandParameter("host", host);
    }

    public void setPort(String port) {
        this.addCommandParameter("port", port);
    }

    public String getInstallDir() {
        String home;
        if (this.installDir == null && (home = this.getProject().getProperty("asinstall.dir")) != null) {
            return home;
        }
        return this.installDir;
    }

    public void execute() throws BuildException {
        this.execute(this.command);
    }

    public void execute(String commandExec) throws BuildException {
        this.log("Running command " + commandExec);
        String installDirectory = this.getInstallDir();
        if (installDirectory == null) {
            this.log("Install Directory of application server not known. Sepcify either the installDir attribute or the asinstall.dir property", 1);
            return;
        }
        File f = new File(installDirectory);
        if (!f.exists()) {
            this.log("Glassfish install directory : " + installDirectory + " not found. Specify the correct directory as installDir attribute or asinstall.dir property");
            return;
        }
        try {
            File asadmin = this.getAsAdmin(f);
            Process pr = Runtime.getRuntime().exec(asadmin.getAbsolutePath() + " " + commandExec);
            BufferedReader error = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            String errorLine = null;
            while ((errorLine = error.readLine()) != null) {
                this.log(errorLine);
            }
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String inputLine = null;
            while ((inputLine = input.readLine()) != null) {
                this.log(inputLine);
            }
            int exitVal = pr.waitFor();
            if (exitVal != 0) {
                this.log("asadmin command exited with error code " + exitVal);
            }
        }
        catch (Exception ex) {
            this.log(ex.getMessage());
        }
    }

    void optionIgnored(String option) {
        this.log("Option Ignored : " + option);
    }

    private File getAsAdmin(File installDir) {
        String osName = System.getProperty("os.name");
        File binDir = new File(installDir, "bin");
        if (osName.indexOf("Windows") == -1) {
            return new File(binDir, "asadmin");
        }
        return new File(binDir, "asadmin.bat");
    }
}

