/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.embedded.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.ScatteredArchive;
import org.glassfish.api.embedded.Server;

public class DeployScatteredTask
extends Task {
    protected int port;
    protected String name;
    protected String rootdirectory;
    protected String resources;
    protected String contextroot;
    protected ArrayList<String> classpath = new ArrayList();
    protected HashMap<String, File> metadata = new HashMap();
    String serverID = "EmbeddedServer";
    DeployCommandParameters cmdParams = new DeployCommandParameters();

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public void setRootDirectory(String rootdirectory) {
        this.rootdirectory = rootdirectory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContextroot(String contextroot) {
        this.contextroot = contextroot;
    }

    public void setWebxml(String path) {
        this.metadata.put("web.xml", new File(path));
    }

    public void setSunWebxml(String path) {
        this.metadata.put("sun-web.xml", new File(path));
    }

    public void setResourcesDirectory(String path) {
        this.resources = path;
    }

    public void setClasspath(String[] classpathArray) {
        for (int i = 0; i < classpathArray.length; ++i) {
            this.classpath.add(classpathArray[i]);
        }
    }

    public void execute() throws BuildException {
        this.log("deploying " + this.rootdirectory);
        try {
            File f = new File(this.rootdirectory);
            ScatteredArchive.Builder builder = new ScatteredArchive.Builder(this.name, f);
            this.log("rootdir = " + f);
            if (this.resources == null) {
                this.resources = this.rootdirectory;
            }
            builder.resources(new File(this.resources));
            if (this.classpath.isEmpty()) {
                this.classpath.add(this.rootdirectory);
            }
            for (String string : this.classpath) {
                builder.addClassPath(new File(string).toURL());
            }
            for (Map.Entry entry : this.metadata.entrySet()) {
                String key = (String)entry.getKey();
                File value = (File)entry.getValue();
                builder.addMetadata(key, value);
            }
            Server server = Server.getServer((String)this.serverID);
            EmbeddedDeployer embeddedDeployer = server.getDeployer();
            DeployCommandParameters dp = new DeployCommandParameters(f);
            dp.name = this.name;
            dp.contextroot = this.contextroot == null ? this.name : this.contextroot;
            embeddedDeployer.deploy((ReadableArchive)builder.buildWar(), dp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

