/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.tasks;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.glassfish.ant.tasks.AdminTask;
import org.glassfish.ant.tasks.Component;

public class UndeployTask
extends AdminTask {
    private String action = "undeploy";
    private String name;
    private Component component;
    private List<Component> components = new ArrayList<Component>();

    public UndeployTask() {
        this.setCommand(this.action);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setForce(boolean force) {
        this.addCommandParameter("force", Boolean.toString(force));
    }

    public void setDroptables(boolean droptables) {
        this.addCommandParameter("droptables", Boolean.toString(droptables));
    }

    public void setCascade(boolean cascade) {
        this.addCommandParameter("cascade", Boolean.toString(cascade));
    }

    public void setKeepreposdir(boolean keepreposdir) {
        this.addCommandParameter("keepreposdir", Boolean.toString(keepreposdir));
    }

    public Component createComponent() {
        this.component = new Component();
        this.components.add(this.component);
        return this.component;
    }

    @Override
    public void execute() throws BuildException {
        if (this.components.size() == 0 && this.name == null) {
            this.log("name attribute or component must be specified", 1);
            return;
        }
        this.processComponents();
        if (this.name != null) {
            this.addCommandOperand(this.name);
            super.execute();
        }
    }

    private void processComponents() throws BuildException {
        for (Component comp : this.components) {
            if (comp.name == null) {
                this.log("name attribute must be specified in component to deploy", 1);
                return;
            }
            comp.addCommandOperand(comp.name);
            super.execute(this.action + " " + comp.getCommand());
        }
    }
}

