/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.glassfish.appclient.client.acc.config.LogService;

public class ACCLogger
extends Logger {
    private static final String ACC_LOGGER_NAME = "GlassFish.ACC";
    private static final Level DEFAULT_ACC_LOG_LEVEL = Level.INFO;

    public ACCLogger(LogService logService) throws IOException {
        super(ACC_LOGGER_NAME, null);
        this.init(logService);
    }

    private void init(LogService logService) throws IOException {
        Level level = ACCLogger.chooseLevel(logService.getLevel());
        Handler configuredFileHandler = ACCLogger.createHandler(logService.getFile(), level);
        Enumeration<String> names = LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            ACCLogger.reviseLogger(LogManager.getLogManager().getLogger(names.nextElement()), level, configuredFileHandler);
        }
    }

    private static Level chooseLevel(String configLevelText) {
        Level level = DEFAULT_ACC_LOG_LEVEL;
        if (configLevelText != null && !configLevelText.equals("")) {
            try {
                level = Level.parse(configLevelText);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(ACCLogger.class.getName()).warning("Logger.Level = " + configLevelText + "??");
            }
        }
        return level;
    }

    private static Handler createHandler(String filePath, Level level) throws IOException {
        FileHandler handler = null;
        if (filePath == null || filePath.equals("")) {
            return null;
        }
        handler = new FileHandler(filePath, true);
        handler.setFormatter(new SimpleFormatter());
        handler.setLevel(level);
        File lockFile = new File(filePath + ".lck");
        lockFile.deleteOnExit();
        return handler;
    }

    private static void reviseLogger(final Logger logger, final Level level, final Handler handler) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!logger.isLoggable(level)) {
                    logger.setLevel(level);
                }
                if (handler != null) {
                    logger.addHandler(handler);
                }
                return null;
            }
        });
    }
}

