/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.callbackhandler;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.glassfish.appclient.client.acc.callbackhandler.CallbackBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackGUIBindings {
    private static final Map<Class, Class> callbackToBinding = CallbackGUIBindings.initCallbackToBindingMap();
    protected static final int LIST_ROWS = 4;
    protected static final int TEXT_ROWS = 4;
    protected static final int TEXT_COLUMNS = 20;

    private static Map<Class, Class> initCallbackToBindingMap() {
        HashMap<Class, Class> result = new HashMap<Class, Class>();
        result.put(ChoiceCallback.class, Choice.class);
        result.put(ConfirmationCallback.class, Confirmation.class);
        result.put(LanguageCallback.class, Language.class);
        result.put(NameCallback.class, Name.class);
        result.put(PasswordCallback.class, Password.class);
        result.put(TextInputCallback.class, TextInput.class);
        result.put(TextOutputCallback.class, TextOutput.class);
        return result;
    }

    public Binding createCallbackGUIBinding(Callback callback) throws UnsupportedCallbackException, InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Class bindingClass = callbackToBinding.get(callback.getClass());
        if (bindingClass != null) {
            Constructor constructor = bindingClass.getConstructor(CallbackGUIBindings.class);
            Binding binding = (Binding)constructor.newInstance(this);
            binding.setCallback(callback);
            return binding;
        }
        throw new UnsupportedCallbackException(callback);
    }

    public Confirmation getDefaultConfirmationCallbackUIBinding() {
        ConfirmationCallback defaultCallback = new ConfirmationCallback(0, 2, 3);
        Confirmation binding = new Confirmation();
        binding.setCallback(defaultCallback);
        return binding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MessageType {
        PLAIN(-1),
        INFORMATION(1, 0, 0),
        QUESTION(3),
        WARNING(2, 1, 1),
        ERROR(0, 2, 2);

        private int optionPaneMessageType;
        private int confirmationCallbackMessageType;
        private int textOutputCallbackMessageType;
        private boolean mapsToCallback;

        private MessageType(int optionPaneMessageType) {
            this.optionPaneMessageType = optionPaneMessageType;
            this.mapsToCallback = false;
        }

        private MessageType(int optionPaneMessageType, int confirmationCallbackMessageType, int textOutputCallbackMessageType) {
            this.mapsToCallback = true;
            this.optionPaneMessageType = optionPaneMessageType;
            this.confirmationCallbackMessageType = confirmationCallbackMessageType;
            this.textOutputCallbackMessageType = textOutputCallbackMessageType;
        }

        public int getOptionPaneMessageType() {
            return this.optionPaneMessageType;
        }

        public boolean exceeds(MessageType ms) {
            return ms == null || this.ordinal() > ms.ordinal();
        }

        public static MessageType severityForConfirmation(int confirmationCallbackMessageType) {
            for (MessageType ms : MessageType.values()) {
                if (!ms.mapsToCallback || ms.confirmationCallbackMessageType != confirmationCallbackMessageType) continue;
                return ms;
            }
            throw new IllegalArgumentException(Integer.toString(confirmationCallbackMessageType));
        }

        public static MessageType severityForTextOutput(int textOutputCallbackMessageType) {
            for (MessageType ms : MessageType.values()) {
                if (!ms.mapsToCallback || ms.textOutputCallbackMessageType != textOutputCallbackMessageType) continue;
                return ms;
            }
            throw new IllegalArgumentException(Integer.toString(textOutputCallbackMessageType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Language
    extends Binding<LanguageCallback> {
        private JList languageList;

        @Override
        public JComponent createComponent() {
            Vector<LocaleEntry> entries = new Vector<LocaleEntry>();
            Locale defaultLocale = Locale.getDefault();
            LocaleEntry defaultEntry = null;
            Locale[] sortedLocales = Locale.getAvailableLocales();
            Arrays.sort(sortedLocales, new Comparator<Locale>(){

                @Override
                public int compare(Locale l1, Locale l2) {
                    return l1.getDisplayName().compareTo(l2.getDisplayName());
                }
            });
            for (Locale locale : sortedLocales) {
                LocaleEntry newEntry = new LocaleEntry(locale);
                entries.add(newEntry);
                if (!locale.equals(defaultLocale)) continue;
                defaultEntry = newEntry;
            }
            this.languageList = new JList(entries);
            this.languageList.setVisibleRowCount(4);
            this.languageList.setSelectedValue(defaultEntry, true);
            return this.prepareScrollPane(this.languageList);
        }

        @Override
        public void finish() {
            ((LanguageCallback)this.callback).setLocale(((LocaleEntry)this.languageList.getSelectedValue()).locale);
        }

        private class LocaleEntry {
            private Locale locale;

            private LocaleEntry(Locale locale) {
                this.locale = locale;
            }

            public String toString() {
                return this.locale.getDisplayName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TextOutput
    extends Binding<TextOutputCallback> {
        private JTextArea textArea;

        @Override
        public JComponent createComponent() {
            String s = ((TextOutputCallback)this.callback).getMessage();
            this.textArea = new JTextArea(((TextOutputCallback)this.callback).getMessage());
            this.textArea.setEditable(false);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
            this.textArea.setBackground(new JLabel().getBackground());
            return this.textArea;
        }

        @Override
        public void finish() {
        }

        @Override
        public MessageType getMessageType() {
            return MessageType.severityForTextOutput(((TextOutputCallback)this.callback).getMessageType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TextInput
    extends Binding<TextInputCallback> {
        private JTextArea textArea;

        @Override
        public JComponent createComponent() {
            this.textArea = new JTextArea(((TextInputCallback)this.callback).getDefaultText(), 4, 20);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            return this.prepareScrollPane(((TextInputCallback)this.callback).getPrompt(), this.textArea);
        }

        @Override
        public void finish() {
            ((TextInputCallback)this.callback).setText(this.textArea.getText());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Password
    extends Binding<PasswordCallback> {
        private JPasswordField passwordField;

        @Override
        public JComponent createComponent() {
            this.passwordField = new JPasswordField();
            return this.createPromptedInputBox(((PasswordCallback)this.callback).getPrompt(), this.passwordField);
        }

        @Override
        public void finish() {
            ((PasswordCallback)this.callback).setPassword(this.passwordField.getPassword());
            this.passwordField.setText("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Name
    extends Binding<NameCallback> {
        private JTextField nameField;

        @Override
        protected JComponent createComponent() {
            this.nameField = new JTextField(((NameCallback)this.callback).getDefaultName());
            JComponent result = this.createPromptedInputBox(((NameCallback)this.callback).getPrompt(), this.nameField);
            return result;
        }

        @Override
        public void finish() {
            ((NameCallback)this.callback).setName(this.nameField.getText());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Confirmation
    extends Binding<ConfirmationCallback> {
        @Override
        protected JComponent createComponent() {
            return null;
        }

        @Override
        protected MessageType getMessageType() {
            return MessageType.severityForConfirmation(((ConfirmationCallback)this.callback).getMessageType());
        }

        @Override
        public void finish() {
        }

        public int getOptionPaneOptionType() {
            if (((ConfirmationCallback)this.callback).getOptionType() == 2) {
                return 2;
            }
            if (((ConfirmationCallback)this.callback).getOptionType() == 1) {
                return 1;
            }
            if (((ConfirmationCallback)this.callback).getOptionType() == 0) {
                return 0;
            }
            return 2;
        }

        public String[] getOptions() {
            return ((ConfirmationCallback)this.callback).getOptions();
        }

        public int getDefaultOption() {
            return ((ConfirmationCallback)this.callback).getDefaultOption();
        }

        public void setResult(int result) {
            int callbackResult = -1;
            if (((ConfirmationCallback)this.callback).getOptionType() == -1) {
                callbackResult = result;
            } else if (((ConfirmationCallback)this.callback).getOptionType() == 2) {
                if (result == 0) {
                    callbackResult = 3;
                } else if (result == 2) {
                    callbackResult = 2;
                }
            } else if (((ConfirmationCallback)this.callback).getOptionType() == 1) {
                if (result == 0) {
                    callbackResult = 0;
                } else if (result == 1) {
                    callbackResult = 1;
                } else if (result == 2) {
                    callbackResult = 2;
                }
            } else if (((ConfirmationCallback)this.callback).getOptionType() == 0) {
                if (result == 0) {
                    callbackResult = 0;
                } else if (result == 1) {
                    callbackResult = 1;
                }
            }
            ((ConfirmationCallback)this.callback).setSelectedIndex(callbackResult);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Choice
    extends Binding<ChoiceCallback> {
        private JList jList;

        @Override
        protected JComponent createComponent() {
            this.jList = this.prepareList(((ChoiceCallback)this.callback).getChoices(), ((ChoiceCallback)this.callback).getSelectedIndexes());
            return this.prepareScrollPane(((ChoiceCallback)this.callback).getPrompt(), this.jList);
        }

        private JList prepareList(String[] choices, int[] selectedIndexes) {
            JList<String> result = new JList<String>();
            result.setVisibleRowCount(4);
            result.setListData(choices);
            if (selectedIndexes != null) {
                result.setSelectedIndices(selectedIndexes);
            }
            result.setSelectionMode(((ChoiceCallback)this.callback).allowMultipleSelections() ? 2 : 0);
            return result;
        }

        @Override
        public void finish() {
            if (((ChoiceCallback)this.callback).allowMultipleSelections()) {
                ((ChoiceCallback)this.callback).setSelectedIndexes(this.jList.getSelectedIndices());
            } else {
                ((ChoiceCallback)this.callback).setSelectedIndex(this.jList.getSelectedIndex());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Binding<C extends Callback>
    implements CallbackBinding<C> {
        private JComponent component = null;
        protected C callback;
        private MessageType messageType;

        protected JComponent createPromptedInputBox(String prompt, JComponent input) {
            Box box = new Box(0);
            JLabel promptLabel = new JLabel(prompt);
            box.add(promptLabel);
            box.add(input);
            return box;
        }

        protected MessageType getMessageType() {
            return null;
        }

        protected JScrollPane prepareScrollPane(JComponent body) {
            return new JScrollPane(body);
        }

        protected JScrollPane prepareScrollPane(String columnHeader, JComponent body) {
            JScrollPane scrollPane = new JScrollPane(body);
            JLabel headerLabel = new JLabel(columnHeader);
            headerLabel.setBorder(new EtchedBorder(0));
            scrollPane.setColumnHeaderView(headerLabel);
            return scrollPane;
        }

        protected abstract JComponent createComponent();

        public JComponent getComponent() {
            if (this.component == null) {
                this.component = this.createComponent();
            }
            return this.component;
        }

        @Override
        public void setCallback(C callback) {
            this.callback = callback;
        }
    }
}

