/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.ClientJarMakerUtils;
import org.glassfish.deployment.common.DownloadableArtifacts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NestedAppClientDeployerHelper
extends AppClientDeployerHelper {
    private Set<DownloadableArtifacts.FullAndPartURIs> libraryAndClassPathJARs = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
    private StringBuilder classPathForFacade = new StringBuilder();
    private final URI earURI;
    private final Set<DownloadableArtifacts.FullAndPartURIs> downloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
    private static final Pattern submoduleURIPattern = Pattern.compile("(.*)_([wcrj]ar)$");

    NestedAppClientDeployerHelper(DeploymentContext dc, ApplicationClientDescriptor bundleDesc, AppClientArchivist archivist) throws IOException {
        super(dc, bundleDesc, archivist);
        this.earURI = dc.getSource().getParentArchive().getURI();
        this.processJARDependencies();
    }

    private void processJARDependencies() throws IOException {
        File libDirFile;
        URI appClientURI = URI.create(Util.getURIName((URI)this.appClientUserURI(this.dc())));
        this.classPathForFacade.append(appClientURI);
        this.downloads.add(new DownloadableArtifacts.FullAndPartURIs(this.facadeServerURI(this.dc()), this.facadeUserURI(this.dc())));
        HashSet<URI> jarURIsProcessed = new HashSet<URI>();
        this.processJARDependencies(this.appClientServerURI(this.dc()), this.downloads, jarURIsProcessed);
        String libDir = this.appClientDesc().getApplication().getLibraryDirectory();
        if (libDir != null && (libDirFile = new File(new File(this.earURI), libDir)).exists() && libDirFile.isDirectory()) {
            for (File libJar : libDirFile.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar") && !pathname.isDirectory();
                }
            })) {
                URI libJarURI = this.facadeServerURI(this.dc()).relativize(libJar.toURI());
                this.classPathForFacade.append(' ').append(libJarURI.toASCIIString());
                URI jarURI = URI.create("jar:" + libJar.toURI().getRawSchemeSpecificPart());
                this.processJARDependencies(jarURI, this.downloads, jarURIsProcessed);
            }
        }
    }

    private void processJARDependencies(URI dependencyURI, Set<DownloadableArtifacts.FullAndPartURIs> downloads, Set<URI> jarURIsProcessed) throws IOException {
        if (jarURIsProcessed.contains(dependencyURI)) {
            return;
        }
        URI dependencyFileURI = this.earURI.resolve(dependencyURI);
        DownloadableArtifacts.FullAndPartURIs jarFileDependency = this.safeCopyOfExpandedSubmodule(dependencyURI);
        if (jarFileDependency != null) {
            dependencyFileURI = jarFileDependency.getFull();
        } else {
            String scheme = dependencyFileURI.getScheme();
            if (scheme != null && scheme.equals("jar")) {
                dependencyFileURI = URI.create("file:" + dependencyURI.getRawSchemeSpecificPart());
            } else {
                if (scheme == null) {
                    scheme = "file";
                }
                dependencyFileURI = URI.create(scheme + ":" + dependencyURI.getRawSchemeSpecificPart());
            }
            if (!new File(dependencyFileURI).exists()) {
                return;
            }
            jarFileDependency = new DownloadableArtifacts.FullAndPartURIs(dependencyFileURI, this.earDirUserURI(this.dc()).resolve(this.earURI.relativize(dependencyFileURI)));
        }
        downloads.add(jarFileDependency);
        URI jarURI = URI.create("jar:" + dependencyFileURI.getRawSchemeSpecificPart());
        InputJarArchive dependentJar = new InputJarArchive();
        dependentJar.open(jarURI);
        Manifest jarManifest = dependentJar.getManifest();
        dependentJar.close();
        Attributes mainAttrs = jarManifest.getMainAttributes();
        String jarClassPath = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
        if (jarClassPath != null) {
            for (String elt : jarClassPath.split(" ")) {
                this.processJARDependencies(jarFileDependency.getFull().resolve(elt), downloads, jarURIsProcessed);
            }
        }
    }

    private DownloadableArtifacts.FullAndPartURIs safeCopyOfExpandedSubmodule(URI candidateSubmoduleURI) throws IOException {
        for (ModuleDescriptor desc : this.appClientDesc().getApplication().getModules()) {
            if (!this.matchesSubmoduleURI(candidateSubmoduleURI, desc.getArchiveUri()) || this.dc().getSource().getParentArchive().exists(candidateSubmoduleURI.getPath())) continue;
            FileArchive source = new FileArchive();
            source.open(this.dc().getSource().getParentArchive().getURI().resolve(this.expandedDirURI(candidateSubmoduleURI)));
            OutputJarArchive target = new OutputJarArchive();
            target.create(this.dc().getScratchDir("xml").toURI().resolve(candidateSubmoduleURI));
            Manifest mf = source.getManifest();
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            mf.write(os);
            target.closeEntry();
            ClientJarMakerUtils.copyArchive((ReadableArchive)source, (WritableArchive)target, Collections.EMPTY_SET);
            target.close();
            return new DownloadableArtifacts.FullAndPartURIs(target.getURI(), this.earDirUserURI(this.dc()).resolve(this.earURI.relativize(candidateSubmoduleURI)));
        }
        return null;
    }

    private boolean matchesSubmoduleURI(URI candidateURI, String submoduleURIText) {
        Matcher candidateMatcher = submoduleURIPattern.matcher(candidateURI.getPath());
        URI normalizedCandidateURI = candidateMatcher.matches() ? URI.create(candidateMatcher.group(1) + "." + candidateMatcher.group(2)) : candidateURI;
        candidateMatcher.reset(submoduleURIText);
        URI normalizedSubmoduleURI = candidateMatcher.matches() ? URI.create(candidateMatcher.group(1) + "." + candidateMatcher.group(2)) : URI.create(submoduleURIText);
        return normalizedCandidateURI.equals(normalizedSubmoduleURI);
    }

    private URI expandedDirURI(URI submoduleURI) {
        String uriText = submoduleURI.toString();
        int lastDot = uriText.lastIndexOf(46);
        return URI.create(uriText.substring(0, lastDot) + "_" + uriText.substring(lastDot + 1));
    }

    private URI convertExpandedDirToJarURI(String submoduleURI) {
        URI result = null;
        Matcher m = submoduleURIPattern.matcher(submoduleURI);
        if (m.matches()) {
            result = URI.create(m.group(1) + "." + m.group(2));
        }
        return result;
    }

    @Override
    protected URI facadeServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml");
        return genXMLDir.toURI().resolve(this.relativeFacadeURI(dc));
    }

    @Override
    protected Set<DownloadableArtifacts.FullAndPartURIs> downloads() {
        return this.downloads;
    }

    @Override
    protected String facadeClassPath() {
        return this.classPathForFacade.toString();
    }

    @Override
    protected void prepareJARs() throws IOException, URISyntaxException {
        this.generateAppClientFacade();
    }

    private String appName(DeploymentContext dc) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        return params.name();
    }

    @Override
    protected URI facadeUserURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client/" + this.relativeFacadeURI(dc));
    }

    private URI relativeFacadeURI(DeploymentContext dc) {
        return this.moduleURI().resolve(this.facadeFileNameAndType(dc));
    }

    @Override
    protected String facadeFileNameAndType(DeploymentContext dc) {
        return this.moduleNameOnly() + "Client.jar";
    }

    @Override
    protected URI appClientUserURI(DeploymentContext dc) {
        return this.earDirUserURI(dc).resolve(this.moduleURI());
    }

    @Override
    protected URI appClientUserURIForFacade(DeploymentContext dc) {
        return URI.create(Util.getURIName((URI)this.appClientUserURI(dc)));
    }

    private URI earDirUserURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client/");
    }

    @Override
    protected URI appClientServerURI(DeploymentContext dc) {
        String appClientURIWithinEAR = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        Matcher m = submoduleURIPattern.matcher(appClientURIWithinEAR);
        URI result = m.matches() ? new File(dc.getScratchDir("xml"), m.group(1) + "." + m.group(2)).toURI() : new File(new File(this.earURI), appClientURIWithinEAR).toURI();
        return result;
    }

    @Override
    protected URI appClientURIWithinApp(DeploymentContext dc) {
        return URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
    }

    private URI moduleURI() {
        return URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
    }

    private String moduleNameAndType() {
        return Util.getURIName((URI)this.moduleURI());
    }

    private String moduleNameOnly() {
        String nameAndType = this.moduleNameAndType();
        return nameAndType.substring(0, nameAndType.lastIndexOf(".jar"));
    }
}

