/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCModulesManager;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.UserError;
import org.xml.sax.SAXParseException;

public class FacadeLaunchable
implements Launchable {
    public static final Attributes.Name GLASSFISH_APPCLIENT_GROUP = new Attributes.Name("GlassFish-AppClient-Group");
    public static final Attributes.Name GLASSFISH_APPCLIENT_MAIN_CLASS = new Attributes.Name("Glassfish-AppClient-Main-Class");
    public static final Attributes.Name GLASSFISH_APPCLIENT = new Attributes.Name("GlassFish-AppClient");
    public static final ArchiveFactory archiveFactory = ACCModulesManager.getComponent(ArchiveFactory.class);
    private static final Logger logger = Logger.getLogger(FacadeLaunchable.class.getName());
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(FacadeLaunchable.class);
    private final String mainClassNameToLaunch;
    private final URI[] classPathURIs;
    private final ReadableArchive clientRA;
    private ReadableArchive facadeClientRA;
    private AppClientArchivist facadeArchivist = null;
    private ApplicationClientDescriptor acDesc = null;
    private ClassLoader classLoader = null;

    FacadeLaunchable(Attributes mainAttrs, ReadableArchive facadeRA) throws IOException, URISyntaxException {
        this(facadeRA, mainAttrs, FacadeLaunchable.openOriginalArchive(facadeRA, mainAttrs.getValue(GLASSFISH_APPCLIENT)), mainAttrs.getValue(GLASSFISH_APPCLIENT_MAIN_CLASS));
    }

    private static ReadableArchive openOriginalArchive(ReadableArchive facadeArchive, String relativeURIToOriginalJar) throws IOException, URISyntaxException {
        URI uriToOriginal = facadeArchive.getURI().resolve(relativeURIToOriginalJar);
        return archiveFactory.openArchive(uriToOriginal);
    }

    FacadeLaunchable(ReadableArchive facadeClientRA, Attributes mainAttrs, ReadableArchive clientRA, String mainClassNameToLaunch) throws IOException {
        this.facadeClientRA = facadeClientRA;
        this.mainClassNameToLaunch = mainClassNameToLaunch;
        this.clientRA = clientRA;
        this.classPathURIs = this.toURIs(mainAttrs.getValue(Attributes.Name.CLASS_PATH));
    }

    public URI getURI() {
        return this.facadeClientRA.getURI();
    }

    protected URI[] toURIs(String uriList) {
        String[] uris = uriList.split(" ");
        URI[] result = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            result[i] = URI.create(uris[i]);
        }
        return result;
    }

    protected AppClientArchivist getFacadeArchivist() {
        if (this.facadeArchivist == null) {
            this.facadeArchivist = new AppClientArchivist();
        }
        return this.facadeArchivist;
    }

    public void validateDescriptor() {
        this.getFacadeArchivist().validate(this.classLoader);
    }

    static FacadeLaunchable newFacade(ReadableArchive facadeRA, String callerSuppliedMainClassName, String callerSuppliedAppName) throws IOException, BootException, URISyntaxException, XMLStreamException, SAXParseException, UserError {
        Manifest mf = facadeRA.getManifest();
        Attributes mainAttrs = mf.getMainAttributes();
        FacadeLaunchable result = null;
        if (mainAttrs.containsKey(GLASSFISH_APPCLIENT)) {
            result = new FacadeLaunchable(mainAttrs, facadeRA);
        } else {
            String facadeGroupURIs = mainAttrs.getValue(GLASSFISH_APPCLIENT_GROUP);
            if (facadeGroupURIs != null) {
                result = FacadeLaunchable.selectFacadeFromGroup(facadeRA.getURI(), archiveFactory, facadeGroupURIs, callerSuppliedMainClassName, callerSuppliedAppName);
            } else {
                return null;
            }
        }
        return result;
    }

    public Class getMainClass() throws ClassNotFoundException {
        return Class.forName(this.mainClassNameToLaunch, true, Thread.currentThread().getContextClassLoader());
    }

    public ApplicationClientDescriptor getDescriptor(ClassLoader loader) throws IOException, SAXParseException {
        if (this.acDesc == null) {
            this.acDesc = (ApplicationClientDescriptor)this.getFacadeArchivist().open(this.facadeClientRA);
            this.getFacadeArchivist().setDescriptor((RootDeploymentDescriptor)this.acDesc);
            this.classLoader = loader;
        }
        return this.acDesc;
    }

    public URI[] getClassPathURIs() {
        return this.classPathURIs;
    }

    private static FacadeLaunchable selectFacadeFromGroup(URI groupFacadeURI, ArchiveFactory af, String groupURIs, String callerSpecifiedMainClassName, String callerSpecifiedAppClientName) throws IOException, BootException, URISyntaxException, SAXParseException, UserError {
        String[] archiveURIs = groupURIs.split(" ");
        if (archiveURIs.length == 0) {
            String msg = localStrings.getLocalString(FacadeLaunchable.class, "appclient.noClientsInGroup", "No app clients are listed in the app client group {0}", new Object[]{groupFacadeURI});
            throw new UserError(msg);
        }
        for (String uriText : archiveURIs) {
            URI clientFacadeURI = groupFacadeURI.resolve(uriText);
            ReadableArchive clientFacadeRA = af.openArchive(clientFacadeURI);
            Manifest facadeMF = clientFacadeRA.getManifest();
            Attributes facadeMainAttrs = facadeMF.getMainAttributes();
            URI clientURI = clientFacadeURI.resolve(facadeMF.getMainAttributes().getValue(GLASSFISH_APPCLIENT));
            ReadableArchive clientRA = af.openArchive(clientURI);
            FacadeLaunchable facade = null;
            if (callerSpecifiedMainClassName == null && callerSpecifiedAppClientName == null || archiveURIs.length == 1) {
                facade = new FacadeLaunchable(clientFacadeRA, facadeMainAttrs, clientRA, facadeMainAttrs.getValue(GLASSFISH_APPCLIENT_MAIN_CLASS));
                if (!Launchable.LauchableUtil.matchesMainClassName(clientRA, callerSpecifiedMainClassName) || !Launchable.LauchableUtil.matchesName(clientRA, callerSpecifiedAppClientName)) {
                    String msg = localStrings.getLocalString(FacadeLaunchable.class, "appclient.singleNestedClientNoMatch", "Using the only client in {0} even though it does not match the specified main class name or client name", new Object[]{groupFacadeURI});
                    logger.warning(msg);
                }
            } else if (Launchable.LauchableUtil.matchesMainClassName(clientRA, callerSpecifiedMainClassName)) {
                facade = new FacadeLaunchable(clientFacadeRA, facadeMainAttrs, clientRA, callerSpecifiedMainClassName);
            } else if (Launchable.LauchableUtil.matchesName(clientRA, callerSpecifiedAppClientName)) {
                facade = new FacadeLaunchable(clientFacadeRA, facadeMainAttrs, clientRA, facadeMainAttrs.getValue(GLASSFISH_APPCLIENT_MAIN_CLASS));
            }
            if (facade == null) continue;
            return facade;
        }
        String msg = localStrings.getLocalString(FacadeLaunchable.class, "appclient.noMatchingClientInGroup", "No app client in the app client group {0} matches the main class name \"{1}\" or the app client name \"{2}\"", new Object[]{groupFacadeURI, callerSpecifiedMainClassName, callerSpecifiedAppClientName});
        throw new UserError(msg);
    }
}

