/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.glassfish.appclient.client.acc.TargetServerHelper;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.config.ClientContainer;
import org.glassfish.appclient.client.acc.config.TargetServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientCommand {
    private static final String CLIENT = "-client";
    private static final String NAME = "-name";
    private static final String MAIN_CLASS = "-mainclass";
    private static final String TEXT_AUTH = "-textauth";
    private static final String XML_PATH = "-xml";
    private static final String ACC_CONFIG_XML = "-configxml";
    private static final String DEFAULT_CLIENT_CONTAINER_XML = "sun-acc.xml";
    private static final String SUNACC_XML_URL = "sun-acc.xml.url";
    private static final String NO_APP_INVOKE = "-noappinvoke";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static final String PASSWORD_FILE = "-passwordfile";
    private static final String DASH = "-";
    private static final String TARGETSERVER = "-targetserver";
    private static final String lineSep = System.getProperty("line.separator");
    private static final String IIOP_ENDPOINTS_PROPERTY = "com.sun.appserv.iiop.endpoints";
    private static LocalStringManager localStrings = new LocalStringManagerImpl(AppClientCommand.class);
    private static final Logger _logger = Logger.getLogger(AppClientCommand.class.getName());
    protected final String[] args;
    protected String clientJarOrDirOrClassFile = null;
    protected String displayName = null;
    protected String mainClass = null;
    protected String xmlPath = null;
    protected String accConfigXml = "sun-acc.xml";
    protected String jwsACCConfigXml = null;
    protected String[] appArgs;
    protected String classFileFromCommandLine = null;
    protected boolean useTextAuth = false;
    protected boolean runClient = true;
    protected String username = null;
    protected char[] password = null;
    protected String servers = null;
    private ClientContainer clientContainerFromConfigFile = null;
    private Class clientClass = null;

    public static void main(String[] args) {
        try {
            new AppClientCommand(args).run();
        }
        catch (UserError ue) {
            ue.displayAndExit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private AppClientCommand(String[] args) throws BootException, URISyntaxException {
        this.args = args;
    }

    private void run() throws UserError, FileNotFoundException, JAXBException {
        this.clientContainerFromConfigFile = this.processConfigFile();
        TargetServer[] targetServers = TargetServerHelper.targetServers(this.clientContainerFromConfigFile, this.servers);
        if (this.isClientValueClassFile()) {
            // empty if block
        }
    }

    private boolean isClientValueClassFile() {
        return this.clientJarOrDirOrClassFile.endsWith(".class");
    }

    private String[] processCommandLine(String[] args) throws UserError {
        ArrayList<String> clientArgs = new ArrayList<String>();
        AtomicInteger i = new AtomicInteger();
        String arg = null;
        if (args.length < 1) {
            this.usage();
        } else {
            while (i.get() < args.length) {
                arg = args[i.getAndIncrement()];
                if (arg.equals(CLIENT)) {
                    this.clientJarOrDirOrClassFile = this.getRequiredCommandOptionValue(args, CLIENT, i, "appclient.clientWithoutValue", "The -client option must be followed by a file spec for the client file");
                    continue;
                }
                if (arg.equals(NAME)) {
                    this.displayName = this.getRequiredCommandOptionValue(args, NAME, i, "appclient.nameWithoutValue", "The -name option must be followed by a display name to be used in identifying the app client to be run");
                    this.ensureAtMostOneOfNameAndMainClass();
                    continue;
                }
                if (arg.equals(MAIN_CLASS)) {
                    this.mainClass = this.getRequiredCommandOptionValue(args, MAIN_CLASS, i, "appclient.mainClassWithoutValue", "The -mainclass option must be followed by the fully-qualified name of the class to be run");
                    this.ensureAtMostOneOfNameAndMainClass();
                    continue;
                }
                if (arg.equals(XML_PATH)) {
                    this.xmlPath = this.getRequiredUniqueCommandOptionValue(args, XML_PATH, this.xmlPath, i, "appclient.xmlWithoutValue", "The -xml option must be followed by the location of the configuration XML file");
                    continue;
                }
                if (arg.equals(ACC_CONFIG_XML)) {
                    this.accConfigXml = this.getRequiredUniqueCommandOptionValue(args, ACC_CONFIG_XML, this.accConfigXml, i, "appclient.accConfigXmlWithoutValue", "The -configxml option must be followed by the location of the back-up configuration XML file");
                    continue;
                }
                if (arg.equals(TEXT_AUTH)) {
                    this.useTextAuth = true;
                    this.logOption(TEXT_AUTH);
                    continue;
                }
                if (arg.equals(NO_APP_INVOKE)) {
                    this.runClient = false;
                    this.logOption(NO_APP_INVOKE);
                    continue;
                }
                if (arg.equals(USER)) {
                    this.username = this.getRequiredCommandOptionValue(args, USER, i, "appclient.userWithoutValue", "The -user option must be followed by a username");
                    continue;
                }
                if (arg.equals(PASSWORD)) {
                    this.password = this.getRequiredCommandOptionValue(args, PASSWORD, i, "appclient.passwordWithoutValue", "The -password option must be followed by a password").toCharArray();
                    continue;
                }
                if (arg.equals(PASSWORD_FILE)) {
                    String passwordFileValue = this.getRequiredCommandOptionValue(args, PASSWORD_FILE, i, "appclient.passwordFileWithoutValue", "The -passwordfile option must be followed by the location of the password file");
                    try {
                        this.password = this.loadPasswordFromFile(passwordFileValue).toCharArray();
                        continue;
                    }
                    catch (IOException ex) {
                        throw new UserError(AppClientCommand.getLocalString("appclient.errorReadingFromPasswordFile", "Error reading the password from the password file {0}", passwordFileValue), ex);
                    }
                }
                if (arg.equals(TARGETSERVER)) {
                    this.servers = this.getRequiredCommandOptionValue(args, TARGETSERVER, i, "appclient.serverWithoutValue", "The -targetserver option must be followed by host:port[,...]");
                    continue;
                }
                clientArgs.add(arg);
                this.logArgument(arg);
            }
            if (this.mainClass == null && this.clientJarOrDirOrClassFile == null) {
                if (clientArgs.size() > 0) {
                    this.classFileFromCommandLine = (String)clientArgs.get(0);
                    clientArgs.remove(0);
                    this.logClassFileArgument(this.classFileFromCommandLine);
                } else {
                    this.usage();
                }
            }
        }
        this.logClientArgs(clientArgs);
        return clientArgs.toArray(new String[clientArgs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadPasswordFromFile(String fileName) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(fileName));
            Properties props = new Properties();
            props.load(inputStream);
            String string = props.getProperty("PASSWORD");
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private ClientContainer processConfigFile() throws FileNotFoundException, JAXBException {
        String configFilePath = this.xmlPath != null ? this.xmlPath : this.accConfigXml;
        FileInputStream is = new FileInputStream(configFilePath);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ClientContainer.class});
        Unmarshaller u = context.createUnmarshaller();
        return (ClientContainer)u.unmarshal((InputStream)is);
    }

    private String getRequiredCommandOptionValue(String[] args, String optionName, AtomicInteger position, String errorKey, String defaultErrorMsg) throws UserError {
        String result = null;
        if (position.get() >= args.length || args[position.get()].startsWith(DASH)) {
            throw new UserError(AppClientCommand.getLocalString(errorKey, defaultErrorMsg));
        }
        result = args[position.getAndIncrement()];
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(AppClientCommand.getLocalString("appclient.optionValueIs", optionName, result));
        }
        return result;
    }

    private String getRequiredUniqueCommandOptionValue(String[] args, String optionName, String currentValue, AtomicInteger position, String errorKey, String defaultMsg) throws UserError {
        if (currentValue != null) {
            throw new UserError(AppClientCommand.getLocalString("appclient.duplicateValue", "Option {0} can be specified at most once and was already set to {1}", optionName, currentValue));
        }
        return this.getRequiredCommandOptionValue(args, optionName, position, errorKey, defaultMsg);
    }

    private void ensureAtMostOneOfNameAndMainClass() throws UserError {
        if (this.mainClass != null && this.displayName != null) {
            throw new UserError(AppClientCommand.getLocalString("appclient.mainclassOrNameNotBoth", "Specify either -mainclass or -name but not both to identify the app client to be run"));
        }
    }

    private void logOption(String optionName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(AppClientCommand.getLocalString("appclient.valuelessOptionFound", "Option {0} processed", optionName));
        }
    }

    private void logArgument(String arg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(AppClientCommand.getLocalString("appclient.argumentValueFound", "Argument value {0} processed", arg));
        }
    }

    private void logClassFileArgument(String classFile) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(AppClientCommand.getLocalString("appclient.classFileUsed", "Will use argument {0} as the .class file to be run", classFile));
        }
    }

    private void logClientArgs(List<String> clientArgs) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(AppClientCommand.getLocalString("appclient.clientArgs", "Arguments to be passed to the client: {0}", clientArgs.toString()));
        }
    }

    private String getUsage() {
        return AppClientCommand.getLocalString("main.usage", "appclient [ -client <appjar> | -jar <appjar> | <classfile> ] [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [-user <username>] [-password <password>|-passwordfile <password-file>] [app-args]");
    }

    private void usage() {
        System.out.println(this.getUsage());
        System.exit(1);
    }

    private static String getLocalString(String key, String defaultMsg, Object ... args) {
        return localStrings.getLocalString(AppClientCommand.class, key, defaultMsg, args);
    }

    private static String getLocalString(String key, String defaultMsg) {
        return AppClientCommand.getLocalString(key, defaultMsg, new Object[0]);
    }
}

