/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.ClientJarMakerUtils;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StandaloneAppClientDeployerHelper
extends AppClientDeployerHelper {
    StandaloneAppClientDeployerHelper(DeploymentContext dc, ApplicationClientDescriptor bundleDesc, AppClientArchivist archivist) throws IOException {
        super(dc, bundleDesc, archivist);
    }

    private String facadeNameOnly(DeploymentContext dc) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        String appName = params.name();
        return appName + "Client";
    }

    @Override
    protected void prepareJARs() throws IOException, URISyntaxException {
        super.prepareJARs();
        this.copyOriginalAppClientJAR(this.dc());
    }

    @Override
    protected String facadeFileNameAndType(DeploymentContext dc) {
        return this.facadeNameOnly(dc) + ".jar";
    }

    @Override
    protected URI facadeServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml");
        return genXMLDir.toURI().resolve(this.facadeFileNameAndType(dc));
    }

    @Override
    protected URI facadeUserURI(DeploymentContext dc) {
        return URI.create(this.facadeFileNameAndType(dc));
    }

    @Override
    protected URI appClientUserURI(DeploymentContext dc) {
        return URI.create(this.facadeNameOnly(dc) + '/' + this.appClientURIWithinApp(dc));
    }

    @Override
    protected URI appClientServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml");
        return genXMLDir.toURI().resolve(this.appClientURIWithinApp(dc));
    }

    @Override
    protected URI appClientURIWithinApp(DeploymentContext dc) {
        String uriText = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        if (!uriText.endsWith(".jar")) {
            uriText = uriText + ".jar";
        }
        return URI.create(uriText);
    }

    @Override
    protected Set<DownloadableArtifacts.FullAndPartURIs> downloads() throws IOException {
        HashSet<DownloadableArtifacts.FullAndPartURIs> downloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
        downloads.add(new DownloadableArtifacts.FullAndPartURIs(this.appClientServerURI(this.dc()), this.appClientUserURI(this.dc())));
        downloads.add(new DownloadableArtifacts.FullAndPartURIs(this.facadeServerURI(this.dc()), this.facadeUserURI(this.dc())));
        return downloads;
    }

    @Override
    protected URI appClientUserURIForFacade(DeploymentContext dc) {
        return this.appClientUserURI(dc);
    }

    @Override
    protected String facadeClassPath() {
        return this.appClientUserURI(this.dc()).toASCIIString();
    }

    protected void copyOriginalAppClientJAR(DeploymentContext dc) throws IOException {
        ReadableArchive originalSource = ((ExtendedDeploymentContext)dc).getOriginalSource();
        originalSource.open(originalSource.getURI());
        OutputJarArchive target = new OutputJarArchive();
        target.create(this.appClientServerURI(dc));
        Manifest originalManifest = originalSource.getManifest();
        OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
        originalManifest.write(os);
        target.closeEntry();
        ClientJarMakerUtils.copyArchive(originalSource, (WritableArchive)target, Collections.EMPTY_SET);
        target.close();
        originalSource.close();
    }
}

