/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.glassfish.appclient.client.AppClientFacadeInfo;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.ACCLogger;
import org.glassfish.appclient.client.acc.AgentArguments;
import org.glassfish.appclient.client.acc.AppClientContainer;
import org.glassfish.appclient.client.acc.AppclientCommandArguments;
import org.glassfish.appclient.client.acc.CommandLaunchInfo;
import org.glassfish.appclient.client.acc.TargetServerHelper;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.appclient.client.acc.config.ClientContainer;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.LogService;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientContainerAgent {
    private static CommandLaunchInfo launchInfo = null;
    private static AppclientCommandArguments appClientCommandArgs = null;
    private static Logger logger = Logger.getLogger(AppClientContainerAgent.class.getName());
    private static LocalStringManager localStrings = new LocalStringManagerImpl(AppClientContainerAgent.class);
    private static AppClientContainer acc = null;
    private static URI installRootURI = null;

    public static void premain(String agentArgsText, Instrumentation inst) {
        try {
            long now = System.currentTimeMillis();
            JavaVersion javaVersion = new JavaVersion();
            if (javaVersion.asInt() < 16) {
                throw new UserError(localStrings.getLocalString(AppClientContainerAgent.class, "main.badVersion", "Current Java version {0} is too low; {1} or later required", new Object[]{javaVersion.versionString, "1.6"}));
            }
            AgentArguments agentArgs = AgentArguments.newInstance((String)agentArgsText);
            ArrayList effectiveCommandLineArgs = new ArrayList();
            effectiveCommandLineArgs.addAll(agentArgs.unnamedValues());
            AppclientCommandArguments appClientCommandArgs = AppclientCommandArguments.newInstance(effectiveCommandLineArgs);
            if (appClientCommandArgs.isUsage() || appClientCommandArgs.isHelp()) {
                AppClientContainerAgent.usage(0);
            }
            launchInfo = CommandLaunchInfo.newInstance((String)agentArgsText);
            ACCClassLoader loader = AppClientContainerAgent.initClassLoader(System.getenv("APPCPATH"));
            Thread.currentThread().setContextClassLoader((ClassLoader)loader);
            if (launchInfo.getClientLaunchType() != CommandLaunchInfo.ClientLaunchType.UNKNOWN) {
                appClientCommandArgs = launchInfo.getAppclientCommandArguments();
                AppClientContainerAgent.initInstallRootProperty();
                ClientContainer clientContainer = AppClientContainerAgent.readConfig(appClientCommandArgs.getConfigFilePath(), (ClassLoader)loader);
                TargetServer[] targetServers = TargetServerHelper.targetServers((ClientContainer)clientContainer, (String)appClientCommandArgs.getTargetServer());
                AppClientContainer.Builder builder = AppClientContainerAgent.createBuilder(targetServers, clientContainer.getLogService(), appClientCommandArgs);
                acc = AppClientContainerAgent.createContainer(builder, launchInfo);
                acc.prepare();
            }
            AppClientFacadeInfo.setACC((AppClientContainer)acc);
            logger.fine("AppClientContainerAgent finished after " + (System.currentTimeMillis() - now) + " ms");
        }
        catch (UserError ue) {
            ue.displayAndExit();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void initInstallRootProperty() throws URISyntaxException {
        URI jarURI = AppClientContainerAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        File jarFile = new File(jarURI);
        File dirFile = jarFile.getParentFile().getParentFile();
        installRootURI = dirFile.toURI();
        System.setProperty("com.sun.aas.installRoot", dirFile.getAbsolutePath());
    }

    private static List<String> skipJVMArgs(List<String> options) {
        ArrayList<String> result = new ArrayList<String>();
        int slot = 0;
        boolean isClassSelected = false;
        while (slot < options.size()) {
            String option = options.get(slot);
            if (isClassSelected) {
                result.add(option);
                continue;
            }
            if (option.equals("-jar") || option.equals("-client")) {
                isClassSelected = true;
                if (slot >= options.size()) {
                    throw new IllegalArgumentException(option);
                }
                ++slot;
                continue;
            }
            if (option.charAt(0) != '-') {
                isClassSelected = true;
                continue;
            }
            if (!option.equals("-classpath") && !option.equals("-cp")) continue;
            if (slot >= options.size()) {
                throw new IllegalArgumentException(option);
            }
            ++slot;
        }
        return result;
    }

    private static ACCClassLoader initClassLoader(String appcPath) throws MalformedURLException {
        ACCClassLoader newLoader = ACCClassLoader.newInstance((ClassLoader)Thread.currentThread().getContextClassLoader());
        if (appcPath != null) {
            for (String elt : appcPath.split(File.pathSeparator)) {
                File f = new File(elt);
                newLoader.appendURL(f.toURI().toURL());
            }
        }
        return newLoader;
    }

    private static AppClientContainer.Builder createBuilder(TargetServer[] targetServers, LogService logService, AppclientCommandArguments appClientCommandArgs) throws IOException {
        AppClientContainer.Builder builder = AppClientContainer.newBuilder((TargetServer[])targetServers);
        AppClientContainerAgent.updateClientCredentials(builder, appClientCommandArgs);
        builder.logger((Logger)new ACCLogger(logService));
        return builder;
    }

    private static void updateClientCredentials(AppClientContainer.Builder builder, AppclientCommandArguments appClientCommandArgs) {
        char[] commandLinePW;
        ClientCredential cc = builder.getClientCredential();
        String user = cc != null ? cc.getUserName() : null;
        char[] pw = cc != null && cc.getPassword() != null ? cc.getPassword().get() : null;
        String commandLineUser = appClientCommandArgs.getUser();
        if (commandLineUser != null) {
            user = commandLineUser;
        }
        if ((commandLinePW = appClientCommandArgs.getPassword()) != null) {
            pw = commandLinePW;
        }
        builder.clientCredentials(user, pw);
    }

    private static AppClientContainer createContainer(AppClientContainer.Builder builder, CommandLaunchInfo launchInfo) throws Exception, UserError {
        CommandLaunchInfo.ClientLaunchType launchType = launchInfo.getClientLaunchType();
        AppClientContainer container = null;
        switch (launchType) {
            case JAR: 
            case DIR: {
                container = AppClientContainerAgent.createContainerForAppClientArchiveOrDir(builder, launchInfo.getClientName(), launchInfo.getAppclientCommandArguments().getMainclass(), launchInfo.getAppclientCommandArguments().getName());
                break;
            }
            case CLASS: {
                container = AppClientContainerAgent.createContainerForClassName(builder, launchInfo.getClientName());
                break;
            }
            case CLASSFILE: {
                container = AppClientContainerAgent.createContainerForClassFile(builder, launchInfo.getClientName());
            }
        }
        if (container == null) {
            throw new IllegalArgumentException("cannot choose app client launch type");
        }
        return container;
    }

    private static AppClientContainer createContainerForAppClientArchiveOrDir(AppClientContainer.Builder builder, String appClientPath, String mainClassName, String clientName) throws Exception, UserError {
        URI uri = Util.getURI((File)new File(appClientPath));
        return builder.newContainer(uri, null, mainClassName, clientName);
    }

    private static AppClientContainer createContainerForClassName(AppClientContainer.Builder builder, String className) throws Exception, UserError {
        ClassLoader loader = AppClientContainerAgent.prepareLoaderToFindClassFile(Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> mainClass = Class.forName(className, true, loader);
        AppClientContainer result = builder.newContainer(mainClass);
        return result;
    }

    private static ClassLoader prepareLoaderToFindClassFile(ClassLoader currentLoader) throws MalformedURLException {
        File currentDirPath = new File(System.getProperty("user.dir"));
        URLClassLoader newLoader = new URLClassLoader(new URL[]{currentDirPath.toURI().toURL()}, currentLoader);
        return newLoader;
    }

    private static AppClientContainer createContainerForClassFile(AppClientContainer.Builder builder, String classFilePath) throws MalformedURLException, ClassNotFoundException, FileNotFoundException, IOException, Exception, UserError {
        Util.verifyFilePath((String)classFilePath);
        String className = classFilePath.substring(0, classFilePath.lastIndexOf(".class")).replace(File.separatorChar, '.');
        return AppClientContainerAgent.createContainerForClassName(builder, className);
    }

    private static ClientContainer readConfig(String configPath, ClassLoader loader) throws UserError, JAXBException, FileNotFoundException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        ClientContainer result = null;
        File configFile = AppClientContainerAgent.checkXMLFile(configPath);
        AppClientContainerAgent.checkXMLFile(launchInfo.getAppclientCommandArguments().getConfigFilePath());
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(true);
        spf.setNamespaceAware(true);
        SAXParser parser = spf.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setEntityResolver(new LocalDTDResolver());
        InputSource inputSource = AppClientContainerAgent.replaceTokensForParsing(configFile);
        SAXSource saxSource = new SAXSource(reader, inputSource);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ClientContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        result = (ClientContainer)u.unmarshal((Source)saxSource);
        return result;
    }

    private static InputSource replaceTokensForParsing(File configFile) throws FileNotFoundException, IOException, URISyntaxException {
        int charsRead;
        FileReader reader = new FileReader(configFile);
        char[] buffer = new char[1024];
        CharArrayWriter writer = new CharArrayWriter();
        while ((charsRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, charsRead);
        }
        writer.close();
        reader.close();
        HashMap<String, String> mapping = new HashMap<String, String>();
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            mapping.put(propName, props.getProperty(propName));
        }
        if (!props.containsKey("com.sun.aas.installRoot")) {
            URI thisJarURI = AppClientContainerAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            if (thisJarURI.getScheme().equals("jar")) {
                String ssp = thisJarURI.getSchemeSpecificPart();
                thisJarURI = ssp.startsWith("file:") ? URI.create(ssp) : URI.create("file:" + ssp);
            }
            File thisJarFile = new File(thisJarURI);
            mapping.put("com.sun.aas.installRoot", thisJarFile.getParentFile().getParentFile().getAbsolutePath());
        }
        TokenResolver resolver = new TokenResolver(mapping);
        String configWithTokensReplaced = resolver.resolve(writer.toString());
        InputSource inputSource = new InputSource(new StringReader(configWithTokensReplaced));
        return inputSource;
    }

    private static File checkXMLFile(String xmlFullName) throws UserError {
        try {
            File f = new File(xmlFullName);
            if (f != null && f.exists() && f.isFile() && f.canRead()) {
                return f;
            }
            AppClientContainerAgent.xmlMessage(xmlFullName);
            return null;
        }
        catch (Exception ex) {
            AppClientContainerAgent.xmlMessage(xmlFullName);
            return null;
        }
    }

    private static void usage(int exitStatus) {
        System.err.println(AppClientContainerAgent.getUsage());
        System.exit(exitStatus);
    }

    private static String getUsage() {
        return localStrings.getLocalString(AppClientContainerAgent.class, "main.usage", "appclient [ <classfile> | -client <appjar> ] [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [-user <username>] [-password <password>|-passwordfile <password-file>] [-targetserver host[:port][,host[:port]...] [app-args]") + System.getProperty("line.separator") + localStrings.getLocalString(AppClientContainerAgent.class, "main.usage.1", "  or  :\n\tappclient [ <valid JVM options and valid ACC options> ] [ <appClass-name> | -jar <appjar> ] [app args]");
    }

    private static void xmlMessage(String xmlFullName) throws UserError {
        UserError ue = new UserError(localStrings.getLocalString(AppClientContainerAgent.class, "main.cannot_read_clientContainer_xml", "Client Container xml: {0} not found or unable to read.\nYou may want to use the -xml option to locate your configuration xml.", (Object[])new String[]{xmlFullName}));
        ue.setUsage(AppClientContainerAgent.getUsage());
        throw ue;
    }

    private static class JavaVersion {
        private String versionString = System.getProperty("java.version");
        private int versionAsInt = this.initVersionAsInt();

        private JavaVersion() {
        }

        private int initVersionAsInt() {
            int firstDot = this.versionString.indexOf(".");
            String tensString = this.versionString.substring(0, firstDot);
            int nextDot = this.versionString.indexOf(".", firstDot + 1);
            if (nextDot < 0) {
                nextDot = this.versionString.length();
            }
            String onesString = this.versionString.substring(firstDot + 1, nextDot);
            int version = -1;
            int tens = new Integer(tensString);
            int ones = new Integer(onesString);
            version = tens * 10 + ones;
            return version;
        }

        private int asInt() {
            return this.versionAsInt;
        }

        public String toString() {
            return this.versionString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalDTDResolver
    extends DefaultHandler {
        private static final String ACC_PUBLIC_ID = "-//Sun Microsystems Inc.//DTD Application Server 8.0 Application Client Container//EN";
        private static final URI ACC_WEB_URI = URI.create("sun-application-client-container_1_2.dtd");
        private static final Map<String, URI> publicIDToFilePath = LocalDTDResolver.initPublicIDToWeb();

        private LocalDTDResolver() {
        }

        private static Map<String, URI> initPublicIDToWeb() {
            HashMap<String, URI> result = new HashMap<String, URI>();
            result.put(ACC_PUBLIC_ID, ACC_WEB_URI);
            return result;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            if (publicId == null) {
                if (systemId == null || systemId.lastIndexOf(47) == systemId.length()) {
                    return null;
                }
                String fileName = SaxParserHandler.getSchemaURLFor((String)systemId.substring(systemId.lastIndexOf(47) + 1));
                if (fileName == null) {
                    fileName = systemId;
                }
                return new InputSource(fileName);
            }
            if (publicIDToFilePath.containsKey(publicId)) {
                URI dtdURI = installRootURI.resolve("lib/dtds/").resolve(publicIDToFilePath.get(publicId));
                File dtdFile = new File(dtdURI);
                return new InputSource(new BufferedInputStream(new FileInputStream(dtdFile)));
            }
            return null;
        }
    }
}

