/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.connector;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service(name="AppClient")
@Scoped(value=Singleton.class)
public class AppClientSniffer
extends GenericSniffer
implements Sniffer {
    private static final String[] stigmas = new String[]{"META-INF/application-client.xml", "META-INF/sun-application-client.xml"};
    private static final String[] containers = new String[]{"appclient"};

    public AppClientSniffer() {
        this(containers[0], stigmas[0], null);
    }

    public AppClientSniffer(String containerName, String appStigma, String urlPattern) {
        super(containerName, appStigma, urlPattern);
    }

    public String[] getContainersNames() {
        return containers;
    }

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        for (String s : stigmas) {
            try {
                if (!location.exists(s)) continue;
                return true;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        try {
            Manifest manifest = location.getManifest();
            if (manifest != null && manifest.getMainAttributes().containsKey(Attributes.Name.MAIN_CLASS)) {
                String uriPath = location.getURI().getPath();
                boolean isJarArchive = uriPath.endsWith(".jar") && location instanceof InputJarArchive;
                boolean isJarDir = (uriPath.endsWith(".jar/") || uriPath.endsWith("_jar/")) && location instanceof FileArchive;
                return isJarArchive || isJarDir;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isUserVisible() {
        return true;
    }

    public String[] getIncompatibleSnifferTypes() {
        return new String[]{"connector", "web", "ejb"};
    }
}

