/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.grizzly.tcp.Adapter;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.appclient.server.core.AppClientContainerStarter;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.AppClientServerApplication;
import org.glassfish.appclient.server.core.StandaloneAppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.RestrictedContentAdapter;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class AppClientDeployer
extends JavaEEDeployer<AppClientContainerStarter, AppClientServerApplication>
implements PostConstruct,
ConfigListener {
    private Logger logger;
    public static final String APPCLIENT_FACADE_CLASS_FILE = "org/glassfish/appclient/client/AppClientFacade.class";
    public static final String APPCLIENT_COMMAND_CLASS_NAME = "org.glassfish.appclient.client.AppClientFacade";
    public static final Attributes.Name GLASSFISH_APPCLIENT_MAIN_CLASS = new Attributes.Name("GlassFish-AppClient-Main-Class");
    public static final Attributes.Name GLASSFISH_APPCLIENT = new Attributes.Name("GlassFish-AppClient");
    public static final Attributes.Name SPLASH_SCREEN_IMAGE = new Attributes.Name("SplashScreen-Image");
    private static final String GF_CLIENT_MODULE_NAME = "org.glassfish.appclient.gf-client-module";
    public static final String HELPER_KEY_NAME = "org.glassfish.appclient.server.core.helper";
    public static final String JWSAPPCLIENT_SYSTEM_PREFIX = "/__JWSappclient/__system";
    @Inject
    protected ServerContext sc;
    @Inject
    protected Domain domain;
    @Inject
    private ServerContext serverContext;
    @Inject
    private DownloadableArtifacts downloadInfo;
    @Inject
    private ModulesRegistry modulesRegistry;
    @Inject
    private Applications applications;
    @Inject
    private RequestDispatcher requestDispatcher;
    private ClassLoader gfClientModuleClassLoader;
    private final Set<AppClientServerApplication> appClientApps = new HashSet<AppClientServerApplication>();
    private URI installRootURI;
    private URI umbrellaRootURI;

    protected String getModuleType() {
        return "appclient";
    }

    public void postConstruct() {
        this.logger = LogDomains.getLogger(AppClientDeployer.class, (String)"javax.enterprise.system.container.appclient");
        for (Module module : this.modulesRegistry.getModules(GF_CLIENT_MODULE_NAME)) {
            this.gfClientModuleClassLoader = module.getClassLoader();
        }
        this.installRootURI = this.serverContext.getInstallRoot().toURI();
        this.umbrellaRootURI = new File(this.installRootURI).getParentFile().toURI();
        this.startSystemContentAdapter();
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public AppClientServerApplication load(AppClientContainerStarter containerStarter, DeploymentContext dc) {
        AppClientDeployerHelper helper = this.savedHelper(dc);
        AppClientServerApplication newACServerApp = new AppClientServerApplication(dc, this, helper, this.requestDispatcher, this.applications, this.logger);
        this.appClientApps.add(newACServerApp);
        return newACServerApp;
    }

    public void unload(AppClientServerApplication application, DeploymentContext dc) {
        this.appClientApps.remove(application);
    }

    public void clean(DeploymentContext dc) {
        super.clean(dc);
        UndeployCommandParameters params = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        this.downloadInfo.clearArtifacts(params.name);
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        try {
            AppClientArchivist archivist = (AppClientArchivist)this.habitat.getComponent(AppClientArchivist.class);
            AppClientDeployerHelper helper = this.createAndSaveHelper(dc, archivist, this.gfClientModuleClassLoader);
            helper.prepareJARs();
            this.downloadInfo.addArtifacts(params.name(), helper.downloads());
        }
        catch (Exception ex) {
            throw new DeploymentException((Throwable)ex);
        }
    }

    private AppClientDeployerHelper createAndSaveHelper(DeploymentContext dc, AppClientArchivist archivist, ClassLoader clientModuleLoader) throws IOException {
        AppClientDeployerHelper h = AppClientDeployerHelper.newInstance(dc, archivist, clientModuleLoader);
        dc.addTransientAppMetaData(HELPER_KEY_NAME + this.moduleURI(dc), (Object)h.proxy());
        return h;
    }

    private AppClientDeployerHelper savedHelper(DeploymentContext dc) {
        String key = HELPER_KEY_NAME + this.moduleURI(dc);
        AppClientDeployerHelper h = ((AppClientDeployerHelper.Proxy)dc.getTransientAppMetaData(key, AppClientDeployerHelper.Proxy.class)).helper();
        if (h == null) {
            h = (AppClientDeployerHelper)dc.getTransientAppMetaData(key, StandaloneAppClientDeployerHelper.class);
        }
        return h;
    }

    private String moduleURI(DeploymentContext dc) {
        ApplicationClientDescriptor acd = (ApplicationClientDescriptor)dc.getModuleMetaData(ApplicationClientDescriptor.class);
        return acd.getModuleDescriptor().getArchiveUri();
    }

    private void startSystemContentAdapter() {
        HashMap<String, StaticContent> systemContent = new HashMap<String, StaticContent>();
        try {
            File gfClientJAR = new File(new File(this.installRootURI.getRawPath(), "modules"), "gf-client.jar");
            String classPathExpr = this.getGFClientModuleClassPath(gfClientJAR);
            URI gfClientJARURI = gfClientJAR.toURI();
            systemContent.put(this.systemPath(gfClientJARURI), new FixedContent(new File(gfClientJARURI)));
            for (String classPathElement : classPathExpr.split(" ")) {
                URI uri = gfClientJARURI.resolve(classPathElement);
                systemContent.put(this.systemPath(uri), new FixedContent(new File(uri)));
            }
            RestrictedContentAdapter systemAdapter = new RestrictedContentAdapter(systemContent);
            this.requestDispatcher.registerEndpoint(JWSAPPCLIENT_SYSTEM_PREFIX, (Adapter)systemAdapter, null);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Registered system content adapter serving " + (Object)((Object)systemAdapter));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "enterprise.deployment.appclient.jws.errStartSystemAdapter", e);
        }
    }

    private String systemPath(URI systemFileURI) {
        return "/__JWSappclient/__system/" + this.umbrellaRootURI.relativize(systemFileURI).getPath();
    }

    private String getGFClientModuleClassPath(File gfClientJAR) throws IOException {
        JarFile jf = new JarFile(gfClientJAR);
        Manifest mf = jf.getManifest();
        Attributes mainAttrs = mf.getMainAttributes();
        return mainAttrs.getValue(Attributes.Name.CLASS_PATH);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList unprocessedEvents = new ArrayList();
        for (AppClientServerApplication listener : this.appClientApps) {
            UnprocessedChangeEvents unprocessedEventsFromOneListener = listener.changed(events);
            if (unprocessedEventsFromOneListener == null) continue;
            unprocessedEvents.addAll(unprocessedEventsFromOneListener.getUnprocessed());
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }
}

