/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.appclient.server.core.AppClientDeployer;
import org.glassfish.appclient.server.core.ClientJarMakerUtils;
import org.glassfish.appclient.server.core.NestedAppClientDeployerHelper;
import org.glassfish.appclient.server.core.StandaloneAppClientDeployerHelper;
import org.glassfish.deployment.common.DownloadableArtifacts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AppClientDeployerHelper {
    private static final String PERSISTENCE_XML_PATH = "META-INF/persistence.xml";
    private final DeploymentContext dc;
    private final ApplicationClientDescriptor appClientDesc;
    protected final AppClientArchivist archivist;
    private final ClassLoader gfClientModuleClassLoader;

    static AppClientDeployerHelper newInstance(DeploymentContext dc, AppClientArchivist archivist, ClassLoader gfClientModuleLoader) throws IOException {
        ApplicationClientDescriptor bundleDesc = (ApplicationClientDescriptor)dc.getModuleMetaData(ApplicationClientDescriptor.class);
        Application application = bundleDesc.getApplication();
        boolean insideEar = !application.isVirtual();
        return insideEar ? new NestedAppClientDeployerHelper(dc, bundleDesc, archivist, gfClientModuleLoader) : new StandaloneAppClientDeployerHelper(dc, bundleDesc, archivist, gfClientModuleLoader);
    }

    protected AppClientDeployerHelper(DeploymentContext dc, ApplicationClientDescriptor bundleDesc, AppClientArchivist archivist, ClassLoader gfClientModuleClassLoader) throws IOException {
        this.dc = dc;
        this.appClientDesc = bundleDesc;
        this.archivist = archivist;
        this.gfClientModuleClassLoader = gfClientModuleClassLoader;
    }

    protected abstract URI facadeServerURI(DeploymentContext var1);

    protected abstract URI facadeUserURI(DeploymentContext var1);

    protected abstract String facadeFileNameAndType(DeploymentContext var1);

    protected abstract URI appClientUserURI(DeploymentContext var1);

    protected abstract URI appClientUserURIForFacade(DeploymentContext var1);

    protected abstract URI appClientServerURI(DeploymentContext var1);

    protected abstract URI appClientURIWithinApp(DeploymentContext var1);

    protected abstract String facadeClassPath();

    protected final DeploymentContext dc() {
        return this.dc;
    }

    protected ApplicationClientDescriptor appClientDesc() {
        return this.appClientDesc;
    }

    File JAROfExpandedSubmodule(URI candidateSubmoduleURI) throws IOException {
        FileArchive source = new FileArchive();
        source.open(this.dc().getSource().getParentArchive().getURI().resolve(this.expandedDirURI(candidateSubmoduleURI)));
        OutputJarArchive target = new OutputJarArchive();
        target.create(this.dc().getScratchDir("xml").toURI().resolve(candidateSubmoduleURI));
        Manifest mf = source.getManifest();
        OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
        mf.write(os);
        target.closeEntry();
        ClientJarMakerUtils.copyArchive((ReadableArchive)source, (WritableArchive)target, Collections.EMPTY_SET);
        target.close();
        return new File(target.getURI());
    }

    private URI expandedDirURI(URI submoduleURI) {
        String uriText = submoduleURI.toString();
        int lastDot = uriText.lastIndexOf(46);
        return URI.create(uriText.substring(0, lastDot) + "_" + uriText.substring(lastDot + 1));
    }

    private void initGeneratedManifest(Manifest sourceManifest, Manifest generatedManifest, String classPath) {
        Attributes sourceMainAttrs = sourceManifest.getMainAttributes();
        Attributes facadeMainAttrs = generatedManifest.getMainAttributes();
        facadeMainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        facadeMainAttrs.put(Attributes.Name.MAIN_CLASS, "org.glassfish.appclient.client.AppClientFacade");
        facadeMainAttrs.put(AppClientDeployer.GLASSFISH_APPCLIENT_MAIN_CLASS, sourceMainAttrs.getValue(Attributes.Name.MAIN_CLASS));
        facadeMainAttrs.put(AppClientDeployer.GLASSFISH_APPCLIENT, this.appClientUserURIForFacade(this.dc).toASCIIString());
        String splash = sourceMainAttrs.getValue(AppClientDeployer.SPLASH_SCREEN_IMAGE);
        if (splash != null) {
            facadeMainAttrs.put(AppClientDeployer.SPLASH_SCREEN_IMAGE, splash);
        }
        facadeMainAttrs.put(Attributes.Name.CLASS_PATH, classPath);
    }

    private void writeUpdatedDescriptors(OutputJarArchive facadeArchive, ApplicationClientDescriptor acd) throws IOException {
        this.archivist.setDescriptor((RootDeploymentDescriptor)acd);
        this.archivist.writeDeploymentDescriptors((WritableArchive)facadeArchive);
    }

    protected void prepareJARs() throws IOException, URISyntaxException {
        this.generateAppClientFacade();
    }

    protected final void generateAppClientFacade() throws IOException, URISyntaxException {
        OutputJarArchive facadeArchive = new OutputJarArchive();
        facadeArchive.create(this.facadeServerURI(this.dc));
        ReadableArchive source = this.dc.getSource();
        Manifest sourceManifest = source.getManifest();
        Manifest facadeManifest = facadeArchive.getManifest();
        this.initGeneratedManifest(sourceManifest, facadeManifest, this.facadeClassPath());
        String splash = sourceManifest.getMainAttributes().getValue(AppClientDeployer.SPLASH_SCREEN_IMAGE);
        if (splash != null) {
            ClientJarMakerUtils.copy(source, (WritableArchive)facadeArchive, splash);
        }
        OutputStream os = facadeArchive.putNextEntry("META-INF/MANIFEST.MF");
        facadeManifest.write(os);
        facadeArchive.closeEntry();
        this.writeUpdatedDescriptors(facadeArchive, this.appClientDesc);
        this.copyPersistenceUnitXML(source, (WritableArchive)facadeArchive);
        this.copyMainClass((WritableArchive)facadeArchive);
        facadeArchive.close();
    }

    private void copyMainClass(WritableArchive facadeArchive) throws IOException {
        OutputStream os = facadeArchive.putNextEntry("org/glassfish/appclient/client/AppClientFacade.class");
        InputStream is = this.openByteCodeStream("/org/glassfish/appclient/client/AppClientFacade.class");
        AppClientDeployerHelper.copyStream(is, os);
        try {
            is.close();
            facadeArchive.closeEntry();
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private void copyPersistenceUnitXML(ReadableArchive sourceClient, WritableArchive facadeArchive) throws IOException {
        InputStream persistenceXMLStream = sourceClient.getEntry(PERSISTENCE_XML_PATH);
        if (persistenceXMLStream != null) {
            OutputStream os = facadeArchive.putNextEntry(PERSISTENCE_XML_PATH);
            AppClientDeployerHelper.copyStream(persistenceXMLStream, os);
            try {
                persistenceXMLStream.close();
                facadeArchive.closeEntry();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    protected InputStream openByteCodeStream(String resourceName) throws IOException {
        URL url = this.gfClientModuleClassLoader.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException(resourceName);
        }
        InputStream is = url.openStream();
        return is;
    }

    protected abstract Set<DownloadableArtifacts.FullAndPartURIs> downloads() throws IOException;

    static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    Proxy proxy() {
        return new Proxy(this);
    }

    public static class Proxy {
        private final AppClientDeployerHelper helper;

        public Proxy(AppClientDeployerHelper helper) {
            this.helper = helper;
        }

        public AppClientDeployerHelper helper() {
            return this.helper;
        }
    }
}

