/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.grizzly.tcp.Adapter;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployer;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.AppClientHTTPAdapter;
import org.glassfish.appclient.server.core.jws.JavaWebStartState;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientServerApplication
implements ApplicationContainer<ApplicationClientDescriptor>,
ConfigListener {
    private final DeploymentContext dc;
    private final AppClientDeployer deployer;
    private final Logger logger;
    private final AppClientDeployerHelper helper;
    private final boolean isJWSEligible;
    private volatile boolean isJWSEnabledAtApp = true;
    private volatile boolean isJWSEnabledAtModule = true;
    private final JavaWebStartState jwsState = new JavaWebStartState();
    private static final String JAVA_WEB_START_ENABLED_PROPERTY_NAME = "java-web-start-enabled";
    private final RequestDispatcher requestDispatcher;
    private final ApplicationClientDescriptor acDesc;
    private final Application appDesc;
    private final Applications applications;
    private AppClientHTTPAdapter clientAdapter;

    AppClientServerApplication(DeploymentContext dc, AppClientDeployer deployer, AppClientDeployerHelper helper, RequestDispatcher requestDispatcher, Applications applications, Logger logger) {
        this.dc = dc;
        this.deployer = deployer;
        this.helper = helper;
        this.logger = logger;
        this.requestDispatcher = requestDispatcher;
        this.acDesc = helper.appClientDesc();
        this.isJWSEligible = this.acDesc.getJavaWebStartAccessDescriptor().isEligible();
        this.isJWSEnabledAtApp = this.isJWSEnabled(dc.getAppProps());
        this.isJWSEnabledAtModule = this.isJWSEnabled(dc.getModuleProps());
        this.appDesc = this.acDesc.getApplication();
        this.applications = applications;
    }

    public ApplicationClientDescriptor getDescriptor() {
        return this.acDesc;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        return this.start();
    }

    boolean start() {
        if (this.isJWSRunnable()) {
            this.jwsState.transition(JavaWebStartState.Action.START, new Runnable(){

                public void run() {
                    try {
                        AppClientServerApplication.this.startJWSServices();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        return this.stop();
    }

    boolean stop() {
        this.jwsState.transition(JavaWebStartState.Action.STOP, new Runnable(){

            public void run() {
                try {
                    AppClientServerApplication.this.stopJWSServices();
                }
                catch (EndpointRegistrationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return true;
    }

    public boolean suspend() {
        this.jwsState.transition(JavaWebStartState.Action.SUSPEND, new Runnable(){

            public void run() {
                AppClientServerApplication.this.suspendJWSServices();
            }
        });
        return true;
    }

    public boolean resume() throws Exception {
        if (this.isJWSRunnable()) {
            this.jwsState.transition(JavaWebStartState.Action.RESUME, new Runnable(){

                public void run() {
                    AppClientServerApplication.this.resumeJWSServices();
                }
            });
        }
        return true;
    }

    public ClassLoader getClassLoader() {
        return new URLClassLoader(new URL[0]);
    }

    private void startJWSServices() throws EndpointRegistrationException, IOException {
        if (this.clientAdapter == null) {
            this.clientAdapter = this.initAdapter();
        }
        this.requestDispatcher.registerEndpoint(this.clientContextRoot(), (Adapter)this.clientAdapter, (ApplicationContainer)this);
        this.logger.log(Level.INFO, "enterprise.deployment.appclient.jws.started", new Object[]{this.moduleExpression(), this.clientContextRoot()});
    }

    private void stopJWSServices() throws EndpointRegistrationException {
        this.requestDispatcher.unregisterEndpoint(this.clientContextRoot());
        this.logger.log(Level.INFO, "enterprise.deployment.appclient.jws.stopped", this.moduleExpression());
    }

    private void suspendJWSServices() {
        if (this.clientAdapter != null) {
            this.clientAdapter.suspend();
        }
    }

    private void resumeJWSServices() {
        if (this.clientAdapter != null) {
            this.clientAdapter.resume();
        }
    }

    private AppClientHTTPAdapter initAdapter() throws IOException {
        HashMap<String, StaticContent> staticContent = new HashMap<String, StaticContent>();
        staticContent.put(this.clientContextRoot() + "/VirtualFile", new FixedContent(new File("/Users/Tim/asgroup/sampleOutput.html")));
        HashMap<String, AppClientHTTPAdapter.DynamicContent> dynamicContent = new HashMap<String, AppClientHTTPAdapter.DynamicContent>();
        dynamicContent.put(this.clientContextRoot() + "/VirtualDyn.html", new AppClientHTTPAdapter.DynamicContent("<html><body>This is running from app ${my.app} which was loaded at ${when}!</body></html>", new Date()));
        Properties tokens = new Properties();
        tokens.setProperty("my.app", this.clientContextRoot());
        tokens.setProperty("when", new Date().toString());
        return new AppClientHTTPAdapter(staticContent, dynamicContent, tokens);
    }

    private boolean isJWSEnabled(Properties props) {
        boolean result = true;
        String propsSetting = props.getProperty(JAVA_WEB_START_ENABLED_PROPERTY_NAME);
        if (propsSetting != null) {
            result &= Boolean.parseBoolean(propsSetting);
        }
        return result;
    }

    private boolean isJWSEnabled() {
        return this.isJWSEnabledAtApp && this.isJWSEnabledAtModule;
    }

    private boolean isJWSRunnable() {
        if (!this.isJWSEligible) {
            this.logger.log(Level.INFO, "enterprise.deployment.appclient.jws.noStart.ineligible", this.moduleExpression());
        }
        if (!this.isJWSEnabled()) {
            this.logger.log(Level.INFO, "enterprise.deployment.appclient.jws.noStart.disabled", this.moduleExpression());
        }
        return this.isJWSEligible && this.isJWSEnabled();
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unprocessedEvents = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent event : events) {
            try {
                this.processChangeEventIfInteresting(event);
            }
            catch (Exception e) {
                UnprocessedChangeEvent uce = new UnprocessedChangeEvent(event, e.getLocalizedMessage());
                unprocessedEvents.add(uce);
            }
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }

    private void processChangeEventIfInteresting(PropertyChangeEvent event) throws EndpointRegistrationException {
        Boolean oldEnabledValue;
        String thisAppOrModuleName;
        String eventSourceName;
        boolean isSourceApp = event.getSource() instanceof com.sun.enterprise.config.serverbeans.Application;
        boolean isSourceModule = event.getSource() instanceof Module;
        if (!isSourceApp && !isSourceModule || !(event.getNewValue() instanceof Property)) {
            return;
        }
        Property newPropertySetting = (Property)event.getNewValue();
        if (!newPropertySetting.getName().equals(JAVA_WEB_START_ENABLED_PROPERTY_NAME)) {
            return;
        }
        if (isSourceApp) {
            eventSourceName = ((com.sun.enterprise.config.serverbeans.Application)event.getSource()).getName();
            thisAppOrModuleName = this.appDesc.getRegistrationName();
        } else {
            eventSourceName = ((Module)event.getSource()).getName();
            thisAppOrModuleName = this.acDesc.getModuleName();
        }
        if (!thisAppOrModuleName.equals(eventSourceName)) {
            return;
        }
        Boolean newEnabledValue = Boolean.valueOf(newPropertySetting.getValue());
        Property oldPropertySetting = (Property)event.getOldValue();
        String oldPropertyValue = oldPropertySetting != null ? oldPropertySetting.getValue() : null;
        Boolean bl = oldEnabledValue = oldPropertyValue == null ? Boolean.TRUE : Boolean.valueOf(oldPropertyValue);
        if (isSourceApp) {
            this.isJWSEnabledAtApp = newEnabledValue;
        } else {
            this.isJWSEnabledAtModule = newEnabledValue;
        }
        if (!newEnabledValue.equals(oldEnabledValue)) {
            if (newEnabledValue.booleanValue()) {
                this.start();
            } else {
                this.stop();
            }
        }
    }

    private String clientContextRoot() {
        String contextRootInDesc = this.developerSpecifiedContextRoot();
        String contextRoot = contextRootInDesc != null && !contextRootInDesc.equals("") ? contextRootInDesc : this.moduleExpression();
        return "/" + contextRoot;
    }

    private String moduleExpression() {
        String moduleExpression = this.appDesc.isVirtual() ? this.appDesc.getRegistrationName() : this.appDesc.getRegistrationName() + "/" + this.acDesc.getModuleName();
        return moduleExpression;
    }

    private String developerSpecifiedContextRoot() {
        return this.acDesc.getJavaWebStartAccessDescriptor().getContextRoot();
    }
}

