/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.http.MimeType;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.appclient.server.core.jws.RestrictedContentAdapter;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientHTTPAdapter
extends RestrictedContentAdapter {
    private static final String LAST_MODIFIED_HEADER_NAME = "Last-Modified";
    private static final String DATE_HEADER_NAME = "Date";
    private Logger jwsLogger = LogDomains.getLogger(((Object)((Object)this)).getClass(), (String)"javax.enterprise.system.container.appclient");
    private final Map<String, DynamicContent> dynamicContent;
    private final Properties tokens;

    public AppClientHTTPAdapter(Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens) throws IOException {
        super(staticContent);
        this.dynamicContent = dynamicContent;
        this.tokens = tokens;
    }

    @Override
    public void service(GrizzlyRequest gReq, GrizzlyResponse gResp) {
        if (!this.serviceContent(gReq, gResp)) {
            String uriString = gReq.getRequestURI();
            if (this.dynamicContent.containsKey(uriString)) {
                this.processDynamicContent(this.tokens, uriString, gReq, gResp);
            } else {
                this.respondNotFound(gResp);
            }
        }
    }

    private void processDynamicContent(Properties tokens, String uriString, GrizzlyRequest gReq, GrizzlyResponse gResp) {
        DynamicContent dc = this.dynamicContent.get(uriString);
        String rawContent = dc.content();
        if (rawContent == null) {
            gResp.getResponse().setStatus(404);
            return;
        }
        Date instanceTimestamp = dc.timestamp();
        gResp.setDateHeader(LAST_MODIFIED_HEADER_NAME, instanceTimestamp.getTime());
        gResp.setDateHeader(DATE_HEADER_NAME, System.currentTimeMillis());
        gResp.setContentType(this.mimeType(uriString));
        gResp.setStatus(200);
        String methodType = gReq.getMethod();
        if (methodType.equalsIgnoreCase("GET")) {
            String processedContent = Util.replaceTokens(rawContent, tokens);
            this.writeData(uriString, processedContent.toString(), gReq, gResp);
        }
        try {
            gResp.finishResponse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeData(String uri, String data, GrizzlyRequest req, GrizzlyResponse res) {
        try {
            res.setStatus(200);
            res.setContentLength(data.length());
            res.getResponse().sendHeaders();
            PrintWriter pw = res.getWriter();
            pw.println(data);
            pw.flush();
        }
        catch (Exception e) {
            res.setStatus(500);
            res.getResponse().setErrorException(e);
            return;
        }
    }

    private String mimeType(String uri) {
        int dot = uri.lastIndexOf(".");
        if (dot > 0) {
            String ext = uri.substring(dot + 1);
            String ct = MimeType.get((String)ext);
            if (ct != null) {
                return ct;
            }
        } else {
            return MimeType.get((String)"html");
        }
        return "";
    }

    public static class DynamicContent {
        private final String content;
        private final Date timestamp;

        public DynamicContent(String content, Date timestamp) {
            this.content = content;
            this.timestamp = timestamp;
        }

        public String content() {
            return this.content;
        }

        public Date timestamp() {
            return this.timestamp;
        }
    }
}

