/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedContentAdapter
extends GrizzlyAdapter {
    private final Logger logger = LogDomains.getLogger(RestrictedContentAdapter.class, (String)"javax.enterprise.system.container.appclient");
    private volatile State state = State.RESUMED;
    private final Map<String, StaticContent> content;

    public RestrictedContentAdapter(Map<String, StaticContent> content) throws IOException {
        this.content = content;
        for (Map.Entry<String, StaticContent> sc : content.entrySet()) {
            this.cache.put(sc.getKey(), sc.getValue().file());
        }
        this.setHandleStaticResources(false);
        this.setUseSendFile(true);
        this.commitErrorResponse = true;
    }

    public void service(GrizzlyRequest gReq, GrizzlyResponse gResp) {
        if (!this.serviceContent(gReq, gResp)) {
            this.respondNotFound(gResp);
        }
    }

    protected boolean serviceContent(GrizzlyRequest gReq, GrizzlyResponse gResp) {
        if (this.state == State.SUSPENDED) {
            gResp.getResponse().setStatus(403);
            return true;
        }
        String uriString = gReq.getRequestURI();
        if (this.content.containsKey(uriString)) {
            this.processContent(uriString, gReq, gResp);
            return true;
        }
        return false;
    }

    private void processContent(String uriString, GrizzlyRequest gReq, GrizzlyResponse gResp) {
        try {
            super.service(uriString, gReq.getRequest(), gResp.getResponse());
            this.finishResponse(gResp, 200);
        }
        catch (Exception e) {
            gResp.getResponse().setErrorException(e);
            this.finishResponse(gResp, 500);
        }
    }

    public void suspend() {
        this.state = State.SUSPENDED;
    }

    public void resume() {
        this.state = State.RESUMED;
    }

    public String toString() {
        return this.content.toString();
    }

    protected void finishResponse(GrizzlyResponse gResp, int status) {
        gResp.setStatus(status);
        try {
            gResp.finishResponse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void respondNotFound(GrizzlyResponse gResp) {
        this.finishErrorResponse(gResp, 404);
    }

    protected void finishErrorResponse(GrizzlyResponse gResp, int status) {
        gResp.setStatus(status);
        try {
            if (this.commitErrorResponse) {
                this.customizedErrorPage(gResp.getRequest().getRequest(), gResp.getResponse());
            }
            gResp.finishResponse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RESUMED,
        SUSPENDED;

    }
}

