/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.util.LinkedList;
import java.util.Properties;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;

public class DynamicContentImpl
implements DynamicContent {
    private static final int MAX_INSTANCES = 4;
    protected static final String ALL_PERMISSIONS_JNLP_SETTING = "<security><all-permissions/></security>";
    protected static final String NO_PERMISSIONS_JNLP_SETTING = "";
    private String template;
    protected String mimeType;
    private final LinkedList<DynamicContent.Instance> instances = new LinkedList();
    private boolean requiresElevatedPermissions;

    public DynamicContentImpl(String template, String mimeType) {
        this(template, mimeType, false);
    }

    public DynamicContentImpl(String template, String mimeType, boolean requiresElevatedPermissions) {
        this.template = template;
        this.mimeType = mimeType;
        this.requiresElevatedPermissions = requiresElevatedPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicContent.Instance getInstance(Properties tokenValues, boolean createIfAbsent) {
        DynamicContent.Instance result = null;
        String textWithPlaceholdersReplaced = Util.replaceTokens(this.template, tokenValues);
        LinkedList<DynamicContent.Instance> linkedList = this.instances;
        synchronized (linkedList) {
            for (DynamicContent.Instance i : this.instances) {
                if (!i.getText().equals(textWithPlaceholdersReplaced)) continue;
                result = i;
                break;
            }
            if (result == null && createIfAbsent) {
                result = new DynamicContent.InstanceAdapter(textWithPlaceholdersReplaced);
                this.addInstance(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstance(DynamicContent.Instance newInstance) {
        LinkedList<DynamicContent.Instance> linkedList = this.instances;
        synchronized (linkedList) {
            this.instances.addFirst(newInstance);
            if (this.instances.size() > 4) {
                this.instances.removeLast();
            }
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getJNLPSecuritySetting() {
        return this.requiresElevatedPermissions ? ALL_PERMISSIONS_JNLP_SETTING : NO_PERMISSIONS_JNLP_SETTING;
    }

    public boolean requiresElevatedPermissions() {
        return this.requiresElevatedPermissions;
    }

    protected void clearInstances() {
        this.instances.clear();
    }

    public String toString() {
        return super.toString() + ", template=" + this.template + ", MIME type=" + this.mimeType;
    }
}

