/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.ACCModulesManager;
import org.glassfish.appclient.client.acc.FacadeLaunchable;
import org.glassfish.appclient.client.acc.JWSFacadeLaunchable;
import org.glassfish.appclient.client.acc.MainClassLaunchable;
import org.glassfish.appclient.client.acc.UndeployedLaunchable;
import org.glassfish.appclient.client.acc.UserError;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

interface Launchable {
    public Class getMainClass() throws ClassNotFoundException;

    public ApplicationClientDescriptor getDescriptor(ClassLoader var1) throws IOException, SAXParseException;

    public void validateDescriptor();

    public URI getURI();

    public String getAnchorDir();

    public static class LaunchableUtil {
        private static final LocalStringManager localStrings = new LocalStringManagerImpl(LaunchableUtil.class);

        static Launchable newLaunchable(URI uri, String callerSuppliedMainClassName, String callerSuppliedAppName, Habitat habitat) throws IOException, BootException, URISyntaxException, XMLStreamException, SAXParseException, UserError {
            ArchiveFactory af = ACCModulesManager.getComponent(ArchiveFactory.class);
            ReadableArchive ra = null;
            try {
                ra = af.openArchive(uri);
            }
            catch (IOException e) {
                String msg = localStrings.getLocalString(Launchable.class, "appclient.cannotFindJarFile", "Could not locate the requested client JAR file {0}; please try again with an existing, valid client JAR", new Object[]{uri});
                throw new UserError(msg);
            }
            Launchable result = FacadeLaunchable.newFacade(habitat, ra, callerSuppliedMainClassName, callerSuppliedAppName);
            if (result != null) {
                ra.close();
            } else {
                result = UndeployedLaunchable.newUndeployedLaunchable(habitat, ra, callerSuppliedMainClassName, callerSuppliedAppName, Thread.currentThread().getContextClassLoader());
            }
            if (result != null) {
                if (!(result instanceof JWSFacadeLaunchable)) {
                    URL clientOrFacadeURL = new URL("file:" + result.getURI().getSchemeSpecificPart());
                    ACCClassLoader.instance().appendURL(clientOrFacadeURL);
                }
                return result;
            }
            String msg = localStrings.getLocalString(Launchable.class, "appclient.invalidArchive", "The location {0} could not be opened as an archive; an app client or an enterprise app was expected", new Object[]{uri});
            throw new UserError(msg);
        }

        static Launchable newLaunchable(Habitat habitat, Class mainClass) {
            return new MainClassLaunchable(habitat, mainClass);
        }

        static boolean matchesMainClassName(ReadableArchive archive, String callerSpecifiedMainClassName) throws IOException {
            return callerSpecifiedMainClassName != null && archive.exists(LaunchableUtil.classNameToArchivePath(callerSpecifiedMainClassName));
        }

        static String moduleID(URI groupFacadeURI, URI clientURI, ApplicationClientDescriptor clientFacadeDescriptor) {
            String moduleID = clientFacadeDescriptor.getModuleID();
            if (moduleID.endsWith(".jar")) {
                moduleID = LaunchableUtil.deriveModuleID(groupFacadeURI, clientURI);
            }
            return moduleID;
        }

        static boolean matchesName(String moduleID, URI groupFacadeURI, ApplicationClientDescriptor clientFacadeDescriptor, String appClientName) throws IOException, SAXParseException {
            String displayName = clientFacadeDescriptor.getDisplayName();
            return moduleID != null && moduleID.equals(appClientName) || displayName != null && displayName.equals(appClientName);
        }

        private static String classNameToArchivePath(String className) {
            return className.replace('.', '/') + ".class";
        }

        private static String deriveModuleID(URI groupFacadeURI, URI clientArchiveURI) {
            URI dirURI = LaunchableUtil.stripDotJar(groupFacadeURI);
            URI clientArchiveRelativeURI = LaunchableUtil.stripDotJar(dirURI.relativize(URI.create("file:" + clientArchiveURI.getRawSchemeSpecificPart())));
            return clientArchiveRelativeURI.getRawSchemeSpecificPart();
        }

        private static URI stripDotJar(URI uri) {
            String pathWithoutDotJar = uri.getRawSchemeSpecificPart();
            pathWithoutDotJar = pathWithoutDotJar.substring(0, pathWithoutDotJar.length() - ".jar".length());
            return URI.create("file:" + pathWithoutDotJar);
        }
    }
}

