/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.appclient.server.core.jws.servedcontent.Content;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedContentAdapter
extends GrizzlyAdapter {
    protected static final String LAST_MODIFIED_HEADER_NAME = "Last-Modified";
    protected static final String DATE_HEADER_NAME = "Date";
    protected static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final Logger logger = LogDomains.getLogger(RestrictedContentAdapter.class, (String)"javax.enterprise.system.container.appclient");
    private volatile State state = State.RESUMED;
    private final String contextRoot;
    private final String userFriendlyContextRoot;
    private final ConcurrentHashMap<String, StaticContent> content = new ConcurrentHashMap();

    public RestrictedContentAdapter(String contextRoot, String userFriendlyContextRoot, Map<String, StaticContent> content) throws IOException {
        this(contextRoot, userFriendlyContextRoot);
        this.content.putAll(content);
        for (Map.Entry<String, StaticContent> sc : content.entrySet()) {
            this.cache.put(sc.getKey(), sc.getValue().file());
        }
        this.logger.fine(this.logPrefix() + "Initial static content loaded " + this.dumpContent());
    }

    public RestrictedContentAdapter(String contextRoot, String userFriendlyContextRoot) {
        this.contextRoot = contextRoot;
        this.userFriendlyContextRoot = userFriendlyContextRoot;
        this.setHandleStaticResources(false);
        this.setUseSendFile(false);
        this.commitErrorResponse = true;
    }

    public void service(GrizzlyRequest gReq, GrizzlyResponse gResp) {
        if (!this.serviceContent(gReq, gResp)) {
            this.respondNotFound(gResp);
        }
    }

    public String contextRoot() {
        return this.contextRoot;
    }

    public String userFriendlyContextRoot() {
        return this.userFriendlyContextRoot;
    }

    public synchronized void addContentIfAbsent(String relativeURIString, StaticContent newContent) throws IOException {
        StaticContent existingContent = this.content.get(relativeURIString);
        if (existingContent != null) {
            if (!existingContent.equals(newContent)) {
                this.logger.log(Level.WARNING, "enterprise.deployment.appclient.jws.staticContentCollision", new Object[]{relativeURIString, newContent.toString()});
            }
            return;
        }
        this.content.put(relativeURIString, newContent);
        this.cache.put(relativeURIString, newContent.file());
        this.logger.fine(this.logPrefix() + "adding static content " + relativeURIString + " " + newContent.toString());
    }

    public synchronized void addContentIfAbsent(Map<String, StaticContent> staticContent) throws IOException {
        for (Map.Entry<String, StaticContent> entry : staticContent.entrySet()) {
            this.addContentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    protected String relativizeURIString(String uriString) {
        String result = this.relativizeURIString(this.contextRoot, uriString);
        if (result == null && (result = this.relativizeURIString(this.userFriendlyContextRoot, uriString)) == null) {
            this.logger.log(Level.WARNING, "enterprise.deployment.appclient.jws.uriOutsideContextRoot", new Object[]{uriString, this.contextRoot, this.userFriendlyContextRoot});
            return null;
        }
        return result;
    }

    protected String relativizeURIString(String candidateContextRoot, String uriString) {
        if (!uriString.startsWith(candidateContextRoot)) {
            return null;
        }
        if (candidateContextRoot.equals(uriString)) {
            return "";
        }
        return uriString.substring(candidateContextRoot.length() + 1);
    }

    protected boolean serviceContent(GrizzlyRequest gReq, GrizzlyResponse gResp) {
        String relativeURIString = this.relativizeURIString(gReq.getRequestURI());
        if (this.state == State.SUSPENDED) {
            this.finishErrorResponse(gResp, 403);
            this.logger.fine(this.logPrefix() + "is suspended; refused to serve static content requested using " + (relativeURIString == null ? "null" : relativeURIString));
            return true;
        }
        if (relativeURIString == null) {
            this.logger.fine(this.logPrefix() + "Could not find static content requested using full request URI = " + gReq.getRequestURI() + " - relativized URI was null");
            this.respondNotFound(gResp);
            return true;
        }
        StaticContent sc = this.content.get(relativeURIString);
        if (sc != null && sc.isAvailable()) {
            this.processContent(relativeURIString, gReq, gResp);
            return true;
        }
        this.finishErrorResponse(gResp, this.contentStateToResponseStatus(sc));
        String scString = sc == null ? "null" : sc.toString();
        String scStateString = sc == null ? "null" : sc.state().toString();
        this.logger.fine(this.logPrefix() + "Found static content for " + gReq.getMethod() + ": " + relativeURIString + " -> " + scString + " but could not serve it; its state is " + scStateString);
        return true;
    }

    private void processContent(String relativeURIString, GrizzlyRequest gReq, GrizzlyResponse gResp) {
        try {
            StaticContent sc = this.content.get(relativeURIString);
            File fileToSend = sc.file();
            if (fileToSend != null) {
                if (this.returnIfClientCacheIsCurrent(relativeURIString, gReq, fileToSend.lastModified())) {
                    return;
                }
                gResp.addDateHeader(LAST_MODIFIED_HEADER_NAME, fileToSend.lastModified());
                gResp.addDateHeader(DATE_HEADER_NAME, System.currentTimeMillis());
            }
            super.service(relativeURIString, gReq.getRequest(), gResp.getResponse());
            int status = gResp.getStatus();
            if (status != 200) {
                this.logger.fine(this.logPrefix() + "Could not serve content for " + relativeURIString + " - status = " + status);
            } else {
                this.logger.fine(this.logPrefix() + "Served static content for " + gReq.getMethod() + ":" + sc.toString());
            }
            this.finishResponse(gResp, status);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, this.logPrefix() + relativeURIString, e);
        }
    }

    protected boolean returnIfClientCacheIsCurrent(String relativeURIString, GrizzlyRequest gReq, long contentTimestamp) {
        long ifModifiedSinceTime = gReq.getDateHeader(IF_MODIFIED_SINCE);
        boolean result = ifModifiedSinceTime != -1L && ifModifiedSinceTime >= contentTimestamp;
        if (result) {
            this.finishSuccessResponse(gReq.getResponse(), 304);
            this.logger.fine(this.logPrefix() + relativeURIString + " is already current on the client; no downloaded needed");
        }
        return result;
    }

    protected int contentStateToResponseStatus(Content content) {
        int status = content == null ? 404 : (content.isAvailable() ? 200 : (content.state() == Content.State.SUSPENDED ? 403 : 404));
        return status;
    }

    public void suspend() {
        this.state = State.SUSPENDED;
    }

    public void resume() {
        this.state = State.RESUMED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.logPrefix()).append(LINE_SEP);
        for (Map.Entry<String, StaticContent> entry : this.content.entrySet()) {
            sb.append("  ").append(entry.toString()).append(LINE_SEP);
        }
        return sb.toString();
    }

    protected void finishResponse(GrizzlyResponse gResp, int status) {
        gResp.setStatus(status);
        try {
            gResp.finishResponse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void respondNotFound(GrizzlyResponse gResp) {
        this.finishErrorResponse(gResp, 404);
    }

    protected void finishSuccessResponse(GrizzlyResponse gResp, int status) {
        this.finishResponse(gResp, status, false);
    }

    private void finishResponse(GrizzlyResponse gResp, int status, boolean treatAsError) {
        gResp.setStatus(status);
        try {
            if (treatAsError && this.commitErrorResponse) {
                this.customizedErrorPage(gResp.getRequest().getRequest(), gResp.getResponse());
            }
            gResp.finishResponse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void finishErrorResponse(GrizzlyResponse gResp, int status) {
        this.finishResponse(gResp, status, true);
    }

    protected String dumpContent() {
        if (this.content == null) {
            return "  Static content: not initialized";
        }
        if (this.content.isEmpty()) {
            return "  Static content: empty" + LINE_SEP;
        }
        StringBuilder sb = new StringBuilder(LINE_SEP).append("  Static content");
        for (Map.Entry<String, StaticContent> entry : this.content.entrySet()) {
            sb.append("  ").append(entry.getKey()).append(" : ").append(entry.getValue().toString()).append(LINE_SEP);
        }
        sb.append(LINE_SEP).append("  ========");
        return sb.toString();
    }

    protected String logPrefix() {
        return "Adapter[" + this.contextRoot + "] ";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RESUMED,
        SUSPENDED;

    }
}

