/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.ACCAppClientArchivist;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCModulesManager;
import org.glassfish.appclient.client.acc.HTTPInputArchive;
import org.glassfish.appclient.client.acc.JWSFacadeLaunchable;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.UserError;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

public class FacadeLaunchable
implements Launchable {
    public static final Attributes.Name GLASSFISH_APPCLIENT_GROUP = new Attributes.Name("GlassFish-AppClient-Group");
    public static final Attributes.Name GLASSFISH_APPCLIENT_MAIN_CLASS = new Attributes.Name("Glassfish-AppClient-Main-Class");
    public static final Attributes.Name GLASSFISH_APPCLIENT = new Attributes.Name("GlassFish-AppClient");
    public static final Attributes.Name GLASSFISH_APP_NAME = new Attributes.Name("GlassFish-App-Name");
    public static final ArchiveFactory archiveFactory = ACCModulesManager.getComponent(ArchiveFactory.class);
    private static final Logger logger = Logger.getLogger(FacadeLaunchable.class.getName());
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(FacadeLaunchable.class);
    private final String mainClassNameToLaunch;
    private final URI[] classPathURIs;
    private final ReadableArchive clientRA;
    private ReadableArchive facadeClientRA;
    private static AppClientArchivist facadeArchivist = null;
    private ApplicationClientDescriptor acDesc = null;
    private ClassLoader classLoader = null;
    private final Habitat habitat;
    private final String anchorDir;

    FacadeLaunchable(Habitat habitat, Attributes mainAttrs, ReadableArchive facadeRA, String anchorDir) throws IOException, URISyntaxException {
        this(habitat, facadeRA, mainAttrs, FacadeLaunchable.openOriginalArchive(facadeRA, mainAttrs.getValue(GLASSFISH_APPCLIENT)), mainAttrs.getValue(GLASSFISH_APPCLIENT_MAIN_CLASS), anchorDir);
    }

    private static ReadableArchive openOriginalArchive(ReadableArchive facadeArchive, String relativeURIToOriginalJar) throws IOException, URISyntaxException {
        URI uriToOriginal = facadeArchive.getURI().resolve(relativeURIToOriginalJar);
        return archiveFactory.openArchive(uriToOriginal);
    }

    FacadeLaunchable(Habitat habitat, ReadableArchive facadeClientRA, Attributes mainAttrs, ReadableArchive clientRA, String mainClassNameToLaunch, String anchorDir) throws IOException {
        this.facadeClientRA = facadeClientRA;
        this.mainClassNameToLaunch = mainClassNameToLaunch;
        this.clientRA = clientRA;
        this.classPathURIs = this.toURIs(mainAttrs.getValue(Attributes.Name.CLASS_PATH));
        this.habitat = habitat;
        this.anchorDir = anchorDir;
    }

    public URI getURI() {
        return this.facadeClientRA.getURI();
    }

    public String getAnchorDir() {
        return this.anchorDir;
    }

    protected URI[] toURIs(String uriList) {
        String[] uris = uriList.split(" ");
        URI[] result = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            result[i] = URI.create(uris[i]);
        }
        return result;
    }

    protected AppClientArchivist getFacadeArchivist() {
        return FacadeLaunchable.getFacadeArchivist(this.habitat);
    }

    protected static synchronized AppClientArchivist getFacadeArchivist(Habitat habitat) {
        if (facadeArchivist == null) {
            facadeArchivist = (AppClientArchivist)habitat.getComponent(ACCAppClientArchivist.class);
        }
        return facadeArchivist;
    }

    public void validateDescriptor() {
        this.getFacadeArchivist().validate(this.classLoader);
    }

    static FacadeLaunchable newFacade(Habitat habitat, ReadableArchive facadeRA, String callerSuppliedMainClassName, String callerSuppliedAppName) throws IOException, BootException, URISyntaxException, XMLStreamException, SAXParseException, UserError {
        Manifest mf = facadeRA.getManifest();
        Attributes mainAttrs = mf.getMainAttributes();
        FacadeLaunchable result = null;
        if (mainAttrs.containsKey(GLASSFISH_APPCLIENT)) {
            result = !(facadeRA instanceof HTTPInputArchive) ? new FacadeLaunchable(habitat, mainAttrs, facadeRA, FacadeLaunchable.dirContainingStandAloneFacade(facadeRA)) : new JWSFacadeLaunchable(habitat, mainAttrs, facadeRA);
        } else {
            String facadeGroupURIs = mainAttrs.getValue(GLASSFISH_APPCLIENT_GROUP);
            if (facadeGroupURIs != null) {
                result = FacadeLaunchable.selectFacadeFromGroup(habitat, facadeRA.getURI(), archiveFactory, facadeGroupURIs, callerSuppliedMainClassName, callerSuppliedAppName, FacadeLaunchable.dirContainingClientFacadeInGroup(facadeRA));
            } else {
                return null;
            }
        }
        return result;
    }

    private static String dirContainingStandAloneFacade(ReadableArchive facadeRA) throws URISyntaxException {
        URI fileURI = new URI("file", facadeRA.getURI().getRawSchemeSpecificPart(), null);
        return new File(fileURI).getParent();
    }

    private static String dirContainingClientFacadeInGroup(ReadableArchive groupFacadeRA) throws URISyntaxException {
        String ssp = groupFacadeRA.getURI().getRawSchemeSpecificPart();
        URI fileURI = new URI("file", ssp.substring(0, ssp.length() - ".jar".length()) + "/", null);
        return new File(fileURI).getAbsolutePath();
    }

    public Class getMainClass() throws ClassNotFoundException {
        return Class.forName(this.mainClassNameToLaunch, true, Thread.currentThread().getContextClassLoader());
    }

    public ApplicationClientDescriptor getDescriptor(ClassLoader loader) throws IOException, SAXParseException {
        if (this.acDesc == null) {
            this.acDesc = (ApplicationClientDescriptor)this.getFacadeArchivist().open(this.facadeClientRA);
            Application.createApplication((Habitat)this.habitat, null, (ModuleDescriptor)this.acDesc.getModuleDescriptor());
            Manifest facadeMF = this.facadeClientRA.getManifest();
            Attributes mainAttrs = facadeMF.getMainAttributes();
            String appName = mainAttrs.getValue(GLASSFISH_APP_NAME);
            this.acDesc.getApplication().setAppName(appName);
            this.getFacadeArchivist().setDescriptor((RootDeploymentDescriptor)this.acDesc);
            this.classLoader = loader;
        }
        return this.acDesc;
    }

    public URI[] getClassPathURIs() {
        return this.classPathURIs;
    }

    private static FacadeLaunchable selectFacadeFromGroup(Habitat habitat, URI groupFacadeURI, ArchiveFactory af, String groupURIs, String callerSpecifiedMainClassName, String callerSpecifiedAppClientName, String anchorDir) throws IOException, BootException, URISyntaxException, SAXParseException, UserError {
        String[] archiveURIs = groupURIs.split(" ");
        if (archiveURIs.length == 0) {
            String msg = localStrings.getLocalString(FacadeLaunchable.class, "appclient.noClientsInGroup", "No app clients are listed in the app client group {0}", new Object[]{groupFacadeURI});
            throw new UserError(msg);
        }
        ArrayList<String> knownClientNames = new ArrayList<String>();
        ArrayList<String> knownMainClasses = new ArrayList<String>();
        for (String uriText : archiveURIs) {
            URI clientFacadeURI = groupFacadeURI.resolve(uriText);
            ReadableArchive clientFacadeRA = af.openArchive(clientFacadeURI);
            Manifest facadeMF = clientFacadeRA.getManifest();
            Attributes facadeMainAttrs = facadeMF.getMainAttributes();
            URI clientURI = clientFacadeURI.resolve(facadeMF.getMainAttributes().getValue(GLASSFISH_APPCLIENT));
            ReadableArchive clientRA = af.openArchive(clientURI);
            AppClientArchivist facadeClientArchivist = FacadeLaunchable.getFacadeArchivist(habitat);
            ApplicationClientDescriptor facadeClientDescriptor = (ApplicationClientDescriptor)facadeClientArchivist.open(clientFacadeRA);
            String moduleID = Launchable.LaunchableUtil.moduleID(groupFacadeURI, clientURI, facadeClientDescriptor);
            Manifest clientMF = clientRA.getManifest();
            Attributes mainAttrs = clientMF.getMainAttributes();
            String clientMainClassName = mainAttrs.getValue(Attributes.Name.MAIN_CLASS);
            knownMainClasses.add(clientMainClassName);
            knownClientNames.add(moduleID);
            FacadeLaunchable facade = null;
            if (archiveURIs.length == 1) {
                facade = new FacadeLaunchable(habitat, clientFacadeRA, facadeMainAttrs, clientRA, facadeMainAttrs.getValue(GLASSFISH_APPCLIENT_MAIN_CLASS), anchorDir);
                if (callerSpecifiedMainClassName != null && !clientMainClassName.equals(callerSpecifiedMainClassName) || callerSpecifiedAppClientName != null && !Launchable.LaunchableUtil.matchesName(moduleID, groupFacadeURI, facadeClientDescriptor, callerSpecifiedAppClientName)) {
                    String msg = localStrings.getLocalString(FacadeLaunchable.class, "appclient.singleNestedClientNoMatch", "Using the only client {1} with main class {2} in {0} even though it does not match the specified main class name {3} or client name {4}", new Object[]{groupFacadeURI, ((Object)knownClientNames).toString(), ((Object)knownMainClasses).toString(), callerSpecifiedMainClassName, callerSpecifiedAppClientName});
                    logger.warning(msg);
                }
            } else if (Launchable.LaunchableUtil.matchesMainClassName(clientRA, callerSpecifiedMainClassName)) {
                facade = new FacadeLaunchable(habitat, clientFacadeRA, facadeMainAttrs, clientRA, callerSpecifiedMainClassName, anchorDir);
            } else if (Launchable.LaunchableUtil.matchesName(moduleID, groupFacadeURI, facadeClientDescriptor, callerSpecifiedAppClientName)) {
                facade = new FacadeLaunchable(habitat, clientFacadeRA, facadeMainAttrs, clientRA, clientMainClassName, anchorDir);
            }
            if (facade == null) continue;
            return facade;
        }
        String msg = callerSpecifiedAppClientName == null && callerSpecifiedMainClassName == null ? localStrings.getLocalString(FacadeLaunchable.class, "appclient.multClientsNoChoice", "The application contains multiple app clients; please choose one using -mainclass {0} or -name {1}", new Object[]{((Object)knownMainClasses).toString(), ((Object)knownClientNames).toString()}) : localStrings.getLocalString(FacadeLaunchable.class, "appclient.noMatchingClientInGroup", "No app client in the app client group {0} matches the main class name \"{1}\" or the app client name \"{2}\";\nPlease choose one using -mainclass {3} or -name {4}", new Object[]{groupFacadeURI, callerSpecifiedMainClassName, callerSpecifiedAppClientName, ((Object)knownMainClasses).toString(), ((Object)knownClientNames).toString()});
        throw new UserError(msg);
    }
}

