/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.runtime.JavaWebStartAccessDescriptor;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.grizzly.tcp.Adapter;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.appclient.server.core.AppClientContainerStarter;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.AppClientServerApplication;
import org.glassfish.appclient.server.core.StandaloneAppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.AppClientHTTPAdapter;
import org.glassfish.appclient.server.core.jws.NamingConventions;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.AutoSignedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.SimpleDynamicContentImpl;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class AppClientDeployer
extends JavaEEDeployer<AppClientContainerStarter, AppClientServerApplication>
implements PostConstruct,
ConfigListener {
    private Logger logger;
    public static final String APPCLIENT_FACADE_CLASS_FILE = "org/glassfish/appclient/client/AppClientFacade.class";
    public static final String APPCLIENT_AGENT_MAIN_CLASS_FILE = "org/glassfish/appclient/client/JWSAppClientContainerMain.class";
    public static final String APPCLIENT_COMMAND_CLASS_NAME = "org.glassfish.appclient.client.AppClientFacade";
    public static final Attributes.Name GLASSFISH_APPCLIENT_MAIN_CLASS = new Attributes.Name("GlassFish-AppClient-Main-Class");
    public static final Attributes.Name GLASSFISH_APPCLIENT = new Attributes.Name("GlassFish-AppClient");
    public static final Attributes.Name SPLASH_SCREEN_IMAGE = new Attributes.Name("SplashScreen-Image");
    public static final Attributes.Name GLASSFISH_APP_NAME = new Attributes.Name("GlassFish-App-Name");
    private static final String GF_CLIENT_MODULE_NAME = "org.glassfish.appclient.gf-client-module";
    public static final String HELPER_KEY_NAME = "org.glassfish.appclient.server.core.helper";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final List<String> DO_NOT_SERVE_LIST = Arrays.asList("glassfish/modules/jaxb-osgi.jar");
    private static final String JWS_SIGNED_SYSTEM_JARS_ROOT = "java-web-start/___system";
    private static final String JAVA_WEB_START_CONTEXT_ROOT_PROPERTY_NAME = "java-web-start-context-root";
    private final Map<String, AutoSignedContent> appLevelSignedSystemContent = new HashMap<String, AutoSignedContent>();
    @Inject
    protected Domain domain;
    @Inject
    private ServerContext serverContext;
    @Inject
    private DownloadableArtifacts downloadInfo;
    @Inject
    private ModulesRegistry modulesRegistry;
    @Inject
    private Applications applications;
    @Inject
    private RequestDispatcher requestDispatcher;
    @Inject
    private ASJarSigner jarSigner;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject(name="server-config")
    Config config;
    private IiopService iiopService;
    private ClassLoader gfClientModuleClassLoader;
    private AppClientHTTPAdapter systemAdapter = null;
    private final ConcurrentHashMap<String, Set<AppClientServerApplication>> contributingAppClients = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AppClientHTTPAdapter> httpAdapters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<String>> registeredContextRoots = new ConcurrentHashMap();
    private static final String DEFAULT_ALIAS = "s1as";
    private final Set<AppClientServerApplication> appClientApps = new HashSet<AppClientServerApplication>();
    private URI installRootURI;
    private URI umbrellaRootURI;
    private File umbrellaRoot;
    private File domainLevelSignedJARsRoot;

    protected String getModuleType() {
        return "appclient";
    }

    public void postConstruct() {
        this.logger = LogDomains.getLogger(AppClientDeployer.class, (String)"javax.enterprise.system.container.appclient");
        for (Module module : this.modulesRegistry.getModules(GF_CLIENT_MODULE_NAME)) {
            this.gfClientModuleClassLoader = module.getClassLoader();
        }
        this.installRootURI = this.serverContext.getInstallRoot().toURI();
        this.umbrellaRoot = new File(this.installRootURI).getParentFile();
        this.umbrellaRootURI = this.umbrellaRoot.toURI();
        this.domainLevelSignedJARsRoot = new File(this.serverEnv.getDomainRoot(), JWS_SIGNED_SYSTEM_JARS_ROOT);
        this.iiopService = this.config.getIiopService();
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public AppClientServerApplication load(AppClientContainerStarter containerStarter, DeploymentContext dc) {
        if (dc.getModuleMetaData(ApplicationClientDescriptor.class) == null) {
            return null;
        }
        AppClientDeployerHelper helper = this.savedHelper(dc);
        helper.addGroupFacadeToEARDownloads();
        AppClientServerApplication newACServerApp = new AppClientServerApplication(dc, this, helper, this.requestDispatcher, this.applications, this.jarSigner, this.logger);
        this.appClientApps.add(newACServerApp);
        return newACServerApp;
    }

    public void unload(AppClientServerApplication application, DeploymentContext dc) {
        this.appClientApps.remove(application);
    }

    public void clean(DeploymentContext dc) {
        super.clean(dc);
        UndeployCommandParameters params = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        this.downloadInfo.clearArtifacts(params.name);
    }

    synchronized void addContentToHTTPAdapter(String appName, AppClientServerApplication contributor, Properties tokens, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent) throws EndpointRegistrationException, IOException {
        AppClientHTTPAdapter adapter = this.httpAdapters.get(appName);
        if (adapter == null) {
            String contextRoot = NamingConventions.contextRootForAppAdapter(appName);
            this.addAdapter(appName, contextRoot, staticContent, dynamicContent, tokens, contributor);
            this.addContributor(appName, contributor);
        } else {
            adapter.addContentIfAbsent(staticContent, dynamicContent);
        }
    }

    private String chooseContextRoot(ApplicationClientDescriptor acd, String appName) {
        String contextRoot = NamingConventions.contextRootForAppAdapter(appName);
        JavaWebStartAccessDescriptor jws = acd.getJavaWebStartAccessDescriptor();
        if (jws != null && jws.getContextRoot() != null) {
            contextRoot = jws.getContextRoot();
        }
        return contextRoot;
    }

    synchronized void addAdapter(String appName, String contextRoot, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, AppClientServerApplication contributor) throws IOException, EndpointRegistrationException {
        if (this.systemAdapter == null) {
            this.systemAdapter = this.startSystemContentAdapter();
        }
        String userFriendlyContextRoot = this.userFriendlyContextRoot(contributor);
        AppClientHTTPAdapter adapter = new AppClientHTTPAdapter(contextRoot, userFriendlyContextRoot, staticContent, dynamicContent, tokens, this.serverEnv.getDomainRoot(), new File(this.installRootURI), this.iiopService);
        this.httpAdapters.put(appName, adapter);
        this.requestDispatcher.registerEndpoint(contextRoot, (Adapter)adapter, null);
        this.requestDispatcher.registerEndpoint(userFriendlyContextRoot, (Adapter)adapter, null);
        this.registeredContextRoots.put(appName, Arrays.asList(contextRoot, userFriendlyContextRoot));
        this.logger.fine("Registered at context roots " + contextRoot + "," + userFriendlyContextRoot);
    }

    private String userFriendlyContextRoot(AppClientServerApplication contributor) {
        String ufContextRoot = NamingConventions.defaultUserFriendlyContextRoot(contributor.getDescriptor());
        Properties p = contributor.dc().getAppProps();
        String overridingContextRoot = null;
        if (contributor.getDescriptor().getApplication().isVirtual()) {
            overridingContextRoot = p.getProperty(JAVA_WEB_START_CONTEXT_ROOT_PROPERTY_NAME);
        } else {
            String uriToNestedClient = NamingConventions.uriToNestedClient(contributor.getDescriptor());
            overridingContextRoot = p.getProperty("java-web-start-context-root." + uriToNestedClient);
        }
        if (overridingContextRoot != null) {
            ufContextRoot = overridingContextRoot;
        }
        return ufContextRoot;
    }

    public synchronized AutoSignedContent appLevelSignedSystemContent(String relativePathToSystemJar, String alias) {
        String key = this.keyToAppLevelSignedSystemContentMap(relativePathToSystemJar, alias);
        AutoSignedContent result = this.appLevelSignedSystemContent.get(key);
        if (result == null) {
            File unsignedFile = new File(this.umbrellaRoot, relativePathToSystemJar);
            File signedFile = new File(this.domainLevelSignedJARsRoot, key);
            result = new AutoSignedContent(unsignedFile, signedFile, alias, this.jarSigner);
        }
        return result;
    }

    private String keyToAppLevelSignedSystemContentMap(String relativePathToSystemJar, String alias) {
        return alias + "/" + relativePathToSystemJar;
    }

    private String defaultSigningAlias() {
        return DEFAULT_ALIAS;
    }

    public String contextRootForAppAdapter(String appName) {
        AppClientHTTPAdapter adapter = this.httpAdapters.get(appName);
        if (adapter != null) {
            return adapter.contextRoot();
        }
        return null;
    }

    synchronized void addContributor(String appName, AppClientServerApplication contributor) {
        Set<AppClientServerApplication> contributors = this.contributingAppClients.get(appName);
        if (contributors == null) {
            contributors = new HashSet<AppClientServerApplication>();
            this.contributingAppClients.put(appName, contributors);
        }
        contributors.add(contributor);
    }

    synchronized void removeContributor(String appName, AppClientServerApplication contributor) throws EndpointRegistrationException {
        Set<AppClientServerApplication> contributors = this.contributingAppClients.get(appName);
        if (contributors == null) {
            return;
        }
        contributors.remove(contributor);
        if (contributors.isEmpty()) {
            this.contributingAppClients.remove(appName);
            this.removeAdapter(appName, contributor);
        }
    }

    synchronized void removeAdapter(String appName, AppClientServerApplication contributor) throws EndpointRegistrationException {
        this.httpAdapters.remove(appName);
        this.requestDispatcher.unregisterEndpoint(NamingConventions.contextRootForAppAdapter(appName));
        this.requestDispatcher.unregisterEndpoint(this.userFriendlyContextRoot(contributor));
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        if (dc.getModuleMetaData(ApplicationClientDescriptor.class) == null) {
            return;
        }
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        try {
            AppClientArchivist archivist = (AppClientArchivist)this.habitat.getComponent(AppClientArchivist.class);
            AppClientDeployerHelper helper = this.createAndSaveHelper(dc, archivist, this.gfClientModuleClassLoader);
            helper.prepareJARs();
            this.downloadInfo.addArtifacts(params.name(), helper.earLevelDownloads());
            this.downloadInfo.addArtifacts(params.name(), helper.clientLevelDownloads());
        }
        catch (Exception ex) {
            throw new DeploymentException((Throwable)ex);
        }
    }

    private AppClientDeployerHelper createAndSaveHelper(DeploymentContext dc, AppClientArchivist archivist, ClassLoader clientModuleLoader) throws IOException {
        AppClientDeployerHelper h = AppClientDeployerHelper.newInstance(dc, archivist, clientModuleLoader, this.defaultSigningAlias());
        dc.addTransientAppMetaData(HELPER_KEY_NAME + this.moduleURI(dc), (Object)h.proxy());
        return h;
    }

    private AppClientDeployerHelper savedHelper(DeploymentContext dc) {
        String key = HELPER_KEY_NAME + this.moduleURI(dc);
        AppClientDeployerHelper h = ((AppClientDeployerHelper.Proxy)dc.getTransientAppMetaData(key, AppClientDeployerHelper.Proxy.class)).helper();
        if (h == null) {
            h = (AppClientDeployerHelper)dc.getTransientAppMetaData(key, StandaloneAppClientDeployerHelper.class);
        }
        return h;
    }

    private String moduleURI(DeploymentContext dc) {
        ApplicationClientDescriptor acd = (ApplicationClientDescriptor)dc.getModuleMetaData(ApplicationClientDescriptor.class);
        return acd.getModuleDescriptor().getArchiveUri();
    }

    private static String generatedEARFacadeName(String earName) {
        return earName + "Client.jar";
    }

    private AppClientHTTPAdapter startSystemContentAdapter() {
        try {
            ArrayList<String> systemJARRelativeURIs = new ArrayList<String>();
            Map<String, StaticContent> staticSystemContent = this.initStaticContent(systemJARRelativeURIs);
            Map<String, DynamicContent> dynamicSystemContent = this.initDynamicContent(systemJARRelativeURIs);
            AppClientHTTPAdapter sysAdapter = new AppClientHTTPAdapter("/___JWSappclient/___system", "/___JWSappclient/___system", staticSystemContent, dynamicSystemContent, new Properties(), this.serverEnv.getDomainRoot(), new File(this.installRootURI), this.iiopService);
            this.requestDispatcher.registerEndpoint("/___JWSappclient/___system", (Adapter)sysAdapter, null);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Registered system content adapter serving " + (Object)((Object)sysAdapter));
            }
            return sysAdapter;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "enterprise.deployment.appclient.jws.errStartSystemAdapter", e);
            return null;
        }
    }

    private Map<String, StaticContent> initStaticContent(List<String> systemJARRelativeURIs) throws IOException {
        HashMap<String, StaticContent> result = new HashMap<String, StaticContent>();
        File gfClientJAR = new File(new File(this.installRootURI.getRawPath(), "modules"), "gf-client.jar");
        String classPathExpr = this.getGFClientModuleClassPath(gfClientJAR);
        URI gfClientJARURI = gfClientJAR.toURI();
        result.put(this.systemPath(gfClientJARURI), new FixedContent(new File(gfClientJARURI)));
        for (String classPathElement : classPathExpr.split(" ")) {
            URI uri = gfClientJARURI.resolve(classPathElement);
            String systemPath = this.systemPath(uri);
            File candidateFile = new File(uri);
            String relativeSystemPath = this.relativeSystemPath(uri);
            if (!candidateFile.exists() || DO_NOT_SERVE_LIST.contains(relativeSystemPath)) continue;
            result.put(systemPath, new FixedContent(new File(uri)));
            systemJARRelativeURIs.add(this.relativeSystemPath(uri));
        }
        return result;
    }

    private Map<String, DynamicContent> initDynamicContent(List<String> systemJARRelativeURIs) throws IOException {
        HashMap<String, DynamicContent> result = new HashMap<String, DynamicContent>();
        String template = AppClientServerApplication.textFromURL("/org/glassfish/appclient/server/core/jws/templates/systemJarsDocumentTemplate.jnlp");
        StringBuilder sb = new StringBuilder();
        for (String relativeURIString : systemJARRelativeURIs) {
            sb.append("<jar href=\"" + relativeURIString + "\"/>").append(LINE_SEP);
        }
        Properties p = new Properties();
        p.setProperty("system.jars", sb.toString());
        String replacedText = Util.replaceTokens(template, p);
        result.put(NamingConventions.systemJNLPURI(), new SimpleDynamicContentImpl(replacedText, "jnlp"));
        return result;
    }

    private String systemPath(URI systemFileURI) {
        return this.relativeSystemPath(systemFileURI);
    }

    private String relativeSystemPath(URI systemFileURI) {
        return this.umbrellaRootURI.relativize(systemFileURI).getPath();
    }

    private String getGFClientModuleClassPath(File gfClientJAR) throws IOException {
        JarFile jf = new JarFile(gfClientJAR);
        Manifest mf = jf.getManifest();
        Attributes mainAttrs = mf.getMainAttributes();
        return mainAttrs.getValue(Attributes.Name.CLASS_PATH);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList unprocessedEvents = new ArrayList();
        for (AppClientServerApplication listener : this.appClientApps) {
            UnprocessedChangeEvents unprocessedEventsFromOneListener = listener.changed(events);
            if (unprocessedEventsFromOneListener == null) continue;
            unprocessedEvents.addAll(unprocessedEventsFromOneListener.getUnprocessed());
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }
}

